/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.sql.ResultSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.adempiere.base.IDocFactory;
import org.adempiere.base.IMappedDocumentFactory;
import org.compiere.acct.Doc;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MTable;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.osgi.service.component.annotations.Component;

@Component(name="org.adempiere.base.MappedDocumentFactory", service={IDocFactory.class, IMappedDocumentFactory.class}, immediate=true, property={"service.ranking:Integer=1", "gaap=*"})
public class MappedDocumentFactory
implements IDocFactory,
IMappedDocumentFactory {
    private final ConcurrentHashMap<String, Function<IMappedDocumentFactory.Parameter, ? extends Doc>> documentMap = new ConcurrentHashMap();

    @Override
    public Doc getDocument(MAcctSchema as, int AD_Table_ID, ResultSet rs, String trxName) {
        String tableName = MTable.getTableName(Env.getCtx(), AD_Table_ID);
        String key = tableName + "|" + as.getGAAP();
        Function<IMappedDocumentFactory.Parameter, ? extends Doc> function = this.documentMap.get(key);
        if (function != null) {
            return function.apply(new IMappedDocumentFactory.Parameter(as, rs, trxName));
        }
        key = tableName + "|*";
        function = this.documentMap.get(key);
        if (function != null) {
            return function.apply(new IMappedDocumentFactory.Parameter(as, rs, trxName));
        }
        return null;
    }

    @Override
    public void addMapping(String gaap, String tableName, Function<IMappedDocumentFactory.Parameter, ? extends Doc> supplier) {
        StringBuilder key = new StringBuilder();
        key.append(tableName).append("|");
        if (Util.isEmpty(gaap, true)) {
            key.append("*");
        } else {
            key.append(gaap);
        }
        this.documentMap.put(key.toString(), supplier);
    }

    @Override
    public void removeMapping(String gaap, String tableName) {
        StringBuilder key = new StringBuilder();
        key.append(tableName).append("|");
        if (Util.isEmpty(gaap, true)) {
            key.append("*");
        } else {
            key.append(gaap);
        }
        this.documentMap.remove(key.toString());
    }
}

