/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.util.Util;

public class ClasspathMultiReleaseJar
extends ClasspathJar {
    private static final String META_INF_VERSIONS = "META-INF/versions/";
    private static final int META_INF_LENGTH = "META-INF/versions/".length();
    private volatile String[] supportedVersions;

    ClasspathMultiReleaseJar(IFile resource, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath, String compliance) {
        super(resource, accessRuleSet, externalAnnotationPath, isOnModulePath);
        this.compliance = compliance;
    }

    ClasspathMultiReleaseJar(String zipFilename, long lastModified, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath, String compliance) {
        super(zipFilename, lastModified, accessRuleSet, externalAnnotationPath, isOnModulePath);
        this.compliance = compliance;
    }

    public ClasspathMultiReleaseJar(ZipFile zipFile, AccessRuleSet accessRuleSet, boolean isOnModulePath, String compliance) {
        this(zipFile.getName(), 0L, accessRuleSet, null, isOnModulePath, compliance);
        this.zipFile = zipFile;
        this.closeZipFileAtEnd = true;
    }

    @Override
    IModule initializeModule() {
        IBinaryModule mod = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile file = new ZipFile(this.zipFilename);){
                ClassFileReader classfile = null;
                try {
                    String[] stringArray = this.supportedVersions(file);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String path = stringArray[n2];
                        classfile = ClassFileReader.read((ZipFile)file, (String)(String.valueOf(path.toString()) + '/' + "module-info.class"));
                        if (classfile == null) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    Util.log(e, "Failed to initialize module for: " + this);
                }
                if (classfile == null) {
                    classfile = ClassFileReader.read((ZipFile)file, (String)"module-info.class");
                }
                if (classfile != null) {
                    mod = classfile.getModuleDeclaration();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassFormatException e) {
            Util.log(e, "Failed to initialize module for: " + this);
        }
        return mod;
    }

    private static String[] initializeVersions(ZipFile zipFile, String compliance) {
        int earliestJavaVersion = 53;
        long latestJDK = CompilerOptions.versionToJdkLevel((String)compliance);
        int latestJavaVer = (int)(latestJDK >> 16);
        ArrayList<String> versions = new ArrayList<String>();
        int i = latestJavaVer;
        while (i >= earliestJavaVersion) {
            String name = META_INF_VERSIONS + (i - 44);
            ZipEntry entry = zipFile.getEntry(name);
            if (entry != null) {
                versions.add(name);
            }
            --i;
        }
        return versions.toArray(new String[versions.size()]);
    }

    private String[] supportedVersions(ZipFile file) {
        String[] versions = this.supportedVersions;
        if (versions == null) {
            versions = ClasspathMultiReleaseJar.initializeVersions(file, this.compliance);
            this.supportedVersions = versions;
        }
        return versions;
    }

    @Override
    protected String readJarContent(SimpleSet packageSet) {
        String modInfo = null;
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            if (fileName.startsWith(META_INF_VERSIONS) && fileName.length() > META_INF_LENGTH) {
                int i = fileName.indexOf(47, META_INF_LENGTH);
                fileName = fileName.substring(i + 1);
            } else if (fileName.startsWith("META-INF/")) continue;
            if (modInfo == null) {
                String className;
                int folderEnd = fileName.lastIndexOf(47);
                if ((className = fileName.substring(++folderEnd, fileName.length())).equalsIgnoreCase("module-info.class")) {
                    modInfo = fileName;
                }
            }
            ClasspathMultiReleaseJar.addToPackageSet(packageSet, fileName, false);
        }
        return modInfo;
    }

    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        if (!this.isPackage(qualifiedPackageName, moduleName)) {
            return null;
        }
        String[] stringArray = this.supportedVersions(this.zipFile);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String s = null;
            try {
                ClassFileReader reader;
                s = META_INF_VERSIONS + path + "/" + binaryFileName;
                ZipEntry entry = this.zipFile.getEntry(s);
                if (entry != null && (reader = ClassFileReader.read((ZipFile)this.zipFile, (String)s)) != null) {
                    char[] modName;
                    char[] cArray = modName = this.module == null ? null : this.module.name();
                    if (reader instanceof ClassFileReader) {
                        ClassFileReader classReader = reader;
                        if (classReader.moduleName == null) {
                            classReader.moduleName = modName;
                        } else {
                            modName = classReader.moduleName;
                        }
                    }
                    String fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
                    return this.createAnswer(fileNameWithoutExtension, (IBinaryType)reader, modName);
                }
            }
            catch (IOException | ClassFormatException e) {
                Util.log(e, "Failed to find class for: " + s + " in: " + this);
            }
            ++n2;
        }
        return super.findClass(binaryFileName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, asBinaryOnly, moduleNameFilter);
    }
}

