/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.zkoss.zk.ui.select.impl.Attribute;
import org.zkoss.zk.ui.select.impl.PseudoClass;
import org.zkoss.zk.ui.select.impl.PseudoElement;
import org.zkoss.zk.ui.select.impl.Selector;

public class SimpleSelectorSequence {
    private Selector.Combinator _combinator = Selector.Combinator.DESCENDANT;
    private String _type;
    private String _id;
    private Set<String> _classes = new LinkedHashSet<String>();
    private List<Attribute> _attributes = new LinkedList<Attribute>();
    private List<PseudoClass> _pseudoClasses = new LinkedList<PseudoClass>();
    private List<PseudoElement> _pseudoElements = new LinkedList<PseudoElement>();
    private Attribute _currAttribute;
    private PseudoClass _currPseudoClass;
    private List<Selectors> _toStringOrder = new LinkedList<Selectors>();

    public SimpleSelectorSequence() {
    }

    public SimpleSelectorSequence(String type) {
        this();
        this._type = type;
    }

    public Selector.Combinator getCombinator() {
        return this._combinator;
    }

    public String getType() {
        return this._type;
    }

    public String getId() {
        return this._id;
    }

    public Set<String> getClasses() {
        return Collections.unmodifiableSet(this._classes);
    }

    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this._attributes);
    }

    public List<PseudoClass> getPseudoClasses() {
        return Collections.unmodifiableList(this._pseudoClasses);
    }

    public List<PseudoElement> getPseudoElements() {
        return Collections.unmodifiableList(this._pseudoElements);
    }

    public void setCombinator(Selector.Combinator combinator) {
        this._combinator = combinator;
    }

    public void setType(String type) {
        this._type = type;
        this._toStringOrder.add(Selectors.TYPE);
    }

    public void setId(String id) {
        this._id = id;
        this._toStringOrder.add(Selectors.ID);
    }

    public void addClass(String clazz) {
        if (!this._classes.contains(clazz)) {
            this._classes.add(clazz);
            this._toStringOrder.add(Selectors.CLASS);
        }
    }

    public void addAttribute(String name) {
        this._currAttribute = new Attribute(name);
        this._attributes.add(this._currAttribute);
        this._toStringOrder.add(Selectors.ATTRIBUTE);
    }

    public void attachAttributeOperator(Attribute.Operator operator) {
        if (this._currAttribute == null) {
            throw new IllegalStateException();
        }
        this._currAttribute.setOperator(operator);
    }

    public void attachAttributeValue(String value) {
        this.attachAttributeValue(value, false);
    }

    public void attachAttributeValue(String value, boolean quoted) {
        if (this._currAttribute == null) {
            throw new IllegalStateException();
        }
        this._currAttribute.setValue(value, quoted);
    }

    public void attachAttributeQuote(boolean inQuote) {
        if (this._currAttribute == null) {
            throw new IllegalStateException();
        }
        this._currAttribute.setQuoted(inQuote);
    }

    public void addPseudoClass(String function) {
        this._currPseudoClass = new PseudoClass(function);
        this._pseudoClasses.add(this._currPseudoClass);
        this._toStringOrder.add(Selectors.PSEUDO_CLASS);
    }

    public void attachPseudoClassParameter(String parameter) {
        if (this._currPseudoClass == null) {
            throw new IllegalStateException();
        }
        this._currPseudoClass.addParameter(parameter);
    }

    public void addPseudoElement(String source) {
        this._pseudoElements.add(new PseudoElement(source));
        this._toStringOrder.add(Selectors.PSEUDO_ELEMENT);
    }

    public String toString() {
        if (this._type == null && this._id == null && this._classes.isEmpty() && this._pseudoClasses.isEmpty() && this._attributes.isEmpty() && this._pseudoElements.isEmpty()) {
            return "*";
        }
        StringBuffer sb = new StringBuffer();
        Iterator<String> classIter = null;
        if (!this._classes.isEmpty()) {
            classIter = this._classes.iterator();
        }
        Iterator<Attribute> attrIter = null;
        if (!this._attributes.isEmpty()) {
            attrIter = this._attributes.iterator();
        }
        Iterator<PseudoClass> pseudoClassIter = null;
        if (!this._pseudoClasses.isEmpty()) {
            pseudoClassIter = this._pseudoClasses.iterator();
        }
        Iterator<PseudoElement> pasueoElemIter = null;
        if (!this._pseudoElements.isEmpty()) {
            pasueoElemIter = this._pseudoElements.iterator();
        }
        for (Selectors s : this._toStringOrder) {
            switch (s) {
                case TYPE: {
                    sb.append(this._type == null ? "" : this._type.toString());
                    break;
                }
                case ID: {
                    if (this._id == null) break;
                    sb.append('#').append(this._id);
                    break;
                }
                case CLASS: {
                    if (classIter == null || !classIter.hasNext()) break;
                    sb.append('.').append(classIter.next());
                    break;
                }
                case ATTRIBUTE: {
                    if (attrIter == null || !attrIter.hasNext()) break;
                    sb.append(attrIter.next());
                    break;
                }
                case PSEUDO_CLASS: {
                    if (pseudoClassIter == null || !pseudoClassIter.hasNext()) break;
                    sb.append(pseudoClassIter.next());
                    break;
                }
                case PSEUDO_ELEMENT: {
                    if (pasueoElemIter == null || !pasueoElemIter.hasNext()) break;
                    sb.append(pasueoElemIter.next());
                }
            }
        }
        return sb.toString();
    }

    private static enum Selectors {
        TYPE,
        ID,
        CLASS,
        ATTRIBUTE,
        PSEUDO_CLASS,
        PSEUDO_ELEMENT;

    }
}

