/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hwpf.usermodel;

import org.zkoss.poi.hwpf.HWPFOldDocument;
import org.zkoss.poi.hwpf.model.SEPX;
import org.zkoss.poi.hwpf.usermodel.Range;
import org.zkoss.poi.hwpf.usermodel.SectionProperties;

public final class Section
extends Range {
    private SectionProperties _props;

    public Section(SEPX sepx, Range parent) {
        super(Math.max(parent._start, sepx.getStart()), Math.min(parent._end, sepx.getEnd()), parent);
        this._props = parent.getDocument() instanceof HWPFOldDocument ? new SectionProperties() : sepx.getSectionProperties();
    }

    public Object clone() throws CloneNotSupportedException {
        Section s = (Section)super.clone();
        s._props = (SectionProperties)this._props.clone();
        return s;
    }

    public int getDistanceBetweenColumns() {
        return this._props.getDxaColumns();
    }

    public int getMarginBottom() {
        return this._props.getDyaBottom();
    }

    public int getMarginLeft() {
        return this._props.getDxaLeft();
    }

    public int getMarginRight() {
        return this._props.getDxaRight();
    }

    public int getMarginTop() {
        return this._props.getDyaTop();
    }

    public int getNumColumns() {
        return this._props.getCcolM1() + 1;
    }

    public int getPageHeight() {
        return this._props.getYaPage();
    }

    public int getPageWidth() {
        return this._props.getXaPage();
    }

    public boolean isColumnsEvenlySpaced() {
        return this._props.getFEvenlySpaced();
    }

    @Override
    public String toString() {
        return "Section [" + this.getStartOffset() + "; " + this.getEndOffset() + ")";
    }

    @Override
    public int type() {
        return 2;
    }
}

