/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api.impl;

import io.keikai.api.Range;
import io.keikai.api.model.Book;
import io.keikai.api.model.CellStyle;
import io.keikai.api.model.Color;
import io.keikai.api.model.EditableCellStyle;
import io.keikai.api.model.EditableFont;
import io.keikai.api.model.Font;
import io.keikai.api.model.impl.BookImpl;
import io.keikai.api.model.impl.ColorImpl;
import io.keikai.api.model.impl.EditableCellStyleImpl;
import io.keikai.api.model.impl.EditableFontImpl;
import io.keikai.api.model.impl.EnumUtil;
import io.keikai.api.model.impl.FontImpl;
import io.keikai.api.model.impl.SimpleRef;
import io.keikai.model.SBook;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColor;
import io.keikai.model.SFont;
import io.keikai.model.util.FontMatcher;
import java.io.Serializable;

class CellStyleHelperImpl
implements Range.CellStyleHelper,
Serializable {
    private static final long serialVersionUID = 5913867573087033877L;
    private Book _book;

    public CellStyleHelperImpl(Book book) {
        this._book = book;
    }

    @Override
    public EditableCellStyle createCellStyle(CellStyle src) {
        SBook book = ((BookImpl)this._book).getNative();
        EditableCellStyleImpl style = new EditableCellStyleImpl(((BookImpl)this._book).getRef(), new SimpleRef<SCellStyle>(book.createCellStyle(true)));
        if (src != null) {
            style.copyAttributeFrom(src);
        }
        return style;
    }

    @Override
    public EditableFont createFont(Font src) {
        SBook book = ((BookImpl)this._book).getNative();
        SFont font = book.createFont(true);
        EditableFontImpl nf = new EditableFontImpl(((BookImpl)this._book).getRef(), new SimpleRef<SFont>(font));
        if (src != null) {
            nf.copyAttributeFrom(src);
        }
        return nf;
    }

    @Override
    public Color createColorFromHtmlColor(String htmlColor) {
        Book book = this._book;
        return new ColorImpl(((BookImpl)book).getRef(), new SimpleRef<SColor>(((BookImpl)book).getNative().createColor(htmlColor)));
    }

    @Override
    public Font findFont(Font.Boldweight boldweight, Color color, int fontHeightPoints, String fontName, boolean italic, boolean strikeout, Font.TypeOffset typeOffset, Font.Underline underline) {
        SBook book = ((BookImpl)this._book).getNative();
        FontMatcher fm = new FontMatcher();
        fm.setBoldweight(EnumUtil.toFontBoldweight(boldweight));
        fm.setColor(color.getHtmlColor());
        fm.setHeightPoints(fontHeightPoints);
        fm.setName(fontName);
        fm.setItalic(italic);
        fm.setStrikeout(strikeout);
        fm.setTypeOffset(EnumUtil.toFontTypeOffset(typeOffset));
        fm.setUnderline(EnumUtil.toFontUnderline(underline));
        SFont font = book.searchFont(fm);
        return font == null ? null : new FontImpl(((BookImpl)this._book).getRef(), new SimpleRef<SFont>(font));
    }

    @Override
    public boolean isAvailable(CellStyle style) {
        return true;
    }
}

