/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SFont;
import io.keikai.model.SRichText;
import io.keikai.model.impl.AbstractFontAdv;
import io.keikai.model.impl.AbstractRichTextAdv;
import io.keikai.model.impl.SegmentImpl;
import io.keikai.model.util.Validations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.zkoss.lang.Objects;

public class RichTextImpl
extends AbstractRichTextAdv {
    private static final long serialVersionUID = 1L;
    List<SegmentImpl> _segments = new ArrayList<SegmentImpl>();

    @Override
    public String getText() {
        if (this._segments.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (SRichText.Segment segment : this._segments) {
            sb.append(segment.getText());
        }
        return sb.toString();
    }

    @Override
    public List<SRichText.Segment> getSegments() {
        return Collections.unmodifiableList(this._segments);
    }

    @Override
    public void addSegment(String text, SFont font) {
        Validations.argNotNull(text);
        if ("".equals(text)) {
            return;
        }
        if (!this._segments.isEmpty()) {
            int idx = this._segments.size() - 1;
            SRichText.Segment seg = this._segments.get(idx);
            if ("\n".equals(text) || Objects.equals((Object)seg.getFont(), (Object)font)) {
                this._segments.set(idx, new SegmentImpl(seg.getText() + text, seg.getFont()));
                return;
            }
        }
        this._segments.add(new SegmentImpl(text, font));
    }

    @Override
    public void clearSegments() {
        this._segments.clear();
    }

    @Override
    public SFont getFont() {
        if (this._segments.size() == 0) {
            return null;
        }
        return this._segments.get(0).getFont();
    }

    @Override
    public AbstractRichTextAdv clone() {
        return this.cloneRichText(null);
    }

    @Override
    public int getHeightPoints() {
        int highest = 0;
        for (SRichText.Segment ss : this.getSegments()) {
            int p = ss.getFont().getHeightPoints();
            if (p <= highest) continue;
            highest = p;
        }
        return highest;
    }

    @Override
    AbstractRichTextAdv cloneRichText(SBook book) {
        RichTextImpl richText = new RichTextImpl();
        for (SRichText.Segment segment : this._segments) {
            AbstractFontAdv font = (AbstractFontAdv)segment.getFont();
            richText.addSegment(segment.getText(), font == null ? null : font.cloneFont(book));
        }
        return richText;
    }
}

