/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.dto;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.json.internal.JsonSerializable;

class EvictionConfigDTO
implements JsonSerializable {
    private EvictionConfig evictionConfig;

    EvictionConfigDTO() {
    }

    EvictionConfigDTO(EvictionConfig evictionConfig) {
        this.evictionConfig = evictionConfig;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject().add("size", this.evictionConfig.getSize()).add("maxSizePolicy", this.evictionConfig.getMaxSizePolicy().toString()).add("evictionPolicy", this.evictionConfig.getEvictionPolicy().toString());
        String comparatorClassName = this.evictionConfig.getComparatorClassName();
        if (!StringUtil.isNullOrEmpty(comparatorClassName)) {
            root.add("comparatorClassName", comparatorClassName);
        }
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.evictionConfig = new EvictionConfig();
        this.evictionConfig.setSize(JsonUtil.getInt(json, "size"));
        this.evictionConfig.setMaxSizePolicy(MaxSizePolicy.valueOf(JsonUtil.getString(json, "maxSizePolicy")));
        this.evictionConfig.setEvictionPolicy(EvictionPolicy.valueOf(JsonUtil.getString(json, "evictionPolicy")));
        JsonValue comparatorClassName = json.get("comparatorClassName");
        if (comparatorClassName != null && !comparatorClassName.isNull()) {
            this.evictionConfig.setComparatorClassName(comparatorClassName.asString());
        }
    }

    public EvictionConfig getConfig() {
        return this.evictionConfig;
    }
}

