/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;

public final class TransactionRollbackCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1377024;
    public static final int RESPONSE_MESSAGE_TYPE = 1377025;
    private static final int REQUEST_TRANSACTION_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_THREAD_ID_FIELD_OFFSET = 33;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 41;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private TransactionRollbackCodec() {
    }

    public static ClientMessage encodeRequest(UUID transactionId, long threadId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Transaction.Rollback");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[41], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1377024);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, transactionId);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 33, threadId);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.transactionId = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        request.threadId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 33);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1377025);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public UUID transactionId;
        public long threadId;
    }
}

