/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nonnull;

public final class WrappingProcessorSupplier
implements ProcessorSupplier,
IdentifiedDataSerializable {
    private ProcessorSupplier wrapped;
    private FunctionEx<Processor, Processor> wrapperSupplier;

    public WrappingProcessorSupplier() {
    }

    public WrappingProcessorSupplier(ProcessorSupplier wrapped, FunctionEx<Processor, Processor> wrapperSupplier) {
        this.wrapped = wrapped;
        this.wrapperSupplier = wrapperSupplier;
    }

    @Override
    @Nonnull
    public Collection<? extends Processor> get(int count) {
        Collection<? extends Processor> processors = this.wrapped.get(count);
        return Util.toList(processors, this.wrapperSupplier);
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        this.wrapped.init(context);
    }

    @Override
    public boolean initIsCooperative() {
        return this.wrapped.initIsCooperative();
    }

    @Override
    public boolean closeIsCooperative() {
        return this.wrapped.closeIsCooperative();
    }

    @Override
    public void close(Throwable error) throws Exception {
        this.wrapped.close(error);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.wrapped);
        out.writeObject(this.wrapperSupplier);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.wrapped = (ProcessorSupplier)in.readObject();
        this.wrapperSupplier = (FunctionEx)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 50;
    }
}

