/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import javax.annotation.Nullable;

public final class ReplicatedMapAddEntryListenerCodec {
    public static final int REQUEST_MESSAGE_TYPE = 855296;
    public static final int RESPONSE_MESSAGE_TYPE = 855297;
    private static final int REQUEST_LOCAL_ONLY_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 17;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 30;
    private static final int EVENT_ENTRY_EVENT_TYPE_FIELD_OFFSET = 16;
    private static final int EVENT_ENTRY_UUID_FIELD_OFFSET = 20;
    private static final int EVENT_ENTRY_NUMBER_OF_AFFECTED_ENTRIES_FIELD_OFFSET = 37;
    private static final int EVENT_ENTRY_INITIAL_FRAME_SIZE = 41;
    private static final int EVENT_ENTRY_MESSAGE_TYPE = 855298;

    private ReplicatedMapAddEntryListenerCodec() {
    }

    public static ClientMessage encodeRequest(String name, boolean localOnly) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("ReplicatedMap.AddEntryListener");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[17], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 855296);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, localOnly);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.localOnly = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.name = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[30], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 855297);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 13, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static UUID decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator.next();
        return FixedSizeTypesCodec.decodeUUID(initialFrame.content, 13);
    }

    public static ClientMessage encodeEntryEvent(@Nullable Data key, @Nullable Data value, @Nullable Data oldValue, @Nullable Data mergingValue, int eventType, UUID uuid, int numberOfAffectedEntries) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[41], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 855298);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, eventType);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 20, uuid);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 37, numberOfAffectedEntries);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, key, DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, value, DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, oldValue, DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, mergingValue, DataCodec::encode);
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
            if (messageType == 855298) {
                ClientMessage.Frame initialFrame = iterator.next();
                int eventType = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
                UUID uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 20);
                int numberOfAffectedEntries = FixedSizeTypesCodec.decodeInt(initialFrame.content, 37);
                Data key = CodecUtil.decodeNullable(iterator, DataCodec::decode);
                Data value = CodecUtil.decodeNullable(iterator, DataCodec::decode);
                Data oldValue = CodecUtil.decodeNullable(iterator, DataCodec::decode);
                Data mergingValue = CodecUtil.decodeNullable(iterator, DataCodec::decode);
                this.handleEntryEvent(key, value, oldValue, mergingValue, eventType, uuid, numberOfAffectedEntries);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handleEntryEvent(@Nullable Data var1, @Nullable Data var2, @Nullable Data var3, @Nullable Data var4, int var5, UUID var6, int var7);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public boolean localOnly;
    }
}

