/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.impl.AbstractPartitionPrimaryReplicaAntiEntropyTask;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Collection;

final class PartitionPrimaryReplicaAntiEntropyTask
extends AbstractPartitionPrimaryReplicaAntiEntropyTask {
    private final Runnable afterRun;

    PartitionPrimaryReplicaAntiEntropyTask(NodeEngineImpl nodeEngine, int partitionId, Runnable afterRun) {
        super(nodeEngine, partitionId);
        this.afterRun = afterRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            InternalPartition partition = this.partitionService.getPartition(this.partitionId, false);
            if (!partition.isLocal() || partition.isMigrating()) {
                return;
            }
            Collection<ServiceNamespace> namespaces = this.retainAndGetNamespaces();
            for (int index = 1; index < 7; ++index) {
                PartitionReplica replica = partition.getReplica(index);
                if (replica == null) continue;
                this.invokePartitionBackupReplicaAntiEntropyOp(index, replica, namespaces, null);
            }
        }
        finally {
            if (this.afterRun != null) {
                this.afterRun.run();
            }
        }
    }
}

