/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hwpf.usermodel;

import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.LittleEndian;

public final class BorderCode
implements Cloneable {
    public static final int SIZE = 4;
    private short _info;
    private static final BitField _dptLineWidth = BitFieldFactory.getInstance(255);
    private static final BitField _brcType = BitFieldFactory.getInstance(65280);
    private short _info2;
    private static final BitField _ico = BitFieldFactory.getInstance(255);
    private static final BitField _dptSpace = BitFieldFactory.getInstance(7936);
    private static final BitField _fShadow = BitFieldFactory.getInstance(8192);
    private static final BitField _fFrame = BitFieldFactory.getInstance(16384);

    public BorderCode() {
    }

    public BorderCode(byte[] buf, int offset) {
        this._info = LittleEndian.getShort(buf, offset);
        this._info2 = LittleEndian.getShort(buf, offset + 2);
    }

    public void serialize(byte[] buf, int offset) {
        LittleEndian.putShort(buf, offset, this._info);
        LittleEndian.putShort(buf, offset + 2, this._info2);
    }

    public int toInt() {
        byte[] buf = new byte[4];
        this.serialize(buf, 0);
        return LittleEndian.getInt(buf);
    }

    public boolean isEmpty() {
        return this._info == 0 && this._info2 == 0 || this._info == -1;
    }

    public boolean equals(Object o) {
        BorderCode brc = (BorderCode)o;
        return this._info == brc._info && this._info2 == brc._info2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int getLineWidth() {
        return _dptLineWidth.getShortValue(this._info);
    }

    public void setLineWidth(int lineWidth) {
        _dptLineWidth.setValue(this._info, lineWidth);
    }

    public int getBorderType() {
        return _brcType.getShortValue(this._info);
    }

    public void setBorderType(int borderType) {
        _brcType.setValue(this._info, borderType);
    }

    public short getColor() {
        return _ico.getShortValue(this._info2);
    }

    public void setColor(short color) {
        _ico.setValue(this._info2, color);
    }

    public int getSpace() {
        return _dptSpace.getShortValue(this._info2);
    }

    public void setSpace(int space) {
        _dptSpace.setValue(this._info2, space);
    }

    public boolean isShadow() {
        return _fShadow.getValue(this._info2) != 0;
    }

    public void setShadow(boolean shadow) {
        _fShadow.setValue(this._info2, shadow ? 1 : 0);
    }

    public boolean isFrame() {
        return _fFrame.getValue(this._info2) != 0;
    }

    public void setFrame(boolean frame) {
        _fFrame.setValue(this._info2, frame ? 1 : 0);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[BRC] EMPTY";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("[BRC]\n");
        buffer.append("        .dptLineWidth         = ");
        buffer.append(" (").append(this.getLineWidth()).append(" )\n");
        buffer.append("        .brcType              = ");
        buffer.append(" (").append(this.getBorderType()).append(" )\n");
        buffer.append("        .ico                  = ");
        buffer.append(" (").append(this.getColor()).append(" )\n");
        buffer.append("        .dptSpace             = ");
        buffer.append(" (").append(this.getSpace()).append(" )\n");
        buffer.append("        .fShadow              = ");
        buffer.append(" (").append(this.isShadow()).append(" )\n");
        buffer.append("        .fFrame               = ");
        buffer.append(" (").append(this.isFrame()).append(" )\n");
        return buffer.toString();
    }
}

