/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import org.zkoss.poi.ss.usermodel.BuiltinFormats;
import org.zkoss.poi.ss.usermodel.DataFormat;
import org.zkoss.poi.ss.usermodel.ZssContext;
import org.zkoss.poi.xssf.model.StylesTable;

public class XSSFDataFormat
implements DataFormat {
    private StylesTable stylesSource;

    protected XSSFDataFormat(StylesTable stylesSource) {
        this.stylesSource = stylesSource;
    }

    @Override
    public short getFormat(String format) {
        int idx = BuiltinFormats.getBuiltinFormat(format);
        if (idx == -1) {
            idx = this.stylesSource.putNumberFormat(format);
        }
        return (short)idx;
    }

    @Override
    public String getFormat(short index) {
        String fmt = this.stylesSource.getNumberFormatAt(index);
        if (fmt == null) {
            fmt = BuiltinFormats.getBuiltinFormat(index, ZssContext.getCurrent().getLocale());
        }
        return fmt;
    }

    @Override
    public String getRawFormat(short index) {
        String fmt = this.stylesSource.getNumberFormatAt(index);
        if (fmt == null) {
            fmt = BuiltinFormats.getBuiltinFormat(index);
        }
        return fmt;
    }

    @Override
    public short newFormat(String format) {
        return (short)this.stylesSource.putNumberFormat(format);
    }
}

