/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.format;

import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Matcher;
import org.zkoss.poi.ss.format.CellFormatPart;
import org.zkoss.poi.ss.format.CellFormatType;
import org.zkoss.poi.ss.format.CellFormatter;
import org.zkoss.util.Pair;

public class CellDateFormatter
extends CellFormatter {
    private boolean amPmUpper;
    private boolean showM;
    private boolean showAmPm;
    private final DateFormat dateFmt;
    private String sFmt;
    private static final long EXCEL_EPOCH_TIME;
    private static final Date EXCEL_EPOCH_DATE;

    static CellFormatter getFormatter(FormatterType ft, Locale locale) {
        Pair key = new Pair((Object)ft, (Object)locale);
        CellFormatter formatter = (CellFormatter)_formatters.get((Object)key);
        if (formatter != null) {
            return formatter;
        }
        switch (ft) {
            case SIMPLE_DATE: {
                formatter = new CellDateFormatter("mm/d/y", locale);
            }
        }
        _formatters.put((Object)key, (Object)formatter);
        return formatter;
    }

    public CellDateFormatter(String format, Locale locale) {
        super(format, locale);
        DatePartHandler partHandler = new DatePartHandler();
        StringBuffer descBuf = CellFormatPart.parseFormat(format, CellFormatType.DATE, partHandler);
        partHandler.finish(descBuf);
        String ptrn = descBuf.toString().replaceAll("((y)(?!y))(?<!yy)", "yy");
        this.dateFmt = new SimpleDateFormat(ptrn, locale);
    }

    @Override
    public void formatValue(StringBuffer toAppendTo, Object value) {
        if (value == null) {
            value = 0.0;
        }
        if (value instanceof Number) {
            Number num = (Number)value;
            double v = num.doubleValue();
            value = v == 0.0 ? EXCEL_EPOCH_DATE : new Date((long)((double)EXCEL_EPOCH_TIME + v));
        }
        AttributedCharacterIterator it = this.dateFmt.formatToCharacterIterator(value);
        boolean doneAm = false;
        boolean doneMillis = false;
        it.first();
        char ch = it.first();
        while (ch != '\uffff') {
            if (it.getAttribute(DateFormat.Field.MILLISECOND) != null) {
                if (!doneMillis) {
                    Date dateObj = (Date)value;
                    int pos = toAppendTo.length();
                    Formatter formatter = new Formatter(toAppendTo, this.locale);
                    long msecs = dateObj.getTime() % 1000L;
                    formatter.format(this.locale, this.sFmt, (double)msecs / 1000.0);
                    toAppendTo.delete(pos, pos + 2);
                    doneMillis = true;
                }
            } else if (it.getAttribute(DateFormat.Field.AM_PM) != null) {
                if (!doneAm && this.showAmPm) {
                    if (Character.toUpperCase(ch) == 'A' || Character.toUpperCase(ch) == 'P') {
                        if (this.amPmUpper) {
                            toAppendTo.append(Character.toUpperCase(ch));
                            if (this.showM) {
                                toAppendTo.append('M');
                            }
                        } else {
                            toAppendTo.append(Character.toLowerCase(ch));
                            if (this.showM) {
                                toAppendTo.append('m');
                            }
                        }
                        doneAm = true;
                    } else {
                        toAppendTo.append(ch);
                    }
                }
            } else {
                toAppendTo.append(ch);
            }
            ch = it.next();
        }
    }

    @Override
    public void simpleValue(StringBuffer toAppendTo, Object value) {
        CellDateFormatter.getFormatter(FormatterType.SIMPLE_DATE, this.locale).formatValue(toAppendTo, value);
    }

    static {
        Calendar c = Calendar.getInstance();
        c.set(1904, 0, 1, 0, 0, 0);
        EXCEL_EPOCH_DATE = c.getTime();
        EXCEL_EPOCH_TIME = c.getTimeInMillis();
    }

    private class DatePartHandler
    implements CellFormatPart.PartHandler {
        private int mStart = -1;
        private int mLen;
        private int hStart = -1;
        private int hLen;
        private int sStart = -1;
        private boolean everMinute = false;

        private DatePartHandler() {
        }

        @Override
        public String handlePart(Matcher m, String part, CellFormatType type, StringBuffer desc) {
            int pos = desc.length();
            char firstCh = part.charAt(0);
            switch (firstCh) {
                case 'S': 
                case 's': {
                    if (!this.everMinute && this.mStart >= 0 && this.mLen <= 2) {
                        for (int i = 0; i < this.mLen; ++i) {
                            desc.setCharAt(this.mStart + i, 'm');
                        }
                        this.mStart = -1;
                        this.everMinute = true;
                    } else {
                        this.sStart = pos;
                    }
                    return part.toLowerCase();
                }
                case 'H': 
                case 'h': {
                    this.mStart = -1;
                    this.hStart = pos;
                    this.hLen = part.length();
                    return part.toLowerCase();
                }
                case 'D': 
                case 'd': {
                    this.mStart = -1;
                    if (part.length() <= 2) {
                        return part.toLowerCase();
                    }
                    return part.toLowerCase().replace('d', 'E');
                }
                case 'M': 
                case 'm': {
                    if (!(this.everMinute || this.hStart < 0 && this.sStart < 0 || part.length() > 2)) {
                        this.everMinute = true;
                        return part.toLowerCase();
                    }
                    this.mStart = pos;
                    this.mLen = part.length();
                    return part.toUpperCase();
                }
                case 'Y': 
                case 'y': {
                    this.mStart = -1;
                    if (part.length() == 3) {
                        part = "yyyy";
                    }
                    return part.toLowerCase();
                }
                case '0': {
                    this.mStart = -1;
                    int sLen = part.length();
                    CellDateFormatter.this.sFmt = "%0" + (sLen + 2) + "." + sLen + "f";
                    return part.replace('0', 'S');
                }
                case 'A': 
                case 'P': 
                case 'a': 
                case 'p': {
                    if (part.length() <= 1) break;
                    this.mStart = -1;
                    CellDateFormatter.this.showAmPm = true;
                    CellDateFormatter.this.showM = Character.toLowerCase(part.charAt(1)) == 'm';
                    CellDateFormatter.this.amPmUpper = CellDateFormatter.this.showM || Character.isUpperCase(part.charAt(0));
                    return "a";
                }
            }
            return null;
        }

        public void finish(StringBuffer toAppendTo) {
            if (this.hStart >= 0 && !CellDateFormatter.this.showAmPm) {
                for (int i = 0; i < this.hLen; ++i) {
                    toAppendTo.setCharAt(this.hStart + i, 'H');
                }
            }
        }
    }

    static enum FormatterType {
        SIMPLE_DATE;

    }
}

