/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.usermodel;

import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import org.zkoss.poi.ddf.DefaultEscherRecordFactory;
import org.zkoss.poi.ddf.EscherBSERecord;
import org.zkoss.poi.ddf.EscherComplexProperty;
import org.zkoss.poi.ddf.EscherContainerRecord;
import org.zkoss.poi.ddf.EscherOptRecord;
import org.zkoss.poi.ddf.EscherRecord;
import org.zkoss.poi.ddf.EscherSimpleProperty;
import org.zkoss.poi.hssf.record.CommonObjectDataSubRecord;
import org.zkoss.poi.hssf.record.EscherAggregate;
import org.zkoss.poi.hssf.record.ObjRecord;
import org.zkoss.poi.hssf.usermodel.HSSFAnchor;
import org.zkoss.poi.hssf.usermodel.HSSFClientAnchor;
import org.zkoss.poi.hssf.usermodel.HSSFPatriarch;
import org.zkoss.poi.hssf.usermodel.HSSFPictureData;
import org.zkoss.poi.hssf.usermodel.HSSFRow;
import org.zkoss.poi.hssf.usermodel.HSSFShape;
import org.zkoss.poi.hssf.usermodel.HSSFSimpleShape;
import org.zkoss.poi.ss.usermodel.ClientAnchor;
import org.zkoss.poi.ss.usermodel.Picture;
import org.zkoss.poi.ss.usermodel.PictureData;
import org.zkoss.poi.ss.util.ImageUtils;
import org.zkoss.poi.util.POILogFactory;
import org.zkoss.poi.util.POILogger;

public class HSSFPicture
extends HSSFSimpleShape
implements Picture {
    private static POILogger logger = POILogFactory.getLogger(HSSFPicture.class);
    public static final int PICTURE_TYPE_EMF = 2;
    public static final int PICTURE_TYPE_WMF = 3;
    public static final int PICTURE_TYPE_PICT = 4;
    public static final int PICTURE_TYPE_JPEG = 5;
    public static final int PICTURE_TYPE_PNG = 6;
    public static final int PICTURE_TYPE_DIB = 7;
    private static final float PX_DEFAULT = 32.0f;
    private static final float PX_MODIFIED = 36.56f;
    private static final int PX_ROW = 15;
    private String _name;
    private String _alt;

    public HSSFPicture(EscherContainerRecord spContainer, ObjRecord objRecord) {
        super(spContainer, objRecord);
    }

    public HSSFPicture(HSSFShape parent, HSSFAnchor anchor) {
        super(parent, anchor);
        super.setShapeType(75);
        CommonObjectDataSubRecord cod = (CommonObjectDataSubRecord)this.getObjRecord().getSubRecords().get(0);
        cod.setObjectType((short)8);
    }

    public int getPictureIndex() {
        EscherSimpleProperty property = (EscherSimpleProperty)this.getOptRecord().lookup(260);
        if (null == property) {
            return -1;
        }
        return property.getPropertyValue();
    }

    public void setPictureIndex(int pictureIndex) {
        this.setPropertyValue(new EscherSimpleProperty(260, false, true, pictureIndex));
    }

    @Override
    protected EscherContainerRecord createSpContainer() {
        EscherContainerRecord spContainer = super.createSpContainer();
        EscherOptRecord opt = (EscherOptRecord)spContainer.getChildById((short)-4085);
        opt.removeEscherProperty(462);
        opt.removeEscherProperty(511);
        spContainer.removeChildRecord((EscherRecord)spContainer.getChildById((short)-4083));
        return spContainer;
    }

    @Override
    public void resize(double scale) {
        HSSFClientAnchor anchor = (HSSFClientAnchor)this.getAnchor();
        anchor.setAnchorType(2);
        HSSFClientAnchor pref = this.getPreferredSize(scale);
        int row2 = anchor.getRow1() + (pref.getRow2() - pref.getRow1());
        int col2 = anchor.getCol1() + (pref.getCol2() - pref.getCol1());
        anchor.setCol2((short)col2);
        anchor.setDx1(0);
        anchor.setDx2(pref.getDx2());
        anchor.setRow2(row2);
        anchor.setDy1(0);
        anchor.setDy2(pref.getDy2());
    }

    @Override
    public void resize() {
        this.resize(1.0);
    }

    @Override
    public HSSFClientAnchor getPreferredSize() {
        return this.getPreferredSize(1.0);
    }

    public HSSFClientAnchor getPreferredSize(double scale) {
        HSSFClientAnchor anchor = (HSSFClientAnchor)this.getAnchor();
        Dimension size = this.getImageDimension();
        double scaledWidth = size.getWidth() * scale;
        double scaledHeight = size.getHeight() * scale;
        float w = 0.0f;
        w += this.getColumnWidthInPixels(anchor.getCol1()) * (1.0f - (float)anchor.getDx1() / 1024.0f);
        short col2 = (short)(anchor.getCol1() + 1);
        int dx2 = 0;
        while ((double)w < scaledWidth) {
            short s = col2;
            col2 = (short)(col2 + 1);
            w += this.getColumnWidthInPixels(s);
        }
        if ((double)w > scaledWidth) {
            col2 = (short)(col2 - 1);
            double cw = this.getColumnWidthInPixels(col2);
            double delta = (double)w - scaledWidth;
            dx2 = (int)((cw - delta) / cw * 1024.0);
        }
        anchor.setCol2(col2);
        anchor.setDx2(dx2);
        float h = 0.0f;
        h += (1.0f - (float)anchor.getDy1() / 256.0f) * this.getRowHeightInPixels(anchor.getRow1());
        int row2 = anchor.getRow1() + 1;
        int dy2 = 0;
        while ((double)h < scaledHeight) {
            h += this.getRowHeightInPixels(row2++);
        }
        if ((double)h > scaledHeight) {
            double ch = this.getRowHeightInPixels(--row2);
            double delta = (double)h - scaledHeight;
            dy2 = (int)((ch - delta) / ch * 256.0);
        }
        anchor.setRow2(row2);
        anchor.setDy2(dy2);
        return anchor;
    }

    private float getColumnWidthInPixels(int column) {
        int cw = this.getPatriarch().getSheet().getColumnWidth(column);
        float px = this.getPixelWidth(column);
        return (float)cw / px;
    }

    private float getRowHeightInPixels(int i) {
        HSSFRow row = this.getPatriarch().getSheet().getRow(i);
        float height = row != null ? (float)row.getHeight() : (float)this.getPatriarch().getSheet().getDefaultRowHeight();
        return height / 15.0f;
    }

    private float getPixelWidth(int column) {
        int def = this.getPatriarch().getSheet().getDefaultColumnWidth() * 256;
        int cw = this.getPatriarch().getSheet().getColumnWidth(column);
        return cw == def ? 32.0f : 36.56f;
    }

    public Dimension getImageDimension() {
        EscherBSERecord bse = this.getPatriarch().getSheet()._book.getBSERecord(this.getPictureIndex());
        byte[] data = bse.getBlipRecord().getPicturedata();
        byte type = bse.getBlipTypeWin32();
        return ImageUtils.getImageDimension(new ByteArrayInputStream(data), type);
    }

    @Override
    void afterInsert(HSSFPatriarch patriarch) {
        EscherAggregate agg = patriarch._getBoundAggregate();
        agg.associateShapeToObjRecord((EscherRecord)this.getEscherContainer().getChildById((short)-4079), this.getObjRecord());
        EscherBSERecord bse = patriarch.getSheet().getWorkbook().getWorkbook().getBSERecord(this.getPictureIndex());
        bse.setRef(bse.getRef() + 1);
    }

    public String getFileName() {
        EscherComplexProperty propFile = (EscherComplexProperty)this.getOptRecord().lookup(261);
        try {
            if (null == propFile) {
                return "";
            }
            return new String(propFile.getComplexData(), "UTF-16LE").trim();
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public void setFileName(String data) {
        try {
            EscherComplexProperty prop = new EscherComplexProperty(261, true, data.getBytes("UTF-16LE"));
            this.setPropertyValue(prop);
        }
        catch (UnsupportedEncodingException e) {
            logger.log(7, "Unsupported encoding: UTF-16LE");
        }
    }

    @Override
    public void setShapeType(int shapeType) {
        throw new IllegalStateException("Shape type can not be changed in " + this.getClass().getSimpleName());
    }

    @Override
    protected HSSFShape cloneShape() {
        EscherContainerRecord spContainer = new EscherContainerRecord();
        byte[] inSp = this.getEscherContainer().serialize();
        spContainer.fillFields(inSp, 0, new DefaultEscherRecordFactory());
        ObjRecord obj = (ObjRecord)this.getObjRecord().cloneViaReserialise();
        return new HSSFPicture(spContainer, obj);
    }

    @Override
    public PictureData getPictureData() {
        int pictureIndex = this.getPictureIndex();
        EscherBSERecord bseRecord = this.getPatriarch().getSheet().getWorkbook().getWorkbook().getBSERecord(pictureIndex);
        return bseRecord != null ? new HSSFPictureData(bseRecord) : null;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getAlt() {
        return this._alt;
    }

    public void setAlt(String alt) {
        this._alt = alt;
    }

    @Override
    public ClientAnchor getClientAnchor() {
        return (ClientAnchor)((Object)this.getAnchor());
    }

    @Override
    public String getPictureId() {
        return "" + this.getPictureIndex();
    }

    @Override
    public void setClientAnchor(ClientAnchor newanchor) {
        HSSFClientAnchor anchor = (HSSFClientAnchor)this.getAnchor();
        anchor.setCol1(newanchor.getCol1());
        anchor.setCol2(newanchor.getCol2());
        anchor.setDx1(newanchor.getDx1());
        anchor.setDx2(newanchor.getDx2());
        anchor.setDy1(newanchor.getDy1());
        anchor.setDy2(newanchor.getDy2());
        anchor.setRow1(newanchor.getRow1());
        anchor.setRow2(newanchor.getRow2());
    }
}

