/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record.chart;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;

public final class ScatterRecord
extends StandardRecord {
    public static final short sid = 4123;
    private short field_1_ratio;
    private short field_2_size;
    private short field_3_formatFlags;
    private static final BitField bubbles = BitFieldFactory.getInstance(1);
    private static final BitField negbubbles = BitFieldFactory.getInstance(2);
    private static final BitField shadow = BitFieldFactory.getInstance(4);

    public ScatterRecord() {
    }

    public ScatterRecord(RecordInputStream in) {
        this.field_1_ratio = in.readShort();
        this.field_2_size = in.readShort();
        this.field_3_formatFlags = in.readShort();
    }

    @Override
    protected int getDataSize() {
        return 6;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SCATTER]\n");
        buffer.append("    .ratio          = ").append("0x").append(HexDump.toHex(this.field_1_ratio)).append(" (").append(this.field_1_ratio).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .size           = ").append("0x").append(HexDump.toHex(this.field_2_size)).append(" (").append(this.field_2_size).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .formatFlags    = ").append("0x").append(HexDump.toHex(this.field_3_formatFlags)).append(" (").append(this.field_3_formatFlags).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .bubbles                  = ").append(this.isBubbles()).append('\n');
        buffer.append("         .negbubbles               = ").append(this.isNegBubbles()).append('\n');
        buffer.append("[/SCATTER]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.field_1_ratio);
        out.writeShort(this.field_2_size);
        out.writeShort(this.field_3_formatFlags);
    }

    @Override
    public short getSid() {
        return 4123;
    }

    @Override
    public Object clone() {
        ScatterRecord rec = new ScatterRecord();
        rec.field_1_ratio = this.field_1_ratio;
        rec.field_2_size = this.field_2_size;
        rec.field_3_formatFlags = this.field_3_formatFlags;
        return rec;
    }

    public short getFormatFlags() {
        return this.field_3_formatFlags;
    }

    public void setFormatFlags(short field_3_formatFlags) {
        this.field_3_formatFlags = field_3_formatFlags;
    }

    public short getRatio() {
        return this.field_1_ratio;
    }

    public void setRatio(short field_1_ratio) {
        this.field_1_ratio = field_1_ratio;
    }

    public short getSize() {
        return this.field_2_size;
    }

    public void setSize(short field_2_size) {
        this.field_2_size = field_2_size;
    }

    public void setNegBubbles(boolean value) {
        this.field_3_formatFlags = negbubbles.setShortBoolean(this.field_3_formatFlags, value);
    }

    public boolean isNegBubbles() {
        return negbubbles.isSet(this.field_3_formatFlags);
    }

    public void setBubbles(boolean value) {
        this.field_3_formatFlags = bubbles.setShortBoolean(this.field_3_formatFlags, value);
    }

    public boolean isBubbles() {
        return bubbles.isSet(this.field_3_formatFlags);
    }

    public void setShadow(boolean value) {
        this.field_3_formatFlags = shadow.setShortBoolean(this.field_3_formatFlags, value);
    }

    public boolean isShadow() {
        return shadow.isSet(this.field_3_formatFlags);
    }
}

