/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.hssf.record.common.FtrHeader;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.LittleEndianOutput;

public class PLVRecord
extends StandardRecord {
    private static final BitField pageLayoutView = BitFieldFactory.getInstance(1);
    private static final BitField rulerVisible = BitFieldFactory.getInstance(2);
    private static final BitField whitespaceHidden = BitFieldFactory.getInstance(4);
    public static final short sid = 2187;
    private FtrHeader futureHeader;
    short wScalePLV;
    short bits;

    public PLVRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2187);
    }

    public PLVRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.wScalePLV = in.readShort();
        this.bits = in.readShort();
        if (this.wScalePLV < 10 || this.wScalePLV > 400) {
            this.wScalePLV = 0;
        }
    }

    @Override
    public short getSid() {
        return 2187;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PLV]\n");
        buffer.append(this.futureHeader.toString());
        buffer.append("    .wScalePLV  = ").append(Integer.toString(this.wScalePLV)).append("\n");
        buffer.append("    .bits       = ").append(Integer.toHexString(this.bits)).append("\n");
        buffer.append("       .fPageLayoutView     = ").append(this.isPageLayoutView()).append("\n");
        buffer.append("       .fRulerVisible       = ").append(this.isRulerVisible()).append("\n");
        buffer.append("       .fWhitespaceHidden   = ").append(this.isWhitespaceHidden()).append("\n");
        buffer.append("[/PLV]\n");
        return buffer.toString();
    }

    public int getScalePLV() {
        return this.wScalePLV;
    }

    public void setScalePLV(int scale) {
        if (scale < 10 || scale > 400) {
            scale = 0;
        }
        this.wScalePLV = (short)scale;
    }

    public boolean isPageLayoutView() {
        return pageLayoutView.isSet(this.bits);
    }

    public boolean isRulerVisible() {
        return rulerVisible.isSet(this.bits);
    }

    public boolean isWhitespaceHidden() {
        return whitespaceHidden.isSet(this.bits);
    }

    public void setPageLayoutView(boolean flag) {
        this.bits = (short)pageLayoutView.setBoolean(this.bits, flag);
    }

    public void setRulerVisible(boolean flag) {
        this.bits = (short)rulerVisible.setBoolean(this.bits, flag);
    }

    public void setWhitespaceHidden(boolean flag) {
        this.bits = (short)whitespaceHidden.setBoolean(this.bits, flag);
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        out.writeShort(this.wScalePLV);
        out.writeShort(this.bits);
    }

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }

    @Override
    protected int getDataSize() {
        return 16;
    }
}

