/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ddf;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.zkoss.poi.ddf.EscherRecord;
import org.zkoss.poi.ddf.EscherRecordFactory;
import org.zkoss.poi.ddf.EscherSerializationListener;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndian;
import org.zkoss.poi.util.POILogFactory;
import org.zkoss.poi.util.POILogger;

public final class EscherContainerRecord
extends EscherRecord {
    public static final short DGG_CONTAINER = -4096;
    public static final short BSTORE_CONTAINER = -4095;
    public static final short DG_CONTAINER = -4094;
    public static final short SPGR_CONTAINER = -4093;
    public static final short SP_CONTAINER = -4092;
    public static final short SOLVER_CONTAINER = -4091;
    private static POILogger log = POILogFactory.getLogger(EscherContainerRecord.class);
    private int _remainingLength;
    private final List<EscherRecord> _childRecords = new ArrayList<EscherRecord>();

    @Override
    public int fillFields(byte[] data, int pOffset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, pOffset);
        int bytesWritten = 8;
        int offset = pOffset + 8;
        while (bytesRemaining > 0 && offset < data.length) {
            EscherRecord child = recordFactory.createRecord(data, offset);
            int childBytesWritten = child.fillFields(data, offset, recordFactory);
            bytesWritten += childBytesWritten;
            this.addChildRecord(child);
            if ((offset += childBytesWritten) < data.length || (bytesRemaining -= childBytesWritten) <= 0) continue;
            this._remainingLength = bytesRemaining;
            log.log(5, "Not enough Escher data: " + bytesRemaining + " bytes remaining but no space left");
        }
        return bytesWritten;
    }

    @Override
    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        int remainingBytes = 0;
        for (EscherRecord r : this._childRecords) {
            remainingBytes += r.getRecordSize();
        }
        LittleEndian.putInt(data, offset + 4, remainingBytes += this._remainingLength);
        int pos = offset + 8;
        for (EscherRecord r : this._childRecords) {
            pos += r.serialize(pos, data, listener);
        }
        listener.afterRecordSerialize(pos, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    @Override
    public int getRecordSize() {
        int childRecordsSize = 0;
        for (EscherRecord r : this._childRecords) {
            childRecordsSize += r.getRecordSize();
        }
        return 8 + childRecordsSize;
    }

    public boolean hasChildOfType(short recordId) {
        for (EscherRecord r : this._childRecords) {
            if (r.getRecordId() != recordId) continue;
            return true;
        }
        return false;
    }

    @Override
    public EscherRecord getChild(int index) {
        return this._childRecords.get(index);
    }

    @Override
    public List<EscherRecord> getChildRecords() {
        return new ArrayList<EscherRecord>(this._childRecords);
    }

    public Iterator<EscherRecord> getChildIterator() {
        return new ReadOnlyIterator(this._childRecords);
    }

    @Override
    public void setChildRecords(List<EscherRecord> childRecords) {
        if (childRecords == this._childRecords) {
            throw new IllegalStateException("Child records private data member has escaped");
        }
        this._childRecords.clear();
        this._childRecords.addAll(childRecords);
    }

    public boolean removeChildRecord(EscherRecord toBeRemoved) {
        return this._childRecords.remove(toBeRemoved);
    }

    public List<EscherContainerRecord> getChildContainers() {
        ArrayList<EscherContainerRecord> containers = new ArrayList<EscherContainerRecord>();
        for (EscherRecord r : this._childRecords) {
            if (!(r instanceof EscherContainerRecord)) continue;
            containers.add((EscherContainerRecord)r);
        }
        return containers;
    }

    @Override
    public String getRecordName() {
        switch (this.getRecordId()) {
            case -4096: {
                return "DggContainer";
            }
            case -4095: {
                return "BStoreContainer";
            }
            case -4094: {
                return "DgContainer";
            }
            case -4093: {
                return "SpgrContainer";
            }
            case -4092: {
                return "SpContainer";
            }
            case -4091: {
                return "SolverContainer";
            }
        }
        return "Container 0x" + HexDump.toHex(this.getRecordId());
    }

    @Override
    public void display(PrintWriter w, int indent) {
        super.display(w, indent);
        for (EscherRecord escherRecord : this._childRecords) {
            escherRecord.display(w, indent + 1);
        }
    }

    public void addChildRecord(EscherRecord record) {
        this._childRecords.add(record);
    }

    public void addChildBefore(EscherRecord record, int insertBeforeRecordId) {
        for (int i = 0; i < this._childRecords.size(); ++i) {
            EscherRecord rec = this._childRecords.get(i);
            if (rec.getRecordId() != insertBeforeRecordId) continue;
            this._childRecords.add(i++, record);
        }
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer children = new StringBuffer();
        if (this._childRecords.size() > 0) {
            children.append("  children: " + nl);
            int count = 0;
            for (EscherRecord record : this._childRecords) {
                children.append("   Child " + count + ":" + nl);
                String childResult = String.valueOf(record);
                childResult = childResult.replaceAll("\n", "\n    ");
                children.append("    ");
                children.append(childResult);
                children.append(nl);
                ++count;
            }
        }
        return this.getClass().getName() + " (" + this.getRecordName() + "):" + nl + "  isContainer: " + this.isContainerRecord() + nl + "  version: 0x" + HexDump.toHex(this.getVersion()) + nl + "  instance: 0x" + HexDump.toHex(this.getInstance()) + nl + "  recordId: 0x" + HexDump.toHex(this.getRecordId()) + nl + "  numchildren: " + this._childRecords.size() + nl + children.toString();
    }

    @Override
    public String toXml(String tab) {
        StringBuilder builder = new StringBuilder();
        builder.append(tab).append(this.formatXmlRecordHeader(this.getRecordName(), HexDump.toHex(this.getRecordId()), HexDump.toHex(this.getVersion()), HexDump.toHex(this.getInstance())));
        for (EscherRecord record : this._childRecords) {
            builder.append(record.toXml(tab + "\t"));
        }
        builder.append(tab).append("</").append(this.getRecordName()).append(">\n");
        return builder.toString();
    }

    public <T extends EscherRecord> T getChildById(short recordId) {
        for (EscherRecord childRecord : this._childRecords) {
            if (childRecord.getRecordId() != recordId) continue;
            EscherRecord result = childRecord;
            return (T)result;
        }
        return null;
    }

    public void getRecordsById(short recordId, List<EscherRecord> out) {
        for (EscherRecord r : this._childRecords) {
            if (r instanceof EscherContainerRecord) {
                EscherContainerRecord c = (EscherContainerRecord)r;
                c.getRecordsById(recordId, out);
                continue;
            }
            if (r.getRecordId() != recordId) continue;
            out.add(r);
        }
    }

    private static final class ReadOnlyIterator
    implements Iterator<EscherRecord> {
        private final List<EscherRecord> _list;
        private int _index;

        public ReadOnlyIterator(List<EscherRecord> list) {
            this._list = list;
            this._index = 0;
        }

        @Override
        public boolean hasNext() {
            return this._index < this._list.size();
        }

        @Override
        public EscherRecord next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this._list.get(this._index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

