/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorders;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyleXfs;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyles;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellXfs;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxfs;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFills;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFonts;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTNumFmt;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTNumFmts;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTStylesheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableStyles;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STHorizontalAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STVerticalAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.StyleSheetDocument;
import org.zkoss.poi.POIXMLDocumentPart;
import org.zkoss.poi.openxml4j.opc.PackagePart;
import org.zkoss.poi.openxml4j.opc.PackageRelationship;
import org.zkoss.poi.ss.usermodel.FontFamily;
import org.zkoss.poi.ss.usermodel.FontScheme;
import org.zkoss.poi.xssf.model.ThemesTable;
import org.zkoss.poi.xssf.usermodel.XSSFCellStyle;
import org.zkoss.poi.xssf.usermodel.XSSFColor;
import org.zkoss.poi.xssf.usermodel.XSSFFont;
import org.zkoss.poi.xssf.usermodel.XSSFNamedStyle;
import org.zkoss.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.zkoss.poi.xssf.usermodel.extensions.XSSFCellFill;

public class StylesTable
extends POIXMLDocumentPart {
    private Map<Integer, String> numberFormats = new LinkedHashMap<Integer, String>();
    private List<XSSFFont> fonts = new ArrayList<XSSFFont>();
    private List<XSSFCellFill> fills = new ArrayList<XSSFCellFill>();
    private List<XSSFCellBorder> borders = new ArrayList<XSSFCellBorder>();
    private List<CTXf> styleXfs = new ArrayList<CTXf>();
    private List<CTXf> xfs = new ArrayList<CTXf>();
    private Map<String, CTCellStyle> cellStyles = new HashMap<String, CTCellStyle>();
    private List<CTDxf> dxfs = new ArrayList<CTDxf>();
    private List<CTTableStyle> tableStyles = new ArrayList<CTTableStyle>();
    private String defaultPivotStyle;
    private String defaultTableStyle;
    public static final int FIRST_CUSTOM_STYLE_ID = 165;
    private StyleSheetDocument doc;
    private ThemesTable theme;

    public StylesTable() {
        this.doc = StyleSheetDocument.Factory.newInstance();
        this.doc.addNewStyleSheet();
        this.initialize();
    }

    public StylesTable(PackagePart part, PackageRelationship rel) throws IOException {
        super(part, rel);
        this.readFrom(part.getInputStream());
    }

    public ThemesTable getTheme() {
        return this.theme;
    }

    public void setTheme(ThemesTable theme) {
        this.theme = theme;
        for (XSSFFont font : this.fonts) {
            font.setThemesTable(theme);
        }
        for (XSSFCellBorder border : this.borders) {
            border.setThemesTable(theme);
        }
    }

    protected void readFrom(InputStream is) throws IOException {
        try {
            this.doc = StyleSheetDocument.Factory.parse((InputStream)is);
            CTStylesheet styleSheet = this.doc.getStyleSheet();
            this.init(styleSheet);
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    private void init(CTStylesheet styleSheet) {
        CTTableStyles tbStyles;
        CTDxfs styleDxfs;
        CTCellStyleXfs cellStyleXfs;
        CTCellStyles ctCellStyles;
        CTCellXfs cellXfs;
        CTBorders ctborders;
        CTFills ctfills;
        CTFonts ctfonts;
        this.numberFormats = new LinkedHashMap<Integer, String>();
        this.fonts = new ArrayList<XSSFFont>();
        this.fills = new ArrayList<XSSFCellFill>();
        this.borders = new ArrayList<XSSFCellBorder>();
        this.styleXfs = new ArrayList<CTXf>();
        this.xfs = new ArrayList<CTXf>();
        this.dxfs = new ArrayList<CTDxf>();
        this.cellStyles = new HashMap<String, CTCellStyle>();
        this.tableStyles = new ArrayList<CTTableStyle>();
        CTNumFmts ctfmts = styleSheet.getNumFmts();
        if (ctfmts != null) {
            for (CTNumFmt nfmt : ctfmts.getNumFmtArray()) {
                this.numberFormats.put((int)nfmt.getNumFmtId(), nfmt.getFormatCode());
            }
        }
        if ((ctfonts = styleSheet.getFonts()) != null) {
            int idx = 0;
            CTFont[] cTFontArray = ctfonts.getFontArray();
            int nfmt = cTFontArray.length;
            for (int i = 0; i < nfmt; ++i) {
                CTFont font = cTFontArray[i];
                XSSFFont f = new XSSFFont(font, idx);
                this.fonts.add(f);
                ++idx;
            }
        }
        if ((ctfills = styleSheet.getFills()) != null) {
            for (CTFill fill : ctfills.getFillArray()) {
                this.fills.add(new XSSFCellFill(fill));
            }
        }
        if ((ctborders = styleSheet.getBorders()) != null) {
            for (CTBorder border : ctborders.getBorderArray()) {
                this.borders.add(new XSSFCellBorder(border, this.theme));
            }
        }
        if ((cellXfs = styleSheet.getCellXfs()) != null) {
            this.xfs.addAll(Arrays.asList(cellXfs.getXfArray()));
        }
        if ((ctCellStyles = styleSheet.getCellStyles()) != null) {
            for (CTCellStyle style : ctCellStyles.getCellStyleArray()) {
                this.cellStyles.put(style.getName(), style);
            }
        }
        if ((cellStyleXfs = styleSheet.getCellStyleXfs()) != null) {
            this.styleXfs.addAll(Arrays.asList(cellStyleXfs.getXfArray()));
        }
        if ((styleDxfs = styleSheet.getDxfs()) != null) {
            this.dxfs.addAll(Arrays.asList(styleDxfs.getDxfArray()));
        }
        if ((tbStyles = styleSheet.getTableStyles()) != null) {
            this.tableStyles.addAll(Arrays.asList(tbStyles.getTableStyleArray()));
            this.defaultPivotStyle = tbStyles.getDefaultPivotStyle();
            this.defaultTableStyle = tbStyles.getDefaultTableStyle();
        }
    }

    public String getNumberFormatAt(int idx) {
        return this.numberFormats.get(idx);
    }

    public int putNumberFormat(String fmt) {
        if (this.numberFormats.containsValue(fmt)) {
            for (Integer key : this.numberFormats.keySet()) {
                if (!this.numberFormats.get(key).equals(fmt)) continue;
                return key;
            }
            throw new IllegalStateException("Found the format, but couldn't figure out where - should never happen!");
        }
        int newKey = 165;
        while (this.numberFormats.containsKey(newKey)) {
            ++newKey;
        }
        this.numberFormats.put(newKey, fmt);
        return newKey;
    }

    public XSSFFont getFontAt(int idx) {
        return this.fonts.get(idx);
    }

    public int putFont(XSSFFont font, boolean forceRegistration) {
        int idx = -1;
        if (!forceRegistration) {
            idx = this.fonts.indexOf(font);
        }
        if (idx != -1) {
            return idx;
        }
        idx = this.fonts.size();
        this.fonts.add(font);
        return idx;
    }

    public int putFont(XSSFFont font) {
        return this.putFont(font, false);
    }

    public XSSFCellStyle getStyleAt(int idx) {
        int styleXfId = 0;
        if (this.xfs.get(idx).getXfId() > 0L) {
            styleXfId = (int)this.xfs.get(idx).getXfId();
        }
        return new XSSFCellStyle(idx, styleXfId, this, this.theme);
    }

    public int putStyle(XSSFCellStyle style) {
        CTXf mainXF = style.getCoreXf();
        if (!this.xfs.contains(mainXF)) {
            this.xfs.add(mainXF);
        }
        return this.xfs.indexOf(mainXF);
    }

    public XSSFCellBorder getBorderAt(int idx) {
        return this.borders.get(idx);
    }

    public int putBorder(XSSFCellBorder border) {
        int idx = this.borders.indexOf(border);
        if (idx != -1) {
            return idx;
        }
        this.borders.add(border);
        border.setThemesTable(this.theme);
        return this.borders.size() - 1;
    }

    public XSSFCellFill getFillAt(int idx) {
        return this.fills.get(idx);
    }

    public List<XSSFCellBorder> getBorders() {
        return this.borders;
    }

    public List<XSSFCellFill> getFills() {
        return this.fills;
    }

    public List<XSSFFont> getFonts() {
        return this.fonts;
    }

    public Map<Integer, String> getNumberFormats() {
        return this.numberFormats;
    }

    public int putFill(XSSFCellFill fill) {
        int idx = this.fills.indexOf(fill);
        if (idx != -1) {
            return idx;
        }
        this.fills.add(fill);
        return this.fills.size() - 1;
    }

    public CTXf getCellXfAt(int idx) {
        return this.xfs.get(idx);
    }

    public int putCellXf(CTXf cellXf) {
        this.xfs.add(cellXf);
        return this.xfs.size();
    }

    public void replaceCellXfAt(int idx, CTXf cellXf) {
        this.xfs.set(idx, cellXf);
    }

    public CTXf getCellStyleXfAt(int idx) {
        return this.styleXfs.get(idx);
    }

    public void replaceCellStyleXfAt(int idx, CTXf cellStyleXf) {
        this.styleXfs.set(idx, cellStyleXf);
    }

    public int getNumCellStyles() {
        return this.xfs.size();
    }

    public int _getNumberFormatSize() {
        return this.numberFormats.size();
    }

    public int _getXfsSize() {
        return this.xfs.size();
    }

    public int _getStyleXfsSize() {
        return this.styleXfs.size();
    }

    public CTStylesheet getCTStylesheet() {
        return this.doc.getStyleSheet();
    }

    public int _getDXfsSize() {
        return this.dxfs.size();
    }

    public void writeTo(OutputStream out) throws IOException {
        XmlOptions options = new XmlOptions(DEFAULT_XML_OPTIONS);
        CTStylesheet styleSheet = this.doc.getStyleSheet();
        CTNumFmts formats = CTNumFmts.Factory.newInstance();
        formats.setCount((long)this.numberFormats.size());
        for (Map.Entry<Integer, String> fmt : this.numberFormats.entrySet()) {
            CTNumFmt ctFmt = formats.addNewNumFmt();
            ctFmt.setNumFmtId((long)fmt.getKey().intValue());
            ctFmt.setFormatCode(fmt.getValue());
        }
        styleSheet.setNumFmts(formats);
        CTFonts ctFonts = CTFonts.Factory.newInstance();
        ctFonts.setCount((long)this.fonts.size());
        CTFont[] ctfnt = new CTFont[this.fonts.size()];
        int idx = 0;
        for (XSSFFont f : this.fonts) {
            ctfnt[idx++] = f.getCTFont();
        }
        ctFonts.setFontArray(ctfnt);
        styleSheet.setFonts(ctFonts);
        CTFills ctFills = CTFills.Factory.newInstance();
        ctFills.setCount((long)this.fills.size());
        CTFill[] ctf = new CTFill[this.fills.size()];
        idx = 0;
        for (XSSFCellFill f : this.fills) {
            ctf[idx++] = f.getCTFill();
        }
        ctFills.setFillArray(ctf);
        styleSheet.setFills(ctFills);
        CTBorders ctBorders = CTBorders.Factory.newInstance();
        ctBorders.setCount((long)this.borders.size());
        CTBorder[] ctb = new CTBorder[this.borders.size()];
        idx = 0;
        for (XSSFCellBorder b : this.borders) {
            ctb[idx++] = b.getCTBorder();
        }
        ctBorders.setBorderArray(ctb);
        styleSheet.setBorders(ctBorders);
        if (this.xfs.size() > 0) {
            CTCellXfs ctXfs = CTCellXfs.Factory.newInstance();
            ctXfs.setCount((long)this.xfs.size());
            ctXfs.setXfArray(this.xfs.toArray(new CTXf[this.xfs.size()]));
            styleSheet.setCellXfs(ctXfs);
        }
        if (this.styleXfs.size() > 0) {
            CTCellStyleXfs ctSXfs = CTCellStyleXfs.Factory.newInstance();
            ctSXfs.setCount((long)this.styleXfs.size());
            ctSXfs.setXfArray(this.styleXfs.toArray(new CTXf[this.styleXfs.size()]));
            styleSheet.setCellStyleXfs(ctSXfs);
        }
        if (this.cellStyles.size() > 0) {
            CTCellStyles ctCellStyles = CTCellStyles.Factory.newInstance();
            ctCellStyles.setCount((long)this.cellStyles.size());
            ctCellStyles.setCellStyleArray(this.cellStyles.values().toArray(new CTCellStyle[this.cellStyles.size()]));
            styleSheet.setCellStyles(ctCellStyles);
        }
        if (this.dxfs.size() > 0) {
            CTDxfs ctDxfs = CTDxfs.Factory.newInstance();
            ctDxfs.setCount((long)this.dxfs.size());
            ctDxfs.setDxfArray(this.dxfs.toArray(new CTDxf[this.dxfs.size()]));
            styleSheet.setDxfs(ctDxfs);
        }
        if (!this.tableStyles.isEmpty()) {
            CTTableStyles ctTbStyles = CTTableStyles.Factory.newInstance();
            ctTbStyles.setCount((long)this.tableStyles.size());
            ctTbStyles.setDefaultPivotStyle(this.getDefaultPivotStyle());
            ctTbStyles.setDefaultTableStyle(this.getDefaultTableStyle());
            ctTbStyles.setTableStyleArray(this.tableStyles.toArray(new CTTableStyle[this.tableStyles.size()]));
            styleSheet.setTableStyles(ctTbStyles);
        }
        this.doc.save(out, options);
        this.init(styleSheet);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }

    private void initialize() {
        XSSFFont xssfFont = StylesTable.createDefaultFont();
        this.fonts.add(xssfFont);
        CTFill[] ctFill = StylesTable.createDefaultFills();
        this.fills.add(new XSSFCellFill(ctFill[0]));
        this.fills.add(new XSSFCellFill(ctFill[1]));
        CTBorder ctBorder = StylesTable.createDefaultBorder();
        this.borders.add(new XSSFCellBorder(ctBorder));
        CTXf styleXf = StylesTable.createDefaultXf();
        this.styleXfs.add(styleXf);
        CTXf xf = StylesTable.createDefaultXf();
        xf.setXfId(0L);
        this.xfs.add(xf);
    }

    private static CTXf createDefaultXf() {
        CTXf ctXf = CTXf.Factory.newInstance();
        ctXf.setNumFmtId(0L);
        ctXf.setFontId(0L);
        ctXf.setFillId(0L);
        ctXf.setBorderId(0L);
        return ctXf;
    }

    private static CTBorder createDefaultBorder() {
        CTBorder ctBorder = CTBorder.Factory.newInstance();
        ctBorder.addNewBottom();
        ctBorder.addNewTop();
        ctBorder.addNewLeft();
        ctBorder.addNewRight();
        ctBorder.addNewDiagonal();
        return ctBorder;
    }

    private static CTFill[] createDefaultFills() {
        CTFill[] ctFill = new CTFill[]{CTFill.Factory.newInstance(), CTFill.Factory.newInstance()};
        ctFill[0].addNewPatternFill().setPatternType(STPatternType.NONE);
        ctFill[1].addNewPatternFill().setPatternType(STPatternType.GRAY_125);
        return ctFill;
    }

    private static XSSFFont createDefaultFont() {
        CTFont ctFont = CTFont.Factory.newInstance();
        XSSFFont xssfFont = new XSSFFont(ctFont, 0);
        xssfFont.setFontHeightInPoints((short)11);
        xssfFont.setColor(XSSFFont.DEFAULT_FONT_COLOR);
        xssfFont.setFontName("Calibri");
        xssfFont.setFamily(FontFamily.SWISS);
        xssfFont.setScheme(FontScheme.MINOR);
        return xssfFont;
    }

    public CTDxf getDxfAt(int idx) {
        return this.dxfs.get(idx);
    }

    public int putDxf(CTDxf dxf) {
        this.dxfs.add(dxf);
        return this.dxfs.size() - 1;
    }

    public XSSFCellStyle createCellStyle() {
        CTXf xf = CTXf.Factory.newInstance();
        xf.setNumFmtId(0L);
        xf.setFontId(0L);
        xf.setFillId(0L);
        xf.setBorderId(0L);
        xf.setXfId(0L);
        int xfSize = this.styleXfs.size();
        int indexXf = this.putCellXf(xf);
        return new XSSFCellStyle(indexXf - 1, xfSize - 1, this, this.theme);
    }

    public XSSFFont findFont(short boldWeight, short color, short fontHeight, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        for (XSSFFont font : this.fonts) {
            if (font.getBoldweight() != boldWeight || font.getColor() != color || font.getFontHeight() != fontHeight || !font.getFontName().equals(name) || font.getItalic() != italic || font.getStrikeout() != strikeout || font.getTypeOffset() != typeOffset || font.getUnderline() != underline) continue;
            return font;
        }
        return null;
    }

    public XSSFFont findFont(short boldWeight, XSSFColor color, short fontHeight, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        for (XSSFFont font : this.fonts) {
            XSSFColor color0 = font.getXSSFColor();
            if (font.getBoldweight() != boldWeight || color0 != color && (color == null || !color.equals(color0)) || font.getFontHeight() != fontHeight || !font.getFontName().equals(name) || font.getItalic() != italic || font.getStrikeout() != strikeout || font.getTypeOffset() != typeOffset || font.getUnderline() != underline) continue;
            return font;
        }
        return null;
    }

    public void setDefaultCellStyle(XSSFCellStyle cellStyle) {
        CTXf styleXf = this.prepareStyleXf(cellStyle);
        this.replaceCellStyleXfAt(0, styleXf);
        CTXf cellXf = this.prepareCellXf(cellStyle);
        this.replaceCellXfAt(0, cellXf);
    }

    private CTXf prepareCellXf(XSSFCellStyle cellStyle) {
        CTXf cellXf1 = cellStyle.getCellXf();
        CTXf cellXf0 = (CTXf)cellXf1.copy();
        if (cellXf0.isSetApplyAlignment()) {
            cellXf0.unsetApplyAlignment();
        }
        if (cellXf0.isSetApplyBorder()) {
            cellXf0.unsetApplyBorder();
        }
        if (cellXf0.isSetApplyFill()) {
            cellXf0.unsetApplyFill();
        }
        if (cellXf0.isSetApplyFont()) {
            cellXf0.unsetApplyFont();
        }
        if (cellXf0.isSetApplyNumberFormat()) {
            cellXf0.unsetApplyNumberFormat();
        }
        if (cellXf0.isSetApplyProtection()) {
            cellXf0.unsetApplyProtection();
        }
        if (cellXf0.isSetProtection()) {
            CTCellProtection prot = cellXf0.getProtection();
            if (prot.isSetHidden() && !prot.getHidden()) {
                prot.unsetHidden();
            }
            if (prot.isSetLocked() && prot.getLocked()) {
                prot.unsetLocked();
            }
            if (!prot.isSetLocked() && !prot.isSetHidden()) {
                cellXf0.unsetProtection();
            }
        }
        if (cellXf0.isSetAlignment()) {
            CTCellAlignment align = cellXf0.getAlignment();
            if (align.isSetWrapText() && !align.getWrapText()) {
                align.unsetWrapText();
            }
            if (align.isSetHorizontal() && STHorizontalAlignment.GENERAL.equals(align.getHorizontal())) {
                align.unsetHorizontal();
            }
            if (align.isSetVertical() && STVerticalAlignment.BOTTOM.equals(align.getVertical())) {
                align.unsetVertical();
            }
            if (align.isNil()) {
                cellXf0.unsetAlignment();
            }
        }
        cellXf0.setBorderId(0L);
        cellXf0.setFillId(0L);
        cellXf0.setFontId(0L);
        cellXf0.setNumFmtId(0L);
        return cellXf0;
    }

    private CTXf prepareStyleXf(XSSFCellStyle cellStyle) {
        CTXf cellXf0 = this.prepareCellXf(cellStyle);
        CTXf styleXf = (CTXf)cellXf0.copy();
        if (cellXf0.isSetAlignment()) {
            styleXf.setAlignment(cellXf0.getAlignment());
        }
        if (cellXf0.isSetProtection()) {
            styleXf.setProtection(cellXf0.getProtection());
        }
        if (styleXf.isSetXfId()) {
            styleXf.unsetXfId();
        }
        return styleXf;
    }

    public int putCellStyle(CTCellStyle style) {
        this.cellStyles.put(style.getName(), style);
        return this.cellStyles.size() - 1;
    }

    public int putCellStyleXf(CTXf xf) {
        this.styleXfs.add(xf);
        return this.styleXfs.size() - 1;
    }

    public CTCellStyle getCellStyleByName(String name) {
        return this.cellStyles.get(name);
    }

    public Collection<CTXf> getCellStyleXfs() {
        return this.styleXfs;
    }

    public Collection<CTCellStyle> getCellStyles() {
        return this.cellStyles.values();
    }

    public CTCellStyle getCellStyle(String name) {
        return this.cellStyles.get(name);
    }

    public XSSFNamedStyle getStyleByName(String name) {
        int styleXfId = 0;
        CTCellStyle style = this.cellStyles.get(name);
        if (style != null) {
            styleXfId = (int)style.getXfId();
        }
        return new XSSFNamedStyle(name, style.getCustomBuiltin(), (int)style.getBuiltinId(), styleXfId, this, this.theme);
    }

    public Collection<CTDxf> getCellStyleDxfs() {
        return this.dxfs;
    }

    public XSSFCellStyle createDefaultCellStyle(XSSFCellBorder border, XSSFCellFill fill, XSSFFont font, int numFmtId) {
        int fontId = this.putFont(font);
        int fillId = this.putFill(fill);
        int borderId = this.putBorder(border);
        CTXf xf = CTXf.Factory.newInstance();
        xf.setNumFmtId((long)numFmtId);
        xf.setFontId((long)fontId);
        xf.setFillId((long)fillId);
        xf.setBorderId((long)borderId);
        return new XSSFCellStyle(xf, this, this.theme);
    }

    public List<CTXf> getCellXfs() {
        return this.xfs;
    }

    public XSSFFont getDefaultStyleFont() {
        CTXf xf = this.getCellStyleXfAt(0);
        if (xf != null) {
            return this.getFontAt((int)xf.getFontId());
        }
        return null;
    }

    public List<CTTableStyle> getTableStyles() {
        return this.tableStyles;
    }

    public String getDefaultPivotStyle() {
        return this.defaultPivotStyle;
    }

    public String getDefaultTableStyle() {
        return this.defaultTableStyle;
    }

    public void setDefaultPivotStyle(String defaultPivotStyle) {
        this.defaultPivotStyle = defaultPivotStyle;
    }

    public void setDefaultTableStyle(String defaultTableStyle) {
        this.defaultTableStyle = defaultTableStyle;
    }

    public int getDxfIndex(CTDxf dxf) {
        return this.dxfs.indexOf(dxf);
    }

    public void addTableStyle(CTTableStyle tbStyle) {
        this.tableStyles.add(tbStyle);
    }
}

