/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api.model.impl;

import io.keikai.api.model.Book;
import io.keikai.api.model.Font;
import io.keikai.api.model.RichText;
import io.keikai.api.model.impl.BookImpl;
import io.keikai.api.model.impl.FontImpl;
import io.keikai.api.model.impl.SegmentImpl;
import io.keikai.api.model.impl.SimpleRef;
import io.keikai.model.SFont;
import io.keikai.model.SRichText;
import io.keikai.model.util.Validations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RichTextImpl
implements RichText,
Serializable {
    private static final long serialVersionUID = 4459139353293789714L;
    final Book _book;
    final SRichText _native;

    public RichTextImpl(Book book) {
        this._book = book;
        this._native = new io.keikai.model.impl.RichTextImpl();
    }

    public SRichText getNative() {
        return this._native;
    }

    @Override
    public String getText() {
        return this._native.getText();
    }

    @Override
    public Font getFont() {
        SFont font0 = this._native.getFont();
        return font0 == null ? null : new FontImpl(((BookImpl)this._book).getRef(), new SimpleRef<SFont>(font0));
    }

    @Override
    public List<RichText.Segment> getSegments() {
        List modelsegs = this._native.getSegments();
        if (modelsegs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RichText.Segment> apisegs = new ArrayList<RichText.Segment>(modelsegs.size());
        for (SRichText.Segment seg : modelsegs) {
            SFont sfont = seg.getFont();
            FontImpl font = sfont == null ? null : new FontImpl(((BookImpl)this._book).getRef(), new SimpleRef<SFont>(sfont));
            apisegs.add(new SegmentImpl(seg.getText(), font));
        }
        return apisegs;
    }

    @Override
    public void addSegment(String text, Font font) {
        Validations.argNotNull((Object[])new Object[]{text});
        if ("".equals(text)) {
            return;
        }
        this._native.addSegment(text, ((FontImpl)font).getNative());
    }

    @Override
    public void clearSegments() {
        this._native.clearSegments();
    }
}

