/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SPicture;
import io.keikai.model.SPictureData;
import io.keikai.model.SSheet;
import io.keikai.model.ViewAnchor;
import io.keikai.model.impl.AbstractPictureAdv;
import io.keikai.model.impl.AbstractSheetAdv;

public class PictureImpl
extends AbstractPictureAdv {
    private static final long serialVersionUID = -8176040020483451498L;
    private String _id;
    private SPictureData _picData;
    private ViewAnchor _anchor;
    private AbstractSheetAdv _sheet;

    public PictureImpl(AbstractSheetAdv sheet, String id, SPicture.Format format, byte[] data, ViewAnchor anchor) {
        this._sheet = sheet;
        this._id = id;
        this._anchor = anchor;
        this._picData = this._sheet.getBook().addPictureData(format, data);
    }

    public PictureImpl(AbstractSheetAdv sheet, String id, int picDataIndex, ViewAnchor anchor) {
        this._sheet = sheet;
        this._id = id;
        this._anchor = anchor;
        SPictureData picData = sheet.getBook().getPictureData(picDataIndex);
        if (picData == null) {
            throw new IllegalStateException("Inexisting picture data index: " + picDataIndex);
        }
        this._picData = picData;
    }

    @Override
    public SSheet getSheet() {
        this.checkOrphan();
        return this._sheet;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public SPicture.Format getFormat() {
        return this._picData.getFormat();
    }

    @Override
    public ViewAnchor getAnchor() {
        return this._anchor;
    }

    @Override
    public void setAnchor(ViewAnchor anchor) {
        this._anchor = anchor;
    }

    @Override
    public byte[] getData() {
        return this._picData.getData();
    }

    @Override
    public void destroy() {
        this.checkOrphan();
        this._sheet = null;
    }

    @Override
    public void checkOrphan() {
        if (this._sheet == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    @Override
    public SPictureData getPictureData() {
        return this._picData;
    }

    PictureImpl clonePictureImpl(AbstractSheetAdv sheet) {
        return this.clonePicture(sheet, null);
    }

    @Override
    PictureImpl clonePicture(AbstractSheetAdv sheet, SBook book) {
        if (book == null) {
            return new PictureImpl(sheet, this._id, this._picData.getIndex(), this._anchor.cloneViewAnchor());
        }
        SPictureData srcPicData = this._picData;
        byte[] tgtData = (byte[])srcPicData.getData().clone();
        SPictureData tgtPicData = book.addPictureData(srcPicData.getFormat(), tgtData);
        return new PictureImpl(sheet, this._id, tgtPicData.getIndex(), this._anchor.cloneViewAnchor());
    }
}

