/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.model.SColumnArray;
import io.keikai.model.SSheet;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.range.impl.imexp.AbstractExcelExporter;
import io.keikai.range.impl.imexp.UnitUtil;
import org.zkoss.poi.hssf.usermodel.HSSFSheet;
import org.zkoss.poi.hssf.usermodel.HSSFWorkbook;
import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.usermodel.Workbook;

public class ExcelXlsExporter
extends AbstractExcelExporter {
    private static final long serialVersionUID = 4653748601821482540L;

    @Override
    protected void exportColumnArray(SSheet sheet, Sheet poiSheet, SColumnArray columnArr) {
        CellStyle poiCellStyle = this.toPOICellStyle(columnArr.getCellStyle());
        boolean hidden = columnArr.isHidden();
        AbstractBookAdv book = (AbstractBookAdv)sheet.getBook();
        int charWidth = book.getCharWidth();
        for (int i = columnArr.getIndex(); i <= columnArr.getLastIndex() && i <= SpreadsheetVersion.EXCEL97.getMaxColumns(); ++i) {
            poiSheet.setColumnWidth(i, UnitUtil.pxToFileChar256(columnArr.getWidth(), charWidth));
            poiSheet.setColumnHidden(i, hidden);
            poiSheet.setDefaultColumnStyle(i, poiCellStyle);
        }
    }

    @Override
    protected Workbook createPoiBook() {
        return new HSSFWorkbook();
    }

    @Override
    protected void exportChart(SSheet sheet, Sheet poiSheet) {
    }

    @Override
    protected void exportPicture(SSheet sheet, Sheet poiSheet) {
    }

    @Override
    protected void exportValidation(SSheet sheet, Sheet poiSheet) {
    }

    @Override
    protected void exportAutoFilter(SSheet sheet, Sheet poiSheet) {
    }

    @Override
    protected void exportPassword(SSheet sheet, Sheet poiSheet) {
        short hashpass = sheet.getHashedPassword();
        if (hashpass != 0) {
            ((HSSFSheet)poiSheet).setPasswordHash(hashpass);
        }
    }

    @Override
    protected int exportTables(SSheet sheet, Sheet poiSheet, int tbId) {
        return 0;
    }

    @Override
    protected void exportConditionalFormatting(SSheet sheet, Sheet poiSheet) {
    }
}

