/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.SSheet;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractBookSeriesAdv;
import io.keikai.model.impl.AbstractNameAdv;
import io.keikai.model.impl.ModelUpdateUtil;
import io.keikai.model.impl.NameRefImpl;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.model.sys.formula.FormulaEngine;
import io.keikai.model.sys.formula.FormulaEvaluationContext;
import io.keikai.model.sys.formula.FormulaExpression;
import io.keikai.model.sys.formula.FormulaParseContext;

public class NameImpl
extends AbstractNameAdv {
    private static final long serialVersionUID = 1L;
    private final String _id;
    private AbstractBookAdv _book;
    private String _name;
    private String _applyToSheetName;
    private FormulaExpression _refersToExprFormula;
    private CellRegion _refersToCellRegion;
    private String _refersToSheetName;

    public NameImpl(AbstractBookAdv book, String id, String name, String applyToSheetName) {
        this._book = book;
        this._id = id;
        this._name = name;
        this._applyToSheetName = applyToSheetName;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getRefersToSheetName() {
        return this._refersToSheetName;
    }

    @Override
    public CellRegion getRefersToCellRegion() {
        return this._refersToCellRegion;
    }

    @Override
    public String getRefersToFormula() {
        return this._refersToExprFormula == null ? null : this._refersToExprFormula.getFormulaString();
    }

    @Override
    public void destroy() {
        this.checkOrphan();
        this.clearFormulaDependency(this._name);
        this.clearFormulaResultCache();
        this._book = null;
    }

    @Override
    public void checkOrphan() {
        if (this._book == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    @Override
    void setName(String newname, String applyToSheetName) {
        this.checkOrphan();
        boolean shouldEval = this._refersToExprFormula != null && (!this.equals0(this._name, newname) || !this.equals0(this._applyToSheetName, applyToSheetName));
        this._applyToSheetName = applyToSheetName;
        if (shouldEval) {
            this.parseAndEvalFormula(this._refersToExprFormula, this._name, newname);
        }
        this._name = newname;
    }

    private boolean equals0(String n1, String n2) {
        return n1 == n2 || n1 != null && n1.equals(n2);
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setRefersToFormula(String refersToExpr) {
        this.checkOrphan();
        if (this._refersToExprFormula == null) {
            if (refersToExpr != null) {
                this.parseAndEvalFormula(refersToExpr, this._name, this._name);
            }
        } else if (!this.equals0(refersToExpr, this._refersToExprFormula.getFormulaString())) {
            this.parseAndEvalFormula(refersToExpr, this._name, this._name);
        }
    }

    void parseAndEvalFormula(String refersToExpr, String oldName, String newName) {
        this.clearFormulaDependency(oldName);
        this._refersToSheetName = null;
        this._refersToCellRegion = null;
        if (refersToExpr != null) {
            FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
            Ref ref = this.getRef(newName);
            this._refersToExprFormula = fe.parse(refersToExpr, new FormulaParseContext(this._book.getSheet(0), ref));
            this.evalPtgs(fe, ref);
        }
    }

    private void evalPtgs(FormulaEngine fe, Ref ref) {
        if (!this._refersToExprFormula.hasError() && this._refersToExprFormula.isAreaRefs()) {
            fe.evaluate(this._refersToExprFormula, new FormulaEvaluationContext(this._book.getSheet(0), ref));
            Ref[] refs = this._refersToExprFormula.getAreaRefs();
            this._refersToSheetName = refs[0].getSheetName();
            this._refersToCellRegion = new CellRegion(refs[0].getRow(), refs[0].getColumn(), refs[0].getLastRow(), refs[0].getLastColumn());
            if (!this._book.isPostProcessing()) {
                ModelUpdateUtil.handlePrecedentUpdate(this._book.getBookSeries(), ref);
            }
        }
    }

    @Override
    public boolean isFormulaParsingError() {
        return this._refersToExprFormula == null ? false : this._refersToExprFormula.hasError();
    }

    private void clearFormulaDependency(String nameName) {
        if (this._refersToExprFormula != null) {
            Ref ref = this.getRef(nameName);
            ((AbstractBookSeriesAdv)this._book.getBookSeries()).getDependencyTable().clearDependents(ref);
        }
    }

    @Override
    public AbstractBookAdv getBook() {
        this.checkOrphan();
        return this._book;
    }

    @Override
    public void clearFormulaResultCache() {
    }

    @Override
    public String getApplyToSheetName() {
        return this._applyToSheetName;
    }

    private Ref getRef(String nameName) {
        return new NameRefImpl(this.getBook().getBookName(), this.getApplyToSheetName(), nameName);
    }

    @Override
    public FormulaExpression getRefersToFormulaExpression() {
        return this._refersToExprFormula;
    }

    @Override
    public void setRefersToFormula(FormulaExpression refersToExpr) {
        this.checkOrphan();
        if (this._refersToExprFormula == null) {
            if (refersToExpr != null) {
                this.parseAndEvalFormula(refersToExpr, this._name, this._name);
            }
        } else if (refersToExpr != null) {
            if (!this.equals0(refersToExpr.getFormulaString(), this._refersToExprFormula.getFormulaString())) {
                this.parseAndEvalFormula(refersToExpr, this._name, this._name);
            }
        } else {
            this.parseAndEvalFormula(refersToExpr, this._name, this._name);
        }
    }

    void parseAndEvalFormula(FormulaExpression refersToExpr, String oldName, String newName) {
        this.clearFormulaDependency(oldName);
        this._refersToSheetName = null;
        this._refersToCellRegion = null;
        this._refersToExprFormula = refersToExpr;
        if (refersToExpr != null) {
            FormulaEngine fe = EngineFactory.getInstance().createFormulaEngine();
            Ref ref = this.getRef(newName);
            fe.updateDependencyTable(refersToExpr, new FormulaParseContext(this._book.getSheet(0), ref));
            this.evalPtgs(fe, ref);
        }
    }

    @Override
    public void setApplyToSheetName(String sheetName) {
        this._applyToSheetName = sheetName;
    }

    @Override
    AbstractNameAdv cloneName(SSheet sheet) {
        return (AbstractNameAdv)(sheet == null ? this : ((AbstractBookAdv)sheet.getBook()).getOrCreateName(this, sheet.getSheetName()));
    }
}

