/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hslf.model;

import java.util.Iterator;
import java.util.List;
import org.zkoss.poi.ddf.EscherContainerRecord;
import org.zkoss.poi.ddf.EscherOptRecord;
import org.zkoss.poi.ddf.EscherProperty;
import org.zkoss.poi.ddf.EscherPropertyFactory;
import org.zkoss.poi.ddf.EscherRecord;
import org.zkoss.poi.ddf.EscherSimpleProperty;
import org.zkoss.poi.ddf.EscherSpRecord;
import org.zkoss.poi.hslf.model.AutoShape;
import org.zkoss.poi.hslf.model.Freeform;
import org.zkoss.poi.hslf.model.Line;
import org.zkoss.poi.hslf.model.MovieShape;
import org.zkoss.poi.hslf.model.OLEShape;
import org.zkoss.poi.hslf.model.Picture;
import org.zkoss.poi.hslf.model.Shape;
import org.zkoss.poi.hslf.model.ShapeGroup;
import org.zkoss.poi.hslf.model.SimpleShape;
import org.zkoss.poi.hslf.model.Table;
import org.zkoss.poi.hslf.model.TextBox;
import org.zkoss.poi.hslf.record.InteractiveInfo;
import org.zkoss.poi.hslf.record.OEShapeAtom;
import org.zkoss.poi.hslf.record.Record;
import org.zkoss.poi.hslf.record.RecordTypes;
import org.zkoss.poi.util.POILogFactory;
import org.zkoss.poi.util.POILogger;

public final class ShapeFactory {
    protected static POILogger logger = POILogFactory.getLogger(ShapeFactory.class);

    public static Shape createShape(EscherContainerRecord spContainer, Shape parent) {
        if (spContainer.getRecordId() == -4093) {
            return ShapeFactory.createShapeGroup(spContainer, parent);
        }
        return ShapeFactory.createSimpeShape(spContainer, parent);
    }

    public static ShapeGroup createShapeGroup(EscherContainerRecord spContainer, Shape parent) {
        ShapeGroup group;
        block5: {
            group = null;
            EscherRecord opt = Shape.getEscherChild((EscherContainerRecord)spContainer.getChild(0), -3806);
            if (opt != null) {
                try {
                    EscherPropertyFactory f = new EscherPropertyFactory();
                    List<EscherProperty> props = f.createProperties(opt.serialize(), 8, opt.getInstance());
                    EscherSimpleProperty p = (EscherSimpleProperty)props.get(0);
                    if (p.getPropertyNumber() == 927 && p.getPropertyValue() == 1) {
                        group = new Table(spContainer, parent);
                        break block5;
                    }
                    group = new ShapeGroup(spContainer, parent);
                }
                catch (Exception e) {
                    logger.log(5, e.getMessage());
                    group = new ShapeGroup(spContainer, parent);
                }
            } else {
                group = new ShapeGroup(spContainer, parent);
            }
        }
        return group;
    }

    public static Shape createSimpeShape(EscherContainerRecord spContainer, Shape parent) {
        SimpleShape shape = null;
        EscherSpRecord spRecord = (EscherSpRecord)spContainer.getChildById((short)-4086);
        short type = spRecord.getShapeType();
        switch (type) {
            case 202: {
                shape = new TextBox(spContainer, parent);
                break;
            }
            case 75: 
            case 201: {
                InteractiveInfo info = (InteractiveInfo)ShapeFactory.getClientDataRecord(spContainer, RecordTypes.InteractiveInfo.typeID);
                OEShapeAtom oes = (OEShapeAtom)ShapeFactory.getClientDataRecord(spContainer, RecordTypes.OEShapeAtom.typeID);
                if (info != null && info.getInteractiveInfoAtom() != null) {
                    switch (info.getInteractiveInfoAtom().getAction()) {
                        case 5: {
                            shape = new OLEShape(spContainer, parent);
                            break;
                        }
                        case 6: {
                            shape = new MovieShape(spContainer, parent);
                            break;
                        }
                    }
                } else if (oes != null) {
                    shape = new OLEShape(spContainer, parent);
                }
                if (shape != null) break;
                shape = new Picture(spContainer, parent);
                break;
            }
            case 20: {
                shape = new Line(spContainer, parent);
                break;
            }
            case 0: {
                EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(spContainer, -4085);
                EscherProperty prop = Shape.getEscherProperty(opt, 325);
                if (prop != null) {
                    shape = new Freeform(spContainer, parent);
                    break;
                }
                logger.log(5, "Creating AutoShape for a NotPrimitive shape");
                shape = new AutoShape(spContainer, parent);
                break;
            }
            default: {
                shape = new AutoShape(spContainer, parent);
            }
        }
        return shape;
    }

    protected static Record getClientDataRecord(EscherContainerRecord spContainer, int recordType) {
        Record oep = null;
        Iterator<EscherRecord> it = spContainer.getChildIterator();
        while (it.hasNext()) {
            EscherRecord obj = it.next();
            if (obj.getRecordId() != -4079) continue;
            byte[] data = obj.serialize();
            Record[] records = Record.findChildRecords(data, 8, data.length - 8);
            for (int j = 0; j < records.length; ++j) {
                if (records[j].getRecordType() != (long)recordType) continue;
                return records[j];
            }
        }
        return oep;
    }
}

