/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.CompactSerializationConfig;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.TriTuple;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import com.hazelcast.spi.annotation.PrivateApi;
import java.util.List;
import java.util.Map;

@PrivateApi
public final class CompactSerializationConfigAccessor {
    private CompactSerializationConfigAccessor() {
    }

    public static void registerSerializer(CompactSerializationConfig config, String serializerClassName) {
        Preconditions.checkNotNull(serializerClassName, "Explicit serializer class name cannot be null");
        config.serializerClassNames.add(serializerClassName);
    }

    public static void registerClass(CompactSerializationConfig config, String className) {
        Preconditions.checkNotNull(className, "Class name cannot be null");
        config.compactSerializableClassNames.add(className);
    }

    public static List<String> getSerializerClassNames(CompactSerializationConfig config) {
        return config.serializerClassNames;
    }

    public static List<String> getCompactSerializableClassNames(CompactSerializationConfig config) {
        return config.compactSerializableClassNames;
    }

    public static Map<String, TriTuple<Class, String, CompactSerializer>> getRegistrations(CompactSerializationConfig config) {
        return config.typeNameToRegistration;
    }
}

