/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.impl.AbstractPartitionPrimaryReplicaAntiEntropyTask;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Collection;
import java.util.function.BiConsumer;

final class CheckPartitionReplicaVersionTask
extends AbstractPartitionPrimaryReplicaAntiEntropyTask {
    private final int replicaIndex;
    private final BiConsumer<Object, Throwable> callback;

    CheckPartitionReplicaVersionTask(NodeEngineImpl nodeEngine, int partitionId, int replicaIndex, BiConsumer<Object, Throwable> callback) {
        super(nodeEngine, partitionId);
        if (replicaIndex < 1 || replicaIndex > 6) {
            throw new IllegalArgumentException("Replica index must be in range [1-6]");
        }
        this.replicaIndex = replicaIndex;
        Preconditions.checkNotNull(callback);
        this.callback = callback;
    }

    @Override
    public void run() {
        InternalPartition partition = this.partitionService.getPartition(this.partitionId);
        if (!partition.isLocal() || partition.isMigrating()) {
            this.callback.accept(false, null);
            return;
        }
        Collection<ServiceNamespace> namespaces = this.retainAndGetNamespaces();
        PartitionReplica target = partition.getReplica(this.replicaIndex);
        if (target == null) {
            this.callback.accept(false, null);
            return;
        }
        this.invokePartitionBackupReplicaAntiEntropyOp(this.replicaIndex, target, namespaces, this.callback);
    }
}

