/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.model.GridTab;
import org.compiere.model.MQuery;
import org.compiere.model.MRequest;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.Popup;

public class WRequest
implements EventListener<Event> {
    private int m_AD_Table_ID;
    private int m_Record_ID;
    private String m_Record_UU;
    private int m_C_BPartner_ID;
    private Menupopup m_popup = new Menupopup();
    private Menuitem m_new = null;
    private Menuitem m_active = null;
    private Menuitem m_all = null;
    protected StringBuilder m_where = null;
    private static final CLogger log = CLogger.getCLogger(WRequest.class);

    public WRequest(Component invoker, int AD_Table_ID, int Record_ID, String Record_UU, int C_BPartner_ID) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("AD_Table_ID=" + AD_Table_ID + ", Record_ID=" + Record_ID + ", Record_UU=" + Record_UU);
        }
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_Record_ID = Record_ID;
        this.m_Record_UU = Record_UU;
        this.m_C_BPartner_ID = C_BPartner_ID;
        this.getRequests(invoker);
    }

    public WRequest(Component invoker, int AD_Table_ID, int Record_ID, int C_BPartner_ID) {
        this(invoker, AD_Table_ID, Record_ID, null, C_BPartner_ID);
    }

    private void getRequests(Component invoker) {
        Popup popup;
        this.m_new = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"RequestNew"));
        if (ThemeManager.isUseFontIconForImage()) {
            this.m_new.setIconSclass("z-icon-New");
        } else {
            this.m_new.setImage(ThemeManager.getThemeResource("images/New16.png"));
        }
        this.m_new.addEventListener("onClick", (EventListener)this);
        this.m_popup.appendChild((Component)this.m_new);
        this.m_where = new StringBuilder();
        int[] counts = MRequest.getRequestCount((int)this.m_AD_Table_ID, (int)this.m_Record_ID, (String)this.m_Record_UU, (StringBuilder)this.m_where, null);
        int activeCount = counts[1];
        int inactiveCount = counts[0];
        if (activeCount > 0) {
            this.m_active = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"RequestActive") + " (" + activeCount + ")");
            this.m_active.addEventListener("onClick", (EventListener)this);
            this.m_popup.appendChild((Component)this.m_active);
        }
        if (inactiveCount > 0) {
            this.m_all = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"RequestAll") + " (" + (activeCount + inactiveCount) + ")");
            this.m_all.addEventListener("onClick", (EventListener)this);
            this.m_popup.appendChild((Component)this.m_all);
        }
        if ((popup = LayoutUtils.findPopup(invoker)) != null) {
            popup.appendChild((Component)this.m_popup);
        } else {
            this.m_popup.setPage(invoker.getPage());
            LayoutUtils.autoDetachOnClose((Popup)this.m_popup);
        }
        this.m_popup.open(invoker, "after_start");
    }

    public void onEvent(final Event e) throws Exception {
        if (e.getTarget() instanceof Menuitem) {
            MQuery query = null;
            if (e.getTarget() == this.m_active) {
                query = new MQuery("");
                String where = "(" + String.valueOf(this.m_where) + ") AND Processed='N'";
                query.addRestriction(where);
                query.setRecordCount(0);
            } else if (e.getTarget() == this.m_all) {
                query = new MQuery("");
                query.addRestriction(this.m_where.toString());
                query.setRecordCount(0);
            } else if (e.getTarget() == this.m_new) {
                query = new MQuery("");
                query.addRestriction("1=2");
                query.setRecordCount(0);
            }
            int AD_Window_ID = 232;
            if (this.m_popup.getParent() instanceof Popup) {
                ((Popup)this.m_popup.getParent()).close();
            }
            SessionManager.getAppDesktop().openWindow(AD_Window_ID, query, new Callback<ADWindow>(){

                public void onCallback(ADWindow result) {
                    if (result == null) {
                        return;
                    }
                    WRequest.this.onNew(e, result);
                }
            });
        }
    }

    private void onNew(Event e, ADWindow frame) {
        if (e.getTarget() == this.m_new) {
            GridTab tab = frame.getADWindowContent().getActiveGridTab();
            MRequest.newRequest((GridTab)tab, (int)this.m_AD_Table_ID, (int)this.m_Record_ID, (String)this.m_Record_UU, (int)this.m_C_BPartner_ID);
        }
    }
}

