/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.olap4j.Axis;
import org.olap4j.mdx.AxisNode;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.CubeNode;
import org.olap4j.mdx.DimensionNode;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.LevelNode;
import org.olap4j.mdx.LiteralNode;
import org.olap4j.mdx.MemberNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.Syntax;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.query.Query;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.Selection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Olap4jNodeConverter {
    Olap4jNodeConverter() {
    }

    public static SelectNode toOlap4j(Query query) {
        List<IdentifierNode> list = Collections.emptyList();
        List<ParseTreeNode> withList = Collections.emptyList();
        ArrayList<QueryAxis> axisList = new ArrayList<QueryAxis>();
        axisList.add(query.getAxes().get(Axis.COLUMNS));
        axisList.add(query.getAxes().get(Axis.ROWS));
        AxisNode filterAxis = null;
        if (query.getAxes().containsKey(Axis.FILTER)) {
            QueryAxis axis = query.getAxes().get(Axis.FILTER);
            if (!axis.dimensions.isEmpty()) {
                filterAxis = Olap4jNodeConverter.toOlap4j(axis);
            }
        }
        return new SelectNode(null, withList, Olap4jNodeConverter.toOlap4j(axisList), new CubeNode(null, query.getCube()), filterAxis, list);
    }

    private static CallNode generateSetCall(ParseTreeNode ... args) {
        return new CallNode(null, "{}", Syntax.Braces, args);
    }

    private static CallNode generateListSetCall(List<ParseTreeNode> cnodes) {
        return new CallNode(null, "{}", Syntax.Braces, cnodes);
    }

    private static CallNode generateListTupleCall(List<ParseTreeNode> cnodes) {
        return new CallNode(null, "()", Syntax.Parentheses, cnodes);
    }

    protected static CallNode generateCrossJoin(List<ParseTreeNode> selections) {
        ParseTreeNode sel1 = selections.remove(0);
        if (sel1 instanceof MemberNode) {
            sel1 = Olap4jNodeConverter.generateSetCall(sel1);
        }
        if (selections.size() == 1) {
            ParseTreeNode sel2 = selections.get(0);
            if (sel2 instanceof MemberNode) {
                sel2 = Olap4jNodeConverter.generateSetCall(sel2);
            }
            return new CallNode(null, "CrossJoin", Syntax.Function, sel1, sel2);
        }
        return new CallNode(null, "CrossJoin", Syntax.Function, sel1, Olap4jNodeConverter.generateCrossJoin(selections));
    }

    protected static CallNode generateUnion(List<List<ParseTreeNode>> unions) {
        if (unions.size() > 2) {
            List<ParseTreeNode> first = unions.remove(0);
            return new CallNode(null, "Union", Syntax.Function, Olap4jNodeConverter.generateCrossJoin(first), Olap4jNodeConverter.generateUnion(unions));
        }
        return new CallNode(null, "Union", Syntax.Function, Olap4jNodeConverter.generateCrossJoin(unions.get(0)), Olap4jNodeConverter.generateCrossJoin(unions.get(1)));
    }

    protected static CallNode generateHierarchizeUnion(List<List<ParseTreeNode>> unions) {
        return new CallNode(null, "Hierarchize", Syntax.Function, Olap4jNodeConverter.generateUnion(unions));
    }

    private static void generateUnionsRecursively(QueryAxis axis, int dim, List<ParseTreeNode> curr, List<List<ParseTreeNode>> unions, List<Selection> selsWithContext, List<List<ParseTreeNode>> contextUnions) {
        CallNode exceptSet = null;
        QueryDimension qDim = axis.getDimensions().get(dim);
        List<Selection> exclusionSelections = qDim.getExclusions();
        ArrayList<ParseTreeNode> exclusionNodes = new ArrayList<ParseTreeNode>();
        for (Selection exclusion : exclusionSelections) {
            exclusionNodes.add(Olap4jNodeConverter.toOlap4j(exclusion));
        }
        if (exclusionNodes.size() > 0) {
            exceptSet = Olap4jNodeConverter.generateListSetCall(exclusionNodes);
        }
        for (Selection sel : qDim.getInclusions()) {
            ParseTreeNode selectionNode = Olap4jNodeConverter.toOlap4j(sel);
            if (qDim.getSortOrder() != null) {
                CallNode currentMemberNode = new CallNode(null, "CurrentMember", Syntax.Property, new DimensionNode(null, sel.getDimension()));
                CallNode currentMemberNameNode = new CallNode(null, "Name", Syntax.Property, currentMemberNode);
                selectionNode = new CallNode(null, "Order", Syntax.Function, Olap4jNodeConverter.generateSetCall(selectionNode), currentMemberNameNode, LiteralNode.createSymbol(null, qDim.getSortOrder().name()));
            }
            if (exceptSet != null) {
                selectionNode = new CallNode(null, "Except", Syntax.Function, Olap4jNodeConverter.generateSetCall(selectionNode), exceptSet);
            }
            if (sel.getSelectionContext() != null && sel.getSelectionContext().size() > 0) {
                if (selsWithContext.contains(sel)) continue;
                ArrayList<ParseTreeNode> sels = new ArrayList<ParseTreeNode>();
                for (int i = 0; i < axis.getDimensions().size(); ++i) {
                    if (dim == i) {
                        sels.add(selectionNode);
                        continue;
                    }
                    QueryDimension dimension = axis.getDimensions().get(i);
                    boolean found = false;
                    for (Selection selection : sel.getSelectionContext()) {
                        if (!selection.getDimension().equals(dimension.getDimension())) continue;
                        sels.add(Olap4jNodeConverter.toOlap4j(selection));
                        found = true;
                    }
                    if (found || dimension.getInclusions().size() <= 0) continue;
                    sels.add(Olap4jNodeConverter.toOlap4j(dimension.getInclusions().get(0)));
                }
                contextUnions.add(sels);
                selsWithContext.add(sel);
                continue;
            }
            ArrayList<ParseTreeNode> ncurr = new ArrayList<ParseTreeNode>();
            if (curr != null) {
                ncurr.addAll(curr);
            }
            ncurr.add(selectionNode);
            if (dim == axis.getDimensions().size() - 1) {
                unions.add(ncurr);
                continue;
            }
            Olap4jNodeConverter.generateUnionsRecursively(axis, dim + 1, ncurr, unions, selsWithContext, contextUnions);
        }
    }

    private static AxisNode toOlap4j(QueryAxis axis) {
        CallNode callNode = null;
        int numDimensions = axis.getDimensions().size();
        if (numDimensions == 0) {
            return null;
        }
        if (numDimensions == 1) {
            QueryDimension dimension = axis.getDimensions().get(0);
            List<ParseTreeNode> members = Olap4jNodeConverter.toOlap4j(dimension);
            callNode = Olap4jNodeConverter.generateListSetCall(members);
        } else {
            ArrayList<List<ParseTreeNode>> unions = new ArrayList<List<ParseTreeNode>>();
            ArrayList<Selection> selsWithContext = new ArrayList<Selection>();
            ArrayList<List<ParseTreeNode>> contextUnions = new ArrayList<List<ParseTreeNode>>();
            Olap4jNodeConverter.generateUnionsRecursively(axis, 0, null, unions, selsWithContext, contextUnions);
            unions.addAll(contextUnions);
            callNode = unions.size() > 1 ? Olap4jNodeConverter.generateHierarchizeUnion(unions) : Olap4jNodeConverter.generateCrossJoin((List)unions.get(0));
        }
        CallNode sortedNode = null;
        if (axis.getSortOrder() != null) {
            LiteralNode evaluatorNode = LiteralNode.createSymbol(null, axis.getSortIdentifierNodeName());
            sortedNode = new CallNode(null, "Order", Syntax.Function, callNode, evaluatorNode, LiteralNode.createSymbol(null, axis.getSortOrder().name()));
        } else {
            sortedNode = callNode;
        }
        return new AxisNode(null, axis.isNonEmpty(), axis.getLocation(), new ArrayList<IdentifierNode>(), sortedNode);
    }

    private static List<ParseTreeNode> toOlap4j(QueryDimension dimension) {
        ArrayList<ParseTreeNode> includeList = new ArrayList<ParseTreeNode>();
        for (Selection selection : dimension.getInclusions()) {
            includeList.add(Olap4jNodeConverter.toOlap4j(selection));
        }
        ArrayList<ParseTreeNode> orderedList = new ArrayList<ParseTreeNode>();
        if (dimension.getSortOrder() != null) {
            CallNode currentMemberNode = new CallNode(null, "CurrentMember", Syntax.Property, new DimensionNode(null, dimension.getDimension()));
            CallNode currentMemberNameNode = new CallNode(null, "Name", Syntax.Property, currentMemberNode);
            orderedList.add(new CallNode(null, "Order", Syntax.Function, Olap4jNodeConverter.generateListSetCall(includeList), currentMemberNameNode, LiteralNode.createSymbol(null, dimension.getSortOrder().name())));
        } else {
            orderedList.addAll(includeList);
        }
        ArrayList<ParseTreeNode> listWithExclusions = new ArrayList<ParseTreeNode>();
        if (dimension.getExclusions().size() > 0) {
            ArrayList<ParseTreeNode> excludedMembers = new ArrayList<ParseTreeNode>();
            for (Selection selection : dimension.getExclusions()) {
                excludedMembers.add(Olap4jNodeConverter.toOlap4j(selection));
            }
            listWithExclusions.add(new CallNode(null, "Except", Syntax.Function, Olap4jNodeConverter.generateListSetCall(orderedList), Olap4jNodeConverter.generateListSetCall(excludedMembers)));
        } else {
            listWithExclusions.addAll(orderedList);
        }
        ArrayList<ParseTreeNode> listWithHierarchy = new ArrayList<ParseTreeNode>();
        if (dimension.getHierarchizeMode() != null) {
            CallNode hierarchyNode;
            if (dimension.getHierarchizeMode().equals((Object)QueryDimension.HierarchizeMode.PRE)) {
                hierarchyNode = new CallNode(null, "Hierarchize", Syntax.Function, Olap4jNodeConverter.generateListSetCall(listWithExclusions));
            } else if (dimension.getHierarchizeMode().equals((Object)QueryDimension.HierarchizeMode.POST)) {
                hierarchyNode = new CallNode(null, "Hierarchize", Syntax.Function, Olap4jNodeConverter.generateListSetCall(listWithExclusions), LiteralNode.createSymbol(null, dimension.getHierarchizeMode().name()));
            } else {
                throw new RuntimeException("Missing value handler.");
            }
            listWithHierarchy.add(hierarchyNode);
        } else {
            listWithHierarchy.addAll(listWithExclusions);
        }
        return listWithHierarchy;
    }

    private static ParseTreeNode toOlap4j(Selection selection) {
        try {
            return selection.visit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static ParseTreeNode toOlap4j(Member member, Selection.Operator oper) {
        ParseTreeNode node = null;
        try {
            switch (oper) {
                case MEMBER: {
                    node = new MemberNode(null, member);
                    break;
                }
                case SIBLINGS: {
                    node = new CallNode(null, "Siblings", Syntax.Property, new MemberNode(null, member));
                    break;
                }
                case CHILDREN: {
                    node = new CallNode(null, "Children", Syntax.Property, new MemberNode(null, member));
                    break;
                }
                case INCLUDE_CHILDREN: {
                    node = Olap4jNodeConverter.generateSetCall(new MemberNode(null, member), Olap4jNodeConverter.toOlap4j(member, Selection.Operator.CHILDREN));
                    break;
                }
                case DESCENDANTS: {
                    node = new CallNode(null, "Descendants", Syntax.Function, new MemberNode(null, member));
                    break;
                }
                case ANCESTORS: {
                    node = new CallNode(null, "Ascendants", Syntax.Function, new MemberNode(null, member));
                    break;
                }
                default: {
                    System.out.println("NOT IMPLEMENTED: " + (Object)((Object)oper));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return node;
    }

    static ParseTreeNode toOlap4j(Level level, Selection.Operator oper) {
        CallNode node = null;
        try {
            switch (oper) {
                case MEMBERS: {
                    node = new CallNode(null, "Members", Syntax.Property, new LevelNode(null, level));
                    break;
                }
                default: {
                    System.out.println("NOT IMPLEMENTED: " + (Object)((Object)oper));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return node;
    }

    private static List<AxisNode> toOlap4j(List<QueryAxis> axes) {
        ArrayList<AxisNode> axisList = new ArrayList<AxisNode>();
        for (QueryAxis axis : axes) {
            AxisNode axisNode = Olap4jNodeConverter.toOlap4j(axis);
            if (axisNode == null) continue;
            axisList.add(Olap4jNodeConverter.toOlap4j(axis));
        }
        return axisList;
    }
}

