/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.io.File;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogFile;

@Process
public class DeleteTraceLogs
extends SvrProcess {
    private int p_KeepLogDays = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            ProcessInfoParameter para = processInfoParameterArray[n2];
            switch (name = para.getParameterName()) {
                case "KeepLogDays": {
                    this.p_KeepLogDays = para.getParameterAsInt();
                    break;
                }
                default: {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
                }
            }
            ++n2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int cnt = 0;
        LocalDateTime limit = LocalDateTime.now().minusDays(this.p_KeepLogDays);
        CLogFile fileHandler = CLogFile.get(true, null, false);
        File logDir = fileHandler.getLogDirectory();
        if (logDir != null && logDir.isDirectory()) {
            Object[] logs = logDir.listFiles();
            Arrays.sort(logs);
            int i = 0;
            while (i < logs.length) {
                Date lastModified;
                if (((File)logs[i]).isFile() && limit.isAfter(LocalDateTime.ofInstant((lastModified = new Date(((File)logs[i]).lastModified())).toInstant(), ZoneId.systemDefault())) && ((File)logs[i]).delete()) {
                    this.addLog(((File)logs[i]).getName());
                    ++cnt;
                }
                ++i;
            }
        }
        return "@Deleted@ " + cnt;
    }
}

