/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.X_PA_ReportLine;
import org.compiere.report.MReportSource;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Util;

public class MReportLine
extends X_PA_ReportLine {
    private static final long serialVersionUID = -6310984172477566729L;
    private BasicStroke overline_Stroke;
    private Stroke underline_Stroke;
    private MReportSource[] m_sources = null;
    private String m_whereClause = null;

    public MReportLine(Properties ctx, String PA_ReportLine_UU, String trxName) {
        super(ctx, PA_ReportLine_UU, trxName);
        if (Util.isEmpty(PA_ReportLine_UU)) {
            this.setInitialDefaults();
        } else {
            this.loadSources();
        }
    }

    public MReportLine(Properties ctx, int PA_ReportLine_ID, String trxName) {
        super(ctx, PA_ReportLine_ID, trxName);
        if (PA_ReportLine_ID == 0) {
            this.setInitialDefaults();
        } else {
            this.loadSources();
        }
    }

    private void setInitialDefaults() {
        this.setSeqNo(0);
        this.setIsPrinted(false);
    }

    public MReportLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.loadSources();
    }

    private void loadSources() {
        ArrayList<MReportSource> list;
        block7: {
            list = new ArrayList<MReportSource>();
            String sql = "SELECT * FROM PA_ReportSource WHERE PA_ReportLine_ID=? AND IsActive='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getPA_ReportLine_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MReportSource(this.getCtx(), rs, null));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, null, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_sources = new MReportSource[list.size()];
        list.toArray(this.m_sources);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("ID=" + this.getPA_ReportLine_ID() + " - Size=" + list.size());
        }
    }

    public MReportSource[] getSources() {
        return this.m_sources;
    }

    public void list() {
        System.out.println("- " + this.toString());
        if (this.m_sources == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.m_sources.length) {
            System.out.println("  - " + this.m_sources[i2].toString());
            ++i2;
        }
    }

    public String getSourceColumnName() {
        String ColumnName = null;
        int i2 = 0;
        while (i2 < this.m_sources.length) {
            String col = MAcctSchemaElement.getColumnName(this.m_sources[i2].getElementType());
            if (ColumnName == null || ColumnName.length() == 0) {
                ColumnName = col;
            } else if (!ColumnName.equals(col)) {
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("More than one: " + ColumnName + " - " + col);
                }
                return null;
            }
            ++i2;
        }
        return ColumnName;
    }

    public String getSourceValueQuery() {
        if (this.m_sources != null && this.m_sources.length > 0) {
            return MAcctSchemaElement.getValueQuery(this.m_sources[0].getElementType());
        }
        return null;
    }

    public String getSelectClause(boolean withSum) {
        String at = this.getPAAmountType().substring(0, 1);
        StringBuilder sb = new StringBuilder();
        if (withSum) {
            sb.append("SUM(");
        }
        if ("B".equals(at)) {
            sb.append("acctBalance(Account_ID,AmtAcctDr,AmtAcctCr)");
        } else if ("S".equals(at)) {
            sb.append("AmtAcctDr-AmtAcctCr");
        } else if ("C".equals(at)) {
            sb.append("AmtAcctCr");
        } else if ("D".equals(at)) {
            sb.append("AmtAcctDr");
        } else if ("R".equals(at)) {
            sb.append("Qty");
        } else if ("Q".equals(at)) {
            sb.append("acctBalance(Account_ID,Qty,0)");
        } else {
            this.log.log(Level.SEVERE, "AmountType=" + this.getPAAmountType() + ", at=" + at);
            return "NULL";
        }
        if (withSum) {
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean isPeriod() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "P".equals(pt);
    }

    public boolean isYear() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "Y".equals(pt);
    }

    public boolean isTotal() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "T".equals(pt);
    }

    public boolean isNatural() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "N".equals(pt);
    }

    public String getWhereClause(int PA_Hierarchy_ID) {
        if (this.m_sources == null) {
            return "";
        }
        if (this.m_whereClause == null) {
            if (this.m_sources.length == 0) {
                this.m_whereClause = "";
            } else if (this.m_sources.length == 1) {
                this.m_whereClause = this.m_sources[0].getWhereClause(PA_Hierarchy_ID);
            } else {
                StringBuilder sb = new StringBuilder("(");
                int i2 = 0;
                while (i2 < this.m_sources.length) {
                    if (i2 > 0) {
                        sb.append(" OR ");
                    }
                    sb.append(this.m_sources[i2].getWhereClause(PA_Hierarchy_ID));
                    ++i2;
                }
                sb.append(")");
                this.m_whereClause = sb.toString();
            }
            String PostingType = this.getPostingType();
            if (PostingType != null && PostingType.length() > 0) {
                if (this.m_whereClause.length() > 0) {
                    this.m_whereClause = String.valueOf(this.m_whereClause) + " AND ";
                }
                this.m_whereClause = String.valueOf(this.m_whereClause) + "PostingType='" + PostingType + "'";
                if (PostingType.equals("B") && this.getGL_Budget_ID() > 0) {
                    this.m_whereClause = String.valueOf(this.m_whereClause) + " AND GL_Budget_ID=" + this.getGL_Budget_ID();
                }
            }
            this.log.fine(this.m_whereClause);
        }
        return this.m_whereClause;
    }

    public boolean isPostingType() {
        String PostingType = this.getPostingType();
        return PostingType != null && PostingType.length() > 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MReportLine[").append(this.get_ID()).append(" - ").append(this.getName()).append(" - ").append(this.getDescription()).append(", SeqNo=").append(this.getSeqNo()).append(", AmountType=").append(this.getPAAmountType()).append(", PeriodType=").append(this.getPAPeriodType()).append(" - LineType=").append(this.getLineType());
        if (this.isLineTypeCalculation()) {
            sb.append(" - Calculation=").append(this.getCalculationType()).append(" - ").append(this.getOper_1_ID()).append(" - ").append(this.getOper_2_ID());
        } else {
            sb.append(" - SegmentValue - PostingType=").append(this.getPostingType()).append(", AmountType=").append(this.getPAAmountType()).append(", PeriodType=").append(this.getPAPeriodType());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isLineTypeCalculation() {
        return "C".equals(this.getLineType());
    }

    public boolean isLineTypeSegmentValue() {
        return "S".equals(this.getLineType());
    }

    public boolean isLineTypeBlankLine() {
        return "B".equals(this.getLineType());
    }

    public boolean isCalculationTypeRange() {
        return "R".equals(this.getCalculationType());
    }

    public boolean isCalculationTypeAdd() {
        return "A".equals(this.getCalculationType());
    }

    public boolean isCalculationTypeSubtract() {
        return "S".equals(this.getCalculationType());
    }

    public boolean isCalculationTypePercent() {
        return "P".equals(this.getCalculationType());
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if ("S".equals(this.getLineType())) {
            if (this.getCalculationType() != null) {
                this.setCalculationType(null);
            }
            if (this.getOper_1_ID() != 0) {
                this.setOper_1_ID(0);
            }
            if (this.getOper_2_ID() != 0) {
                this.setOper_2_ID(0);
            }
        }
        return true;
    }

    public static MReportLine copy(Properties ctx, int AD_Client_ID, int AD_Org_ID, int PA_ReportLineSet_ID, MReportLine source, String trxName) {
        MReportLine retValue = new MReportLine(ctx, 0, trxName);
        MReportLine.copyValues(source, retValue, AD_Client_ID, AD_Org_ID);
        retValue.setPA_ReportLineSet_ID(PA_ReportLineSet_ID);
        retValue.setOper_1_ID(0);
        retValue.setOper_2_ID(0);
        return retValue;
    }

    public int getOverline() {
        if ("DT".equals(this.getOverlineStrokeType()) || "SD".equals(this.getOverlineStrokeType()) || "DS".equals(this.getOverlineStrokeType())) {
            return 1;
        }
        if ("DDT".equals(this.getOverlineStrokeType()) || "DSD".equals(this.getOverlineStrokeType()) || "DDS".equals(this.getOverlineStrokeType())) {
            return 2;
        }
        return 0;
    }

    public Stroke getOverlineStroke(BigDecimal stroke) {
        if (this.overline_Stroke == null) {
            float width = stroke.floatValue() / 2.0f;
            if ("DT".equals(this.getOverlineStrokeType()) || "DDT".equals(this.getOverlineStrokeType())) {
                this.overline_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDotted(width), 0.0f);
            } else if ("SD".equals(this.getOverlineStrokeType()) || "DSD".equals(this.getOverlineStrokeType())) {
                this.overline_Stroke = new BasicStroke(width);
            } else if ("DS".equals(this.getOverlineStrokeType()) || "DDS".equals(this.getOverlineStrokeType())) {
                this.overline_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDashed(width), 0.0f);
            }
        }
        return this.overline_Stroke;
    }

    public int getUnderline() {
        if ("DT".equals(this.getUnderlineStrokeType()) || "SD".equals(this.getUnderlineStrokeType()) || "DS".equals(this.getUnderlineStrokeType())) {
            return 1;
        }
        if ("DDT".equals(this.getUnderlineStrokeType()) || "DSD".equals(this.getUnderlineStrokeType()) || "DDS".equals(this.getUnderlineStrokeType())) {
            return 2;
        }
        return 0;
    }

    public Stroke getUnderlineStroke(BigDecimal stroke) {
        if (this.underline_Stroke == null) {
            float width = stroke.floatValue() / 2.0f;
            if ("DT".equals(this.getUnderlineStrokeType()) || "DDT".equals(this.getUnderlineStrokeType())) {
                this.underline_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDotted(width), 0.0f);
            } else if ("SD".equals(this.getUnderlineStrokeType()) || "DSD".equals(this.getUnderlineStrokeType())) {
                this.underline_Stroke = new BasicStroke(width);
            } else if ("DS".equals(this.getUnderlineStrokeType()) || "DDS".equals(this.getUnderlineStrokeType())) {
                this.underline_Stroke = new BasicStroke(width, 0, 2, 1.0f, this.getPatternDashed(width), 0.0f);
            }
        }
        return this.underline_Stroke;
    }

    private float[] getPatternDotted(float width) {
        return new float[]{2.0f * width, 2.0f * width};
    }

    private float[] getPatternDashed(float width) {
        return new float[]{10.0f * width, 4.0f * width};
    }
}

