/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.model.MTabCustomization;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.MColumn;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.model.X_AD_PrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.MPrintTableFormat;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MPrintFormat
extends X_AD_PrintFormat
implements ImmutablePOSupport {
    private static final long serialVersionUID = 7542581302442072662L;
    private MPrintFormatItem[] m_items = null;
    private String m_translationViewLanguage = null;
    private Language m_language;
    private MPrintTableFormat m_tFormat;
    private static CLogger s_log = CLogger.getCLogger(MPrintFormat.class);
    private static ImmutablePOCache<String, MPrintFormat> s_formats = new ImmutablePOCache<String, MPrintFormat>("AD_PrintFormat", 30){
        private static final long serialVersionUID = 2428566381289874703L;

        @Override
        public int reset(int recordId) {
            int n;
            int n2;
            String[] stringArray;
            if (recordId <= 0) {
                return this.reset();
            }
            if (this.cache.isEmpty() && this.nullList.isEmpty()) {
                return 0;
            }
            StringBuilder key = new StringBuilder().append(recordId).append("|");
            int removed = 0;
            if (!this.nullList.isEmpty()) {
                String[] nullKeys;
                stringArray = nullKeys = this.nullList.toArray(new String[0]);
                n2 = nullKeys.length;
                n = 0;
                while (n < n2) {
                    String nullKey = stringArray[n];
                    if (nullKey.startsWith(key.toString()) && this.nullList.remove(nullKey)) {
                        ++removed;
                    }
                    ++n;
                }
            }
            if (!this.cache.isEmpty()) {
                String[] cacheKeys = this.cache.keySet().toArray(new String[0]);
                stringArray = cacheKeys;
                n2 = cacheKeys.length;
                n = 0;
                while (n < n2) {
                    MPrintFormat v;
                    String cacheKey = stringArray[n];
                    if (cacheKey.startsWith(key.toString()) && (v = (MPrintFormat)this.cache.remove(cacheKey)) != null) {
                        ++removed;
                    }
                    ++n;
                }
            }
            return removed;
        }
    };

    public MPrintFormat(Properties ctx, String AD_PrintFormat_UU, String trxName) {
        super(ctx, AD_PrintFormat_UU, trxName);
        this.m_language = Env.getLanguage(ctx);
        if (Util.isEmpty(AD_PrintFormat_UU)) {
            this.setInitialDefaults();
        }
    }

    public MPrintFormat(Properties ctx, int AD_PrintFormat_ID, String trxName) {
        super(ctx, AD_PrintFormat_ID, trxName);
        this.m_language = Env.getLanguage(ctx);
        if (AD_PrintFormat_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setStandardHeaderFooter(true);
        this.setIsTableBased(true);
        this.setIsForm(false);
        this.setIsDefault(false);
    }

    public void reloadItems() {
        this.m_items = null;
        this.getItems();
        if (this.is_Immutable() && this.getItems() != null && this.getItems().length > 0) {
            Arrays.stream(this.getItems()).forEach(e -> {
                MPrintFormatItem mPrintFormatItem = e.markImmutable();
            });
        }
    }

    public MPrintFormat(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.m_language = Env.getLanguage(ctx);
    }

    public MPrintFormat(MPrintFormat copy) {
        this(Env.getCtx(), copy);
    }

    public MPrintFormat(Properties ctx, MPrintFormat copy) {
        this(ctx, copy, null);
    }

    public MPrintFormat(Properties ctx, MPrintFormat copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_translationViewLanguage = copy.m_translationViewLanguage;
        this.m_items = copy.m_items != null ? (MPrintFormatItem[])Arrays.stream(copy.m_items).map(e -> new MPrintFormatItem(ctx, (MPrintFormatItem)e, trxName)).toArray(MPrintFormatItem[]::new) : null;
        this.m_language = copy.m_language != null ? new Language(copy.m_language) : null;
        this.m_tFormat = copy.m_tFormat != null ? new MPrintTableFormat(ctx, copy.m_tFormat, trxName) : null;
    }

    public Language getLanguage() {
        return this.m_language;
    }

    public void setLanguage(Language language) {
        if (language != null) {
            this.m_language = language;
        }
        this.m_translationViewLanguage = null;
    }

    public int[] getOrderAD_Column_IDs() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int i2 = 0;
        while (i2 < this.getItems().length) {
            if (this.getItems()[i2].getSortNo() != 0 && this.getItems()[i2].getAD_Column_ID() != 0) {
                map.put(this.getItems()[i2].getSortNo(), this.getItems()[i2].getAD_Column_ID());
            }
            ++i2;
        }
        Object[] keys = new Integer[map.keySet().size()];
        map.keySet().toArray(keys);
        Arrays.sort(keys);
        int[] retValue = new int[keys.length];
        int i3 = 0;
        while (i3 < keys.length) {
            Integer value = (Integer)map.get(keys[i3]);
            retValue[i3] = value;
            ++i3;
        }
        return retValue;
    }

    public int[] getAD_Column_IDs() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < this.getItems().length) {
            if (this.getItems()[i2].getAD_Column_ID() != 0 && this.getItems()[i2].isPrinted()) {
                list.add(this.getItems()[i2].getAD_Column_ID());
            }
            ++i2;
        }
        int[] retValue = new int[list.size()];
        int i3 = 0;
        while (i3 < list.size()) {
            retValue[i3] = (Integer)list.get(i3);
            ++i3;
        }
        return retValue;
    }

    private void setItems(MPrintFormatItem[] items) {
        if (items != null) {
            this.m_items = items;
        }
    }

    private MPrintFormatItem[] getItems() {
        ArrayList<MPrintFormatItem> list;
        block7: {
            if (this.m_items != null) {
                return this.m_items;
            }
            list = new ArrayList<MPrintFormatItem>();
            String sql = "SELECT * FROM AD_PrintFormatItem pfi WHERE pfi.AD_PrintFormat_ID=? AND pfi.IsActive='Y' AND NOT EXISTS (SELECT * FROM AD_Field f WHERE pfi.AD_Column_ID=f.AD_Column_ID AND (f.IsEncrypted='Y' OR f.ObscureType IS NOT NULL)) ORDER BY SeqNo";
            MRole role = MRole.getDefault(this.getCtx(), false);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.get_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MPrintFormatItem pfi = new MPrintFormatItem(this.p_ctx, rs, this.get_TrxName());
                        if (!role.isColumnAccess(this.getAD_Table_ID(), pfi.getAD_Column_ID(), true, this.get_TrxName())) continue;
                        list.add(pfi);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MPrintFormatItem[] retValue = new MPrintFormatItem[list.size()];
        list.toArray(retValue);
        this.m_items = retValue;
        return retValue;
    }

    public MPrintFormatItem[] getAllItems() {
        return this.getAllItems("SeqNo");
    }

    public MPrintFormatItem[] getAllItems(String orderBy) {
        String whereClause = "AD_PrintFormatItem.AD_PrintFormat_ID=?  AND NOT EXISTS (SELECT * FROM AD_Field f WHERE AD_PrintFormatItem.AD_Column_ID=f.AD_Column_ID AND (f.IsEncrypted='Y' OR f.ObscureType IS NOT NULL))";
        List<MPrintFormatItem> list = new Query(this.getCtx(), "AD_PrintFormatItem", whereClause, this.get_TrxName()).setParameters(this.get_ID()).setOnlyActiveRecords(true).setOrderBy(orderBy).list();
        MRole role = MRole.getDefault(this.getCtx(), false);
        list.removeIf(pfi -> !role.isColumnAccess(this.getAD_Table_ID(), pfi.getAD_Column_ID(), true));
        MPrintFormatItem[] retValue = new MPrintFormatItem[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    private MPrintFormatItem[] getItemsNotIn(int AD_PrintFormat_ID) {
        ArrayList<MPrintFormatItem> list;
        block6: {
            list = new ArrayList<MPrintFormatItem>();
            String sql = "SELECT * FROM AD_PrintFormatItem pfi WHERE pfi.AD_PrintFormat_ID=? AND pfi.IsActive='Y' AND NOT EXISTS (SELECT * FROM AD_Field f WHERE pfi.AD_Column_ID=f.AD_Column_ID AND (f.IsEncrypted='Y' OR f.ObscureType IS NOT NULL)) AND AD_Column_ID NOT IN (SELECT pfi.AD_Column_ID FROM AD_PrintFormatItem pfi WHERE pfi.AD_PrintFormat_ID=? AND pfi.AD_Column_ID IS NOT NULL) ORDER BY SeqNo";
            MRole role = MRole.getDefault(this.getCtx(), false);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.get_ID());
                    pstmt.setInt(2, AD_PrintFormat_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MPrintFormatItem pfi = new MPrintFormatItem(this.p_ctx, rs, this.get_TrxName());
                        if (!role.isColumnAccess(this.getAD_Table_ID(), pfi.getAD_Column_ID(), true)) continue;
                        list.add(pfi);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MPrintFormatItem[] retValue = new MPrintFormatItem[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int getItemCount() {
        if (this.getItems() == null) {
            return -1;
        }
        return this.getItems().length;
    }

    public MPrintFormatItem getItem(int index) {
        if (index < 0 || index >= this.getItems().length) {
            throw new ArrayIndexOutOfBoundsException("Index=" + index + " - Length=" + this.getItems().length);
        }
        return this.getItems()[index];
    }

    public void setTranslation() {
        StringBuilder sb = new StringBuilder("UPDATE AD_PrintFormatItem_Trl t SET (PrintName, PrintNameSuffix)= (SELECT PrintName, PrintNameSuffix FROM AD_PrintFormatItem i WHERE i.AD_PrintFormatItem_ID=t.AD_PrintFormatItem_ID) WHERE AD_PrintFormatItem_ID IN (SELECT AD_PrintFormatItem_ID FROM AD_PrintFormatItem WHERE AD_PrintFormat_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("setTranslation #" + no);
        }
    }

    public void setStandardHeaderFooter(boolean standardHeaderFooter) {
        super.setIsStandardHeaderFooter(standardHeaderFooter);
        if (standardHeaderFooter) {
            this.setFooterMargin(0);
            this.setHeaderMargin(0);
        }
    }

    @Override
    public void setIsTableBased(boolean tableBased) {
        super.setIsTableBased(tableBased);
        if (tableBased) {
            super.setIsForm(false);
        }
    }

    public void setTranslationLanguage(Language language) {
        if (language == null || language.isBaseLanguage()) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Ignored - " + String.valueOf(language));
            }
            this.m_translationViewLanguage = null;
        } else {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Language=" + language.getAD_Language());
            }
            this.m_translationViewLanguage = language.getAD_Language();
            this.m_language = language;
        }
    }

    public boolean isTranslationView() {
        return this.m_translationViewLanguage != null;
    }

    public void setTranslationViewQuery(MQuery query) {
        if (this.m_translationViewLanguage != null && query != null && query.getTableName().toUpperCase().endsWith("_V")) {
            query.setTableName(query.getTableName() + "t");
            query.addRestriction("AD_Language", "=", (Object)this.m_translationViewLanguage);
        }
    }

    @Override
    public void setAD_PrintTableFormat_ID(int AD_PrintTableFormat_ID) {
        super.setAD_PrintTableFormat_ID(AD_PrintTableFormat_ID);
        this.m_tFormat = MPrintTableFormat.get(this.getCtx(), AD_PrintTableFormat_ID, this.getAD_PrintFont_ID());
        if (this.is_Immutable()) {
            this.m_tFormat.markImmutable();
        }
    }

    public MPrintTableFormat getTableFormat() {
        if (this.m_tFormat == null) {
            this.m_tFormat = MPrintTableFormat.get(this.getCtx(), this.getAD_PrintTableFormat_ID(), this.getAD_PrintFont_ID());
            if (this.is_Immutable()) {
                this.m_tFormat.markImmutable();
            }
        }
        return this.m_tFormat;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MPrintFormat[ID=").append(this.get_ID()).append(",Name=").append(this.getName()).append(",Language=").append(this.getLanguage()).append(",Items=").append(this.getItemCount()).append("]");
        return sb.toString();
    }

    @Override
    protected Object loadSpecial(ResultSet rs, int index) throws SQLException {
        return null;
    }

    @Override
    protected String saveNewSpecial(Object value, int index) {
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }

    public static MPrintFormat createFromGridLayout(Properties ctx, GridTab gridTab, boolean allColumns) {
        boolean error;
        MPrintFormat pf;
        block20: {
            int AD_Client_ID = Env.getAD_Client_ID(ctx);
            pf = new MPrintFormat(ctx, 0, null);
            pf.setAD_Table_ID(gridTab.getAD_Table_ID());
            String sql = "SELECT TableName, COALESCE (cpc.AD_PrintColor_ID, pc.AD_PrintColor_ID) AS AD_PrintColor_ID, COALESCE (cpf.AD_PrintFont_ID, pf.AD_PrintFont_ID) AS AD_PrintFont_ID, COALESCE (cpp.AD_PrintPaper_ID, pp.AD_PrintPaper_ID) AS AD_PrintPaper_ID FROM AD_Table t, AD_Client c LEFT OUTER JOIN AD_PrintColor cpc ON (cpc.AD_Client_ID=c.AD_Client_ID AND cpc.IsDefault='Y') LEFT OUTER JOIN AD_PrintFont cpf ON (cpf.AD_Client_ID=c.AD_Client_ID AND cpf.IsDefault='Y') LEFT OUTER JOIN AD_PrintPaper cpp ON (cpp.AD_Client_ID=c.AD_Client_ID AND cpp.IsDefault='Y'), AD_PrintColor pc, AD_PrintFont pf, AD_PrintPaper pp WHERE t.AD_Table_ID=? AND c.AD_Client_ID=? AND pc.IsDefault='Y' AND pf.IsDefault='Y' AND pp.IsDefault='Y'";
            error = true;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, gridTab.getAD_Table_ID());
                    pstmt.setInt(2, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        String TableName = rs.getString(1);
                        String ColumnName = TableName + "_ID";
                        Object basename = ColumnName;
                        if (!ColumnName.equals("T_Report_ID") && ColumnName.equals(basename = Msg.translate(ctx, ColumnName))) {
                            basename = Msg.translate(ctx, TableName);
                        }
                        MPrintFormat.setUniqueName(AD_Client_ID, pf, (String)basename);
                        pf.setAD_PrintColor_ID(rs.getInt(2));
                        pf.setAD_PrintFont_ID(rs.getInt(3));
                        pf.setAD_PrintPaper_ID(rs.getInt(4));
                        error = false;
                    } else {
                        s_log.log(Level.SEVERE, "No info found " + gridTab.getAD_Table_ID());
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block20;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (error) {
            return null;
        }
        pf.saveEx();
        GridField[] gridFields = null;
        GridTable tableModel = gridTab.getTableModel();
        GridField[] tmpFields = tableModel.getFields();
        MTabCustomization tabCustomization = MTabCustomization.get(Env.getCtx(), Env.getAD_User_ID(Env.getCtx()), gridTab.getAD_Tab_ID(), null);
        if (!allColumns && tabCustomization != null && tabCustomization.getAD_Tab_Customization_ID() > 0 && tabCustomization.getCustom() != null && tabCustomization.getCustom().trim().length() > 0) {
            String custom = tabCustomization.getCustom().trim();
            String[] customComponent = custom.split(";");
            String[] fieldIds = customComponent[0].split("[,]");
            ArrayList<GridField> fieldList = new ArrayList<GridField>();
            String[] stringArray = fieldIds;
            int n = fieldIds.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldIdStr = stringArray[n2];
                if ((fieldIdStr = fieldIdStr.trim()).length() != 0) {
                    int AD_Field_ID = Integer.parseInt(fieldIdStr);
                    GridField[] gridFieldArray = tmpFields;
                    int n3 = tmpFields.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        GridField gridField = gridFieldArray[n4];
                        if (gridField.getAD_Field_ID() == AD_Field_ID) {
                            if (!gridField.isDisplayedGrid()) break;
                            fieldList.add(gridField);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            gridFields = fieldList.toArray(new GridField[0]);
        } else {
            ArrayList<GridField> gridFieldList = new ArrayList<GridField>();
            GridField[] gridFieldArray = tmpFields;
            int n = tmpFields.length;
            int fieldIds = 0;
            while (fieldIds < n) {
                GridField field = gridFieldArray[fieldIds];
                if (field.isDisplayedGrid()) {
                    gridFieldList.add(field);
                }
                ++fieldIds;
            }
            Collections.sort(gridFieldList, new Comparator<GridField>(){

                @Override
                public int compare(GridField o1, GridField o2) {
                    return o1.getSeqNoGrid() - o2.getSeqNoGrid();
                }
            });
            gridFields = new GridField[gridFieldList.size()];
            gridFieldList.toArray(gridFields);
        }
        ArrayList<MPrintFormatItem> printFormatItemList = new ArrayList<MPrintFormatItem>();
        int seqNo = 1;
        GridField[] gridFieldArray = gridFields;
        int n = gridFields.length;
        int n5 = 0;
        while (n5 < n) {
            MPrintFormatItem pfi;
            GridField gridField = gridFieldArray[n5];
            if (!gridField.isVirtualUIColumn() && (pfi = MPrintFormatItem.createFromGridField(pf, gridField, seqNo++)) != null) {
                printFormatItemList.add(pfi);
                if (s_log.isLoggable(Level.FINEST)) {
                    s_log.finest("Tab: " + String.valueOf(pfi));
                }
            }
            ++n5;
        }
        MPrintFormatItem[] printFormatItems = new MPrintFormatItem[printFormatItemList.size()];
        printFormatItemList.toArray(printFormatItems);
        pf.setItems(printFormatItems);
        return pf;
    }

    private static boolean exists(int clientID, String name) {
        int cnt = DB.getSQLValue(null, "SELECT COUNT(*) FROM AD_PrintFormat WHERE AD_Client_ID=? AND Name=?", clientID, name);
        return cnt > 0;
    }

    public static MPrintFormat createFromTable(Properties ctx, int AD_Table_ID) {
        return MPrintFormat.createFromTable(ctx, AD_Table_ID, 0);
    }

    public static MPrintFormat createFromTable(Properties ctx, int AD_Table_ID, int AD_PrintFormat_ID) {
        return MPrintFormat.createFromTable(ctx, AD_Table_ID, AD_PrintFormat_ID, null);
    }

    public static MPrintFormat createFromTable(Properties ctx, int AD_Table_ID, int AD_PrintFormat_ID, String trxName) {
        boolean error;
        MPrintFormat pf;
        block10: {
            int AD_Client_ID = Env.getAD_Client_ID(ctx);
            if (s_log.isLoggable(Level.INFO)) {
                s_log.info("AD_Table_ID=" + AD_Table_ID + " - AD_Client_ID=" + AD_Client_ID);
            }
            pf = new MPrintFormat(ctx, AD_PrintFormat_ID, trxName);
            pf.setAD_Table_ID(AD_Table_ID);
            String sql = "SELECT TableName, COALESCE (cpc.AD_PrintColor_ID, pc.AD_PrintColor_ID) AS AD_PrintColor_ID, COALESCE (cpf.AD_PrintFont_ID, pf.AD_PrintFont_ID) AS AD_PrintFont_ID, COALESCE (cpp.AD_PrintPaper_ID, pp.AD_PrintPaper_ID) AS AD_PrintPaper_ID FROM AD_Table t, AD_Client c LEFT OUTER JOIN AD_PrintColor cpc ON (cpc.AD_Client_ID=c.AD_Client_ID AND cpc.IsDefault='Y') LEFT OUTER JOIN AD_PrintFont cpf ON (cpf.AD_Client_ID=c.AD_Client_ID AND cpf.IsDefault='Y') LEFT OUTER JOIN AD_PrintPaper cpp ON (cpp.AD_Client_ID=c.AD_Client_ID AND cpp.IsDefault='Y'), AD_PrintColor pc, AD_PrintFont pf, AD_PrintPaper pp WHERE t.AD_Table_ID=? AND c.AD_Client_ID=? AND pc.IsDefault='Y' AND pf.IsDefault='Y' AND pp.IsDefault='Y'";
            error = true;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, AD_Table_ID);
                    pstmt.setInt(2, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        String TableName = rs.getString(1);
                        String ColumnName = TableName + "_ID";
                        Object basename = ColumnName;
                        if (!ColumnName.equals("T_Report_ID") && ColumnName.equals(basename = Msg.translate(ctx, ColumnName))) {
                            basename = Msg.translate(ctx, TableName);
                        }
                        MPrintFormat.setUniqueName(AD_Client_ID, pf, (String)basename);
                        pf.setAD_PrintColor_ID(rs.getInt(2));
                        pf.setAD_PrintFont_ID(rs.getInt(3));
                        pf.setAD_PrintPaper_ID(rs.getInt(4));
                        error = false;
                    } else {
                        s_log.log(Level.SEVERE, "No info found " + AD_Table_ID);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (error) {
            return null;
        }
        pf.saveEx();
        pf.setItems(MPrintFormat.createItems(ctx, pf));
        return pf;
    }

    public static MPrintFormat createFromReportView(Properties ctx, int AD_ReportView_ID, String ReportName) {
        boolean error;
        MPrintFormat pf;
        block10: {
            int AD_Client_ID = Env.getAD_Client_ID(ctx);
            if (s_log.isLoggable(Level.INFO)) {
                s_log.info("AD_ReportView_ID=" + AD_ReportView_ID + " - AD_Client_ID=" + AD_Client_ID + " - " + ReportName);
            }
            pf = new MPrintFormat(ctx, 0, null);
            pf.setAD_ReportView_ID(AD_ReportView_ID);
            String sql = "SELECT t.TableName, COALESCE (cpc.AD_PrintColor_ID, pc.AD_PrintColor_ID) AS AD_PrintColor_ID, COALESCE (cpf.AD_PrintFont_ID, pf.AD_PrintFont_ID) AS AD_PrintFont_ID, COALESCE (cpp.AD_PrintPaper_ID, pp.AD_PrintPaper_ID) AS AD_PrintPaper_ID, t.AD_Table_ID FROM AD_ReportView rv INNER JOIN AD_Table t ON (rv.AD_Table_ID=t.AD_Table_ID), AD_Client c LEFT OUTER JOIN AD_PrintColor cpc ON (cpc.AD_Client_ID=c.AD_Client_ID AND cpc.IsDefault='Y') LEFT OUTER JOIN AD_PrintFont cpf ON (cpf.AD_Client_ID=c.AD_Client_ID AND cpf.IsDefault='Y') LEFT OUTER JOIN AD_PrintPaper cpp ON (cpp.AD_Client_ID=c.AD_Client_ID AND cpp.IsDefault='Y'), AD_PrintColor pc, AD_PrintFont pf, AD_PrintPaper pp WHERE rv.AD_ReportView_ID=? AND c.AD_Client_ID=? AND pc.IsDefault='Y' AND pf.IsDefault='Y' AND pp.IsDefault='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            error = true;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_ReportView_ID);
                    pstmt.setInt(2, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        String basename = ReportName;
                        if (basename == null || basename.length() == 0) {
                            basename = rs.getString(1);
                        }
                        MPrintFormat.setUniqueName(AD_Client_ID, pf, basename);
                        pf.setAD_PrintColor_ID(rs.getInt(2));
                        pf.setAD_PrintFont_ID(rs.getInt(3));
                        pf.setAD_PrintPaper_ID(rs.getInt(4));
                        pf.setAD_Table_ID(rs.getInt(5));
                        error = false;
                    } else {
                        s_log.log(Level.SEVERE, "Not found: AD_ReportView_ID=" + AD_ReportView_ID);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (error) {
            return null;
        }
        pf.saveEx();
        pf.setItems(MPrintFormat.createItems(ctx, pf));
        return pf;
    }

    public static void setUniqueName(int AD_Client_ID, MPrintFormat pf, String basename) {
        Object name = basename;
        pf.setName((String)name);
        boolean dateAsSuffix = true;
        boolean sleep = false;
        while (MPrintFormat.exists(AD_Client_ID, pf.getName())) {
            if (sleep) {
                Env.sleep(1);
            } else {
                sleep = true;
            }
            name = dateAsSuffix ? basename + "_" + MPrintFormat.getDateTime() : MPrintFormat.getDateTime() + "_" + basename;
            pf.setName((String)name);
            if (!sleep || ((String)name).equals(pf.getName())) continue;
            dateAsSuffix = false;
        }
    }

    private static MPrintFormatItem[] createItems(Properties ctx, MPrintFormat format) {
        ArrayList<MPrintFormatItem> list;
        block15: {
            MPrintFormatItem pfi;
            MColumn column;
            int columnID;
            ResultSet rs;
            CPreparedStatement pstmt;
            String sql;
            block13: {
                s_log.fine("From window Tab ...");
                list = new ArrayList<MPrintFormatItem>();
                sql = "SELECT AD_Column_ID FROM AD_Field WHERE IsActive='Y' AND AD_Tab_ID=(SELECT MIN(AD_Tab_ID) FROM AD_Tab WHERE AD_Table_ID=? AND IsActive='Y') AND IsEncrypted='N' AND ObscureType IS NULL  AND AD_Column_ID NOT IN (SELECT pfi.AD_Column_ID FROM AD_PrintFormatItem pfi WHERE pfi.AD_PrintFormat_ID=? AND pfi.AD_Column_ID IS NOT NULL)  AND (AD_Column_ID IN (SELECT AD_Column_ID FROM AD_ReportView_Column WHERE AD_ReportView_ID=? AND IsActive='Y')  OR ((SELECT COUNT(*) FROM AD_ReportView_Column WHERE AD_ReportView_ID=? AND IsActive='Y') = 0)) ORDER BY COALESCE(IsDisplayed,'N') DESC, SortNo, SeqNo, Name";
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, format.get_TrxName());
                        pstmt.setInt(1, format.getAD_Table_ID());
                        pstmt.setInt(2, format.getAD_PrintFormat_ID());
                        pstmt.setInt(3, format.getAD_ReportView_ID());
                        pstmt.setInt(4, format.getAD_ReportView_ID());
                        rs = pstmt.executeQuery();
                        int seqNo = 1;
                        while (rs.next()) {
                            columnID = rs.getInt(1);
                            column = MColumn.get(ctx, columnID);
                            if (column.isVirtualUIColumn() || (pfi = MPrintFormatItem.createFromColumn(format, columnID, seqNo++)) == null) continue;
                            list.add(pfi);
                            if (!s_log.isLoggable(Level.FINEST)) continue;
                            s_log.finest("Tab: " + String.valueOf(pfi));
                        }
                    }
                    catch (SQLException e) {
                        s_log.log(Level.SEVERE, "(tab) - " + sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (list.size() == 0) {
                s_log.fine("From Table ...");
                sql = "SELECT AD_Column_ID FROM AD_Column WHERE IsActive='Y' AND AD_Table_ID=?  AND AD_Column_ID NOT IN (SELECT pfi.AD_Column_ID FROM AD_PrintFormatItem pfi WHERE pfi.AD_PrintFormat_ID=? AND pfi.AD_Column_ID IS NOT NULL)  AND (AD_Column_ID IN (SELECT AD_Column_ID FROM AD_ReportView_Column WHERE AD_ReportView_ID=? AND IsActive='Y')  OR ((SELECT COUNT(*) FROM AD_ReportView_Column WHERE AD_ReportView_ID=?) = 0 AND IsActive='Y')) ORDER BY IsIdentifier DESC, SeqNo, Name";
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, format.get_TrxName());
                        pstmt.setInt(1, format.getAD_Table_ID());
                        pstmt.setInt(2, format.getAD_PrintFormat_ID());
                        pstmt.setInt(3, format.getAD_ReportView_ID());
                        pstmt.setInt(4, format.getAD_ReportView_ID());
                        rs = pstmt.executeQuery();
                        int seqNo = 1;
                        while (rs.next()) {
                            columnID = rs.getInt(1);
                            column = MColumn.get(ctx, columnID);
                            if (column.isVirtualUIColumn() || (pfi = MPrintFormatItem.createFromColumn(format, columnID, seqNo++)) == null) continue;
                            list.add(pfi);
                            if (!s_log.isLoggable(Level.FINEST)) continue;
                            s_log.finest("Table: " + String.valueOf(pfi));
                        }
                    }
                    catch (SQLException e) {
                        s_log.log(Level.SEVERE, "(table) - " + sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        MPrintFormatItem[] retValue = new MPrintFormatItem[list.size()];
        list.toArray(retValue);
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info(String.valueOf(format) + " - #" + retValue.length);
        }
        return retValue;
    }

    private static MPrintFormatItem[] copyItems(MPrintFormat fromFormat, MPrintFormat toFormat) {
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info("From=" + String.valueOf(fromFormat));
        }
        ArrayList<MPrintFormatItem> list = new ArrayList<MPrintFormatItem>();
        MPrintFormatItem[] items = fromFormat.getItemsNotIn(toFormat.get_ID());
        int i2 = 0;
        while (i2 < items.length) {
            MPrintFormatItem pfi = items[i2].copyToClient(toFormat.getAD_Client_ID(), toFormat.get_ID(), toFormat.get_TrxName());
            if (pfi != null) {
                list.add(pfi);
            }
            ++i2;
        }
        MPrintFormatItem[] retValue = new MPrintFormatItem[list.size()];
        list.toArray(retValue);
        MPrintFormat.copyTranslationItems(items, retValue, toFormat.get_TrxName());
        return retValue;
    }

    private static void copyTranslationItems(MPrintFormatItem[] fromItems, MPrintFormatItem[] toItems, String trxName) {
        if (fromItems == null || toItems == null) {
            return;
        }
        int counter = 0;
        int i2 = 0;
        while (i2 < fromItems.length) {
            int fromID = fromItems[i2].getAD_PrintFormatItem_ID();
            int toID = toItems[i2].getAD_PrintFormatItem_ID();
            StringBuilder sql = new StringBuilder("UPDATE AD_PrintFormatItem_Trl new ").append("SET (PrintName, PrintNameSuffix, IsTranslated) = ").append("(").append("SELECT PrintName, PrintNameSuffix, IsTranslated ").append("FROM AD_PrintFormatItem_Trl old ").append("WHERE old.AD_Language=new.AD_Language").append(" AND AD_PrintFormatItem_ID =").append(fromID).append(") ").append("WHERE  AD_PrintFormatItem_ID=").append(toID).append(" AND EXISTS (SELECT AD_PrintFormatItem_ID ").append(" FROM AD_PrintFormatItem_trl old").append(" WHERE old.AD_Language=new.AD_Language").append(" AND AD_PrintFormatItem_ID =").append(fromID).append(")");
            int no = DB.executeUpdate(sql.toString(), trxName);
            if (no == 0) break;
            counter += no;
            ++i2;
        }
        if (s_log.isLoggable(Level.FINEST)) {
            s_log.finest("#" + counter);
        }
    }

    public static MPrintFormat copy(Properties ctx, int from_AD_PrintFormat_ID, int to_AD_PrintFormat_ID) {
        return MPrintFormat.copy(ctx, from_AD_PrintFormat_ID, to_AD_PrintFormat_ID, -1);
    }

    public static MPrintFormat copyToClient(Properties ctx, int AD_PrintFormat_ID, int to_Client_ID) {
        return MPrintFormat.copyToClient(ctx, AD_PrintFormat_ID, to_Client_ID, null);
    }

    public static MPrintFormat copyToClient(Properties ctx, int AD_PrintFormat_ID, int to_Client_ID, String trxName) {
        return MPrintFormat.copy(ctx, AD_PrintFormat_ID, 0, to_Client_ID, trxName);
    }

    private static MPrintFormat copy(Properties ctx, int from_AD_PrintFormat_ID, int to_AD_PrintFormat_ID, int to_Client_ID) {
        return MPrintFormat.copy(ctx, from_AD_PrintFormat_ID, to_AD_PrintFormat_ID, to_Client_ID, null);
    }

    private static MPrintFormat copy(Properties ctx, int from_AD_PrintFormat_ID, int to_AD_PrintFormat_ID, int to_Client_ID, String trxName) {
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info("From AD_PrintFormat_ID=" + from_AD_PrintFormat_ID + ", To AD_PrintFormat_ID=" + to_AD_PrintFormat_ID + ", To Client_ID=" + to_Client_ID);
        }
        if (from_AD_PrintFormat_ID == 0) {
            throw new IllegalArgumentException("From_AD_PrintFormat_ID is 0");
        }
        MPrintFormat from = new MPrintFormat(ctx, from_AD_PrintFormat_ID, trxName);
        MPrintFormat to = new MPrintFormat(ctx, to_AD_PrintFormat_ID, trxName);
        MPrintFormat.copyValues(from, to);
        if (to_AD_PrintFormat_ID == 0) {
            if (to_Client_ID < 0) {
                to_Client_ID = Env.getAD_Client_ID(ctx);
            }
            to.setClientOrg(to_Client_ID, 0);
        }
        to.setName(Util.replace(to.getName(), "TEMPLATE", String.valueOf(to_Client_ID)));
        to.setName(to.getName() + " - " + Util.cleanAmp(Msg.getMsg(ctx, "Copy")));
        MPrintFormat.setUniqueName(to.getAD_Client_ID(), to, to.getName());
        to.saveEx();
        to.setItems(MPrintFormat.copyItems(from, to));
        return to;
    }

    private static String getDateTime() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String dt = sdf.format(cal.getTime());
        return dt;
    }

    public static MPrintFormat get(int AD_PrintFormat_ID) {
        return MPrintFormat.get(Env.getCtx(), AD_PrintFormat_ID, false);
    }

    public static MPrintFormat get(Properties ctx, int AD_PrintFormat_ID, boolean readFromDisk) {
        StringBuilder key = new StringBuilder().append(AD_PrintFormat_ID).append("|").append(MRole.getDefault().getAD_Role_ID());
        MPrintFormat pf = null;
        if (!readFromDisk) {
            pf = s_formats.get(ctx, key.toString(), e -> new MPrintFormat(ctx, (MPrintFormat)e));
        }
        if (pf == null) {
            pf = new MPrintFormat(ctx, AD_PrintFormat_ID, null);
            if (pf.get_ID() == AD_PrintFormat_ID) {
                s_formats.put(key.toString(), pf, e -> new MPrintFormat(Env.getCtx(), (MPrintFormat)e));
                return pf;
            }
            return null;
        }
        return pf;
    }

    public static MPrintFormat get(Properties ctx, int AD_ReportView_ID, int AD_Table_ID) {
        MPrintFormat retValue;
        block6: {
            retValue = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            Object sql = "SELECT * FROM AD_PrintFormat WHERE ";
            sql = AD_ReportView_ID > 0 ? (String)sql + "AD_ReportView_ID=?" : (String)sql + "AD_Table_ID=?";
            sql = (String)sql + " ORDER BY IsDefault DESC";
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, AD_ReportView_ID > 0 ? AD_ReportView_ID : AD_Table_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MPrintFormat(ctx, rs, null);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, (String)sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public static void deleteFromCache(int AD_PrintFormat_ID) {
        StringBuilder key = new StringBuilder().append(AD_PrintFormat_ID).append("|").append(MRole.getDefault().getAD_Role_ID());
        s_formats.put(key.toString(), null);
    }

    public static int getPrintFormat_ID(String formatName, int AD_Table_ID, int AD_Client_ID) {
        return DB.getSQLValue(null, "SELECT AD_PrintFormat_ID FROM AD_PrintFormat WHERE Name = ? AND AD_Table_ID = ? AND AD_Client_ID IN (0, ?) ORDER BY AD_Client_ID DESC", formatName, AD_Table_ID, AD_Client_ID);
    }

    public static List<KeyNamePair> getAccessiblePrintFormats(int AD_Table_ID, int AD_Window_ID, String trxName, boolean makeNewWhenEmpty) {
        String constantForRoleAccess = "SELECT * FROM AD_PrintFormat WHERE ";
        StringBuilder sqlWhereB = new StringBuilder(constantForRoleAccess).append("AD_Table_ID=? AND IsTableBased='Y' ");
        if (AD_Window_ID > 0) {
            sqlWhereB.append("AND (AD_Window_ID=? OR AD_Window_ID IS NULL)");
        }
        String sqlWhere = MRole.getDefault().addAccessSQL(sqlWhereB.toString(), "AD_PrintFormat", false, false);
        sqlWhere = sqlWhere.substring(constantForRoleAccess.length());
        ArrayList<Object> lsParameter = new ArrayList<Object>();
        lsParameter.add(AD_Table_ID);
        if (AD_Window_ID > 0) {
            lsParameter.add(AD_Window_ID);
        }
        Query query = new Query(Env.getCtx(), "AD_PrintFormat", sqlWhere, trxName);
        query.setParameters(lsParameter);
        query.setOnlyActiveRecords(true);
        query.setOrderBy(" ORDER BY AD_Client_ID DESC, IsDefault DESC, Name ");
        List lsPrintFormat = query.setClient_ID().list();
        X_AD_PrintFormat newPrintFormat = null;
        if (lsPrintFormat.size() == 0) {
            newPrintFormat = (MPrintFormat)query.setClient_ID(false).first();
        }
        if (newPrintFormat != null) {
            newPrintFormat = MPrintFormat.copyToClient(Env.getCtx(), newPrintFormat.getAD_PrintFormat_ID(), Env.getAD_Client_ID(Env.getCtx()));
            lsPrintFormat.add(newPrintFormat);
        }
        if (lsPrintFormat.size() == 0) {
            newPrintFormat = MPrintFormat.createFromTable(Env.getCtx(), AD_Table_ID);
            lsPrintFormat.add(newPrintFormat);
        }
        ArrayList<KeyNamePair> m_list = new ArrayList<KeyNamePair>();
        for (MPrintFormat printFormat : lsPrintFormat) {
            m_list.add(new KeyNamePair(printFormat.get_ID(), printFormat.get_Translation("Name")));
        }
        return m_list;
    }

    @Override
    @Deprecated
    public MPrintFormat clone() throws CloneNotSupportedException {
        MPrintFormat clone = (MPrintFormat)super.clone();
        clone.m_items = this.getItems() == null ? null : new MPrintFormatItem[this.getItems().length];
        int i2 = 0;
        while (i2 < this.getItems().length) {
            clone.m_items[i2] = this.getItems()[i2];
            ++i2;
        }
        clone.m_tFormat = this.m_tFormat;
        clone.m_language = Env.getLanguage(Env.getCtx());
        clone.m_translationViewLanguage = null;
        return clone;
    }

    public static int getZoomWindowID(int AD_PrintFormat_ID) {
        int pfAD_Window_ID = Env.getZoomWindowID(493, AD_PrintFormat_ID);
        return pfAD_Window_ID;
    }

    @Override
    public MPrintFormat markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.getItems() != null && this.getItems().length > 0) {
            Arrays.stream(this.getItems()).forEach(e -> {
                MPrintFormatItem mPrintFormatItem = e.markImmutable();
            });
        }
        if (this.m_tFormat != null) {
            this.m_tFormat.markImmutable();
        }
        return this;
    }
}

