/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.base.IProductPricing;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_M_Product;
import org.compiere.model.I_M_Requisition;
import org.compiere.model.MCharge;
import org.compiere.model.MProduct;
import org.compiere.model.MRequisition;
import org.compiere.model.Query;
import org.compiere.model.X_M_RequisitionLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MRequisitionLine
extends X_M_RequisitionLine {
    private static final long serialVersionUID = -2567343619431184322L;
    private MRequisition m_parent = null;
    private int m_M_PriceList_ID = 0;

    public static MRequisitionLine[] forC_Order_ID(Properties ctx, int C_Order_ID, String trxName) {
        List<MRequisitionLine> list = new Query(ctx, "M_RequisitionLine", "EXISTS (SELECT 1 FROM C_OrderLine ol WHERE ol.C_OrderLine_ID=M_RequisitionLine.C_OrderLine_ID AND ol.C_Order_ID=?)", trxName).setParameters(C_Order_ID).list();
        return list.toArray(new MRequisitionLine[list.size()]);
    }

    public static void unlinkC_Order_ID(Properties ctx, int C_Order_ID, String trxName) {
        MRequisitionLine[] mRequisitionLineArray = MRequisitionLine.forC_Order_ID(ctx, C_Order_ID, trxName);
        int n = mRequisitionLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MRequisitionLine line = mRequisitionLineArray[n2];
            line.setC_OrderLine_ID(0);
            line.saveEx();
            ++n2;
        }
    }

    public static MRequisitionLine[] forC_OrderLine_ID(Properties ctx, int C_OrderLine_ID, String trxName) {
        List<MRequisitionLine> list = new Query(ctx, "M_RequisitionLine", "C_OrderLine_ID=?", trxName).setParameters(C_OrderLine_ID).list();
        return list.toArray(new MRequisitionLine[list.size()]);
    }

    public static void unlinkC_OrderLine_ID(Properties ctx, int C_OrderLine_ID, String trxName) {
        MRequisitionLine[] mRequisitionLineArray = MRequisitionLine.forC_OrderLine_ID(ctx, C_OrderLine_ID, trxName);
        int n = mRequisitionLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MRequisitionLine line = mRequisitionLineArray[n2];
            line.setC_OrderLine_ID(0);
            line.saveEx();
            ++n2;
        }
    }

    public MRequisitionLine(Properties ctx, String M_RequisitionLine_UU, String trxName) {
        super(ctx, M_RequisitionLine_UU, trxName);
        if (Util.isEmpty(M_RequisitionLine_UU)) {
            this.setInitialDefaults();
        }
    }

    public MRequisitionLine(Properties ctx, int M_RequisitionLine_ID, String trxName) {
        this(ctx, M_RequisitionLine_ID, trxName, null);
    }

    public MRequisitionLine(Properties ctx, int M_RequisitionLine_ID, String trxName, String ... virtualColumns) {
        super(ctx, M_RequisitionLine_ID, trxName, virtualColumns);
        if (M_RequisitionLine_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setLine(0);
        this.setLineNetAmt(Env.ZERO);
        this.setPriceActual(Env.ZERO);
        this.setQty(Env.ONE);
    }

    public MRequisitionLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRequisitionLine(MRequisition req) {
        this(req.getCtx(), 0, req.get_TrxName());
        this.setClientOrg(req);
        this.setM_Requisition_ID(req.getM_Requisition_ID());
        this.m_M_PriceList_ID = req.getM_PriceList_ID();
        this.m_parent = req;
    }

    public BigDecimal getQtyOrdered() {
        if (this.getC_OrderLine_ID() > 0) {
            return this.getQty();
        }
        return Env.ZERO;
    }

    public MRequisition getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MRequisition(this.getCtx(), this.getM_Requisition_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    @Override
    public I_M_Requisition getM_Requisition() {
        return this.getParent();
    }

    public Timestamp getDateRequired() {
        return this.getParent().getDateRequired();
    }

    public void setPrice() {
        if (this.getC_Charge_ID() != 0) {
            MCharge charge = MCharge.get(this.getCtx(), this.getC_Charge_ID());
            this.setPriceActual(charge.getChargeAmt());
        }
        if (this.getM_Product_ID() == 0) {
            return;
        }
        if (this.m_M_PriceList_ID == 0) {
            this.m_M_PriceList_ID = this.getParent().getM_PriceList_ID();
        }
        if (this.m_M_PriceList_ID == 0) {
            throw new AdempiereException("PriceList unknown!");
        }
        this.setPrice(this.m_M_PriceList_ID);
    }

    public void setPrice(int M_PriceList_ID) {
        if (this.getM_Product_ID() == 0) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("M_PriceList_ID=" + M_PriceList_ID);
        }
        IProductPricing pp = Core.getProductPricing();
        pp.setRequisitionLine(this, this.get_TrxName());
        pp.setM_PriceList_ID(M_PriceList_ID);
        this.setPriceActual(pp.getPriceStd());
    }

    public void setLineNetAmt() {
        BigDecimal lineNetAmt = this.getQty().multiply(this.getPriceActual());
        super.setLineNetAmt(lineNetAmt);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && this.getParent().isProcessed()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "M_Requisition_ID"));
            return false;
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM M_RequisitionLine WHERE M_Requisition_ID=?";
            int ii = DB.getSQLValueEx(this.get_TrxName(), sql, this.getM_Requisition_ID());
            this.setLine(ii);
        }
        if (this.getM_Product_ID() != 0 && this.getC_Charge_ID() != 0) {
            this.setC_Charge_ID(0);
        }
        if (this.getM_AttributeSetInstance_ID() != 0 && this.getC_Charge_ID() != 0) {
            this.setM_AttributeSetInstance_ID(0);
        }
        if (this.getM_Product_ID() > 0 && this.getC_UOM_ID() <= 0) {
            this.setC_UOM_ID(this.getM_Product().getC_UOM_ID());
        }
        if (this.getPriceActual().signum() == 0) {
            this.setPrice();
        }
        this.setLineNetAmt();
        if (this.getParent().getC_DocType().isChargeOrProductMandatory() && this.getC_Charge_ID() == 0 && this.getM_Product_ID() == 0 && (this.getPriceActual().signum() != 0 || this.getQty().signum() != 0)) {
            this.log.saveError("FillMandatory", Msg.translate(this.getCtx(), "ChargeOrProductMandatory"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeader();
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeader();
    }

    @Override
    public I_M_Product getM_Product() {
        return MProduct.getCopy(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
    }

    private boolean updateHeader() {
        this.log.fine("");
        String sql = "UPDATE M_Requisition r SET TotalLines=(SELECT COALESCE(SUM(LineNetAmt),0) FROM M_RequisitionLine rl WHERE r.M_Requisition_ID=rl.M_Requisition_ID) WHERE M_Requisition_ID=?";
        int no = DB.executeUpdateEx(sql, new Object[]{this.getM_Requisition_ID()}, this.get_TrxName());
        if (no != 1) {
            this.log.log(Level.SEVERE, "Header update #" + no);
        }
        this.m_parent = null;
        return no == 1;
    }
}

