/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.adempiere.model.ShippingPackage;
import org.adempiere.util.ShippingUtil;
import org.compiere.model.MClientInfo;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProduct;
import org.compiere.model.MShipper;
import org.compiere.model.MShipperLabels;
import org.compiere.model.MShipperPackaging;
import org.compiere.model.MShipperPickupTypes;
import org.compiere.model.MShippingTransaction;
import org.compiere.model.MShippingTransactionLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.model.X_C_OrderLine;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DisplayType;

@Process
public class SalesOrderRateInquiryProcess
extends SvrProcess {
    private boolean p_IsPriviledgedRate = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() != null) {
                if (name.equals("IsPriviledgedRate")) {
                    this.p_IsPriviledgedRate = ((String)para[i2].getParameter()).equals("Y");
                } else {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para[i2]);
                }
            }
            ++i2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        MOrder m_order = new MOrder(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (m_order.getM_Shipper_ID() == 0) {
            throw new FillMandatoryException(new String[]{"M_Shipper_ID"});
        }
        MClientInfo ci = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        if (ci.getC_ChargeFreight_ID() == 0 && ci.getM_ProductFreight_ID() == 0) {
            throw new AdempiereException("Product or Charge for Freight is not defined at Tenant window > Tenant Info tab");
        }
        if (ci.getC_UOM_Weight_ID() == 0) {
            throw new AdempiereException("UOM for Weight is not defined at Tenant window > Tenant Info tab");
        }
        if (ci.getC_UOM_Length_ID() == 0) {
            throw new AdempiereException("UOM for Length is not defined at Tenant window > Tenant Info tab");
        }
        MOrderLine[] ols = m_order.getLines(false, "Line");
        if (ols.length == 0) {
            throw new AdempiereException("@NoLines@");
        }
        MOrderLine[] mOrderLineArray = ols;
        int n = ols.length;
        int n2 = 0;
        while (n2 < n) {
            BigDecimal weight;
            MProduct product;
            MOrderLine ol = mOrderLineArray[n2];
            if (!(ol.getM_Product_ID() > 0 && ol.getM_Product_ID() == ci.getM_ProductFreight_ID() || ol.getC_Charge_ID() > 0 && ol.getC_Charge_ID() == ci.getC_ChargeFreight_ID() || ol.getM_Product_ID() <= 0 || (product = new MProduct(this.getCtx(), ol.getM_Product_ID(), this.get_TrxName())).isService() || (weight = product.getWeight()) != null && weight.compareTo(BigDecimal.ZERO) != 0)) {
                throw new AdempiereException("No weight defined for product " + product.toString());
            }
            ++n2;
        }
        boolean ok = false;
        MShippingTransaction st = null;
        try {
            st = SalesOrderRateInquiryProcess.createShippingTransaction(this.getCtx(), m_order, "RI", this.p_IsPriviledgedRate, this.get_TrxName());
            ok = st.processOnline();
            st.saveEx();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "processOnline", e);
        }
        if (ok) {
            PO freightLine = null;
            MOrderLine[] mOrderLineArray2 = ols;
            int n3 = ols.length;
            int n4 = 0;
            while (n4 < n3) {
                MOrderLine ol = mOrderLineArray2[n4];
                if (ol.getM_Product_ID() > 0 && ol.getM_Product_ID() == ci.getM_ProductFreight_ID() || ol.getC_Charge_ID() > 0 && ol.getC_Charge_ID() == ci.getC_ChargeFreight_ID()) {
                    freightLine = ol;
                    break;
                }
                ++n4;
            }
            if (m_order.getFreightCostRule().equals("I")) {
                boolean deleted;
                if (freightLine != null && !(deleted = freightLine.delete(false))) {
                    ((X_C_OrderLine)freightLine).setC_BPartner_Location_ID(m_order.getC_BPartner_Location_ID());
                    ((X_C_OrderLine)freightLine).setM_Shipper_ID(m_order.getM_Shipper_ID());
                    ((MOrderLine)freightLine).setQty(BigDecimal.ONE);
                    ((MOrderLine)freightLine).setPrice(BigDecimal.ZERO);
                    freightLine.saveEx();
                }
            } else if (m_order.getFreightCostRule().equals("C")) {
                if (freightLine == null) {
                    freightLine = new MOrderLine(m_order);
                    if (ci.getC_ChargeFreight_ID() > 0) {
                        ((MOrderLine)freightLine).setC_Charge_ID(ci.getC_ChargeFreight_ID());
                    } else if (ci.getM_ProductFreight_ID() > 0) {
                        ((X_C_OrderLine)freightLine).setM_Product_ID(ci.getM_ProductFreight_ID());
                    } else {
                        throw new AdempiereException("Product or Charge for Freight is not defined at Tenant window > Tenant Info tab");
                    }
                }
                ((X_C_OrderLine)freightLine).setC_BPartner_Location_ID(m_order.getC_BPartner_Location_ID());
                ((X_C_OrderLine)freightLine).setM_Shipper_ID(m_order.getM_Shipper_ID());
                ((MOrderLine)freightLine).setQty(BigDecimal.ONE);
                ((MOrderLine)freightLine).setPrice(st.getPrice());
                freightLine.saveEx();
                if (m_order.isPriviledgedRate() != this.p_IsPriviledgedRate) {
                    m_order.setIsPriviledgedRate(this.p_IsPriviledgedRate);
                    m_order.saveEx();
                }
            }
        } else {
            this.getProcessInfo().setError(true);
            this.getProcessInfo().addLog(new ProcessInfoLog(this.getProcessInfo().getAD_Process_ID(), new Timestamp(System.currentTimeMillis()), null, st.getErrorMessage()));
            return "@Error@";
        }
        this.getProcessInfo().addLog(new ProcessInfoLog(this.getProcessInfo().getAD_Process_ID(), new Timestamp(System.currentTimeMillis()), null, st.getShippingRespMessage()));
        return "@OK@";
    }

    public static MShippingTransaction createShippingTransaction(Properties ctx, MOrder m_order, String action, boolean isPriviledgedRate, String trxName) {
        MProduct product;
        MShipper shipper = new MShipper(ctx, m_order.getM_Shipper_ID(), trxName);
        String whereClause = "M_Shipper_ID = " + shipper.getM_Shipper_ID() + " AND IsDefault='Y' AND IsActive='Y'";
        int M_ShipperLabels_ID = 0;
        int[] ids = MShipperLabels.getAllIDs("M_ShipperLabels", whereClause, trxName);
        if (ids.length > 0) {
            M_ShipperLabels_ID = ids[0];
        }
        int M_ShipperPackaging_ID = 0;
        ids = MShipperPackaging.getAllIDs("M_ShipperPackaging", whereClause, trxName);
        if (ids.length > 0) {
            M_ShipperPackaging_ID = ids[0];
        }
        int M_ShipperPickupTypes_ID = 0;
        ids = MShipperPickupTypes.getAllIDs("M_ShipperPickupTypes", whereClause, trxName);
        if (ids.length > 0) {
            M_ShipperPickupTypes_ID = ids[0];
        }
        String ShipperAccount = ShippingUtil.getSenderShipperAccount(shipper.getM_Shipper_ID(), shipper.getAD_Org_ID());
        String DutiesShipperAccount = ShippingUtil.getSenderDutiesShipperAccount(shipper.getM_Shipper_ID(), shipper.getAD_Org_ID());
        MClientInfo ci = MClientInfo.get(ctx, m_order.getAD_Client_ID(), trxName);
        MUOM uom = new MUOM(ctx, ci.getC_UOM_Weight_ID(), null);
        String unit = uom.getX12DE355();
        boolean isPound = false;
        if (unit != null && ((unit = unit.toUpperCase()).equals("LB") || unit.equals("LBS"))) {
            isPound = true;
        }
        BigDecimal kgToPound = new BigDecimal("2.20462");
        MShipperPackaging sp = new MShipperPackaging(ctx, M_ShipperPackaging_ID, trxName);
        BigDecimal WeightPerPackage = sp.getWeight().multiply(isPound ? kgToPound : BigDecimal.ONE);
        if (WeightPerPackage == null || WeightPerPackage.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal thirty = new BigDecimal("30");
            BigDecimal defaultWeightPerPackage = MSysConfig.getBigDecimalValue("SHIPPING_DEFAULT_WEIGHT_PER_PACKAGE", thirty);
            WeightPerPackage = defaultWeightPerPackage.multiply(isPound ? kgToPound : BigDecimal.ONE);
        }
        BigDecimal CODAmount = m_order.getGrandTotal();
        BigDecimal CustomsValue = BigDecimal.ZERO;
        BigDecimal FreightAmt = BigDecimal.ZERO;
        BigDecimal TotalWeight = BigDecimal.ZERO;
        DecimalFormat df = DisplayType.getNumberFormat(29);
        ArrayList<ShippingPackage> packages = new ArrayList<ShippingPackage>();
        ArrayList<Object[]> items = new ArrayList<Object[]>();
        MOrderLine[] ols = m_order.getLines(false, "Line");
        MOrderLine[] mOrderLineArray = ols;
        int n = ols.length;
        int n2 = 0;
        while (n2 < n) {
            MOrderLine ol = mOrderLineArray[n2];
            if (!(ol.getM_Product_ID() > 0 && ol.getM_Product_ID() == ci.getM_ProductFreight_ID() || ol.getC_Charge_ID() > 0 && ol.getC_Charge_ID() == ci.getC_ChargeFreight_ID() || ol.getM_Product_ID() <= 0 || (product = new MProduct(ctx, ol.getM_Product_ID(), trxName)).isService())) {
                BigDecimal weight = product.getWeight();
                if (weight == null || weight.compareTo(BigDecimal.ZERO) == 0) {
                    throw new AdempiereException("No weight defined for product " + product.toString());
                }
                BigDecimal qty = ol.getQtyEntered();
                if (qty == null) {
                    qty = BigDecimal.ZERO;
                }
                if (product.isOwnBox()) {
                    remainingQty = qty;
                    while (remainingQty.compareTo(BigDecimal.ZERO) > 0) {
                        itemQty = new BigDecimal(Math.min(remainingQty.doubleValue(), 1.0));
                        ShippingPackage shippingPackage = new ShippingPackage();
                        shippingPackage.setWeight(weight.multiply(itemQty));
                        shippingPackage.setDescription(df.format(itemQty) + " x " + product.getValue());
                        shippingPackage.setHeight(product.getShelfHeight());
                        shippingPackage.setWidth(new BigDecimal(product.getShelfWidth()));
                        shippingPackage.setLength(new BigDecimal(product.getShelfDepth()));
                        packages.add(shippingPackage);
                        remainingQty = remainingQty.subtract(BigDecimal.ONE);
                    }
                } else {
                    remainingQty = qty;
                    while (remainingQty.compareTo(BigDecimal.ZERO) > 0) {
                        itemQty = new BigDecimal(Math.min(remainingQty.doubleValue(), 1.0));
                        items.add(new Object[]{product, itemQty});
                        remainingQty = remainingQty.subtract(BigDecimal.ONE);
                    }
                }
                TotalWeight = TotalWeight.add(weight.multiply(qty));
            }
            ++n2;
        }
        Hashtable<MProduct, BigDecimal> packageItems = new Hashtable<MProduct, BigDecimal>();
        BigDecimal TotalPackageWeight = BigDecimal.ZERO;
        for (Object[] item : items) {
            product = (MProduct)item[0];
            BigDecimal qty = (BigDecimal)item[1];
            BigDecimal itemWeight = product.getWeight().multiply(qty);
            if (itemWeight.compareTo(WeightPerPackage) >= 0) {
                ArrayList<MProduct> ownBoxProducts = new ArrayList<MProduct>();
                ownBoxProducts.add(product);
                ShippingPackage shippingPackage = new ShippingPackage();
                shippingPackage.setWeight(itemWeight);
                shippingPackage.setDescription(df.format(qty) + " x " + product.getValue());
                shippingPackage.setHeight(product.getShelfHeight());
                shippingPackage.setWidth(new BigDecimal(product.getShelfWidth()));
                shippingPackage.setLength(new BigDecimal(product.getShelfDepth()));
                packages.add(shippingPackage);
                continue;
            }
            if (itemWeight.add(TotalPackageWeight).compareTo(WeightPerPackage) > 0) {
                ShippingPackage shippingPackage = new ShippingPackage();
                shippingPackage.setWeight(TotalPackageWeight);
                Object description = "";
                Enumeration en = packageItems.keys();
                while (en.hasMoreElements()) {
                    MProduct packageProduct = (MProduct)en.nextElement();
                    BigDecimal packageQty = (BigDecimal)packageItems.get(packageProduct);
                    description = (String)description + df.format(packageQty) + " x " + packageProduct.getValue() + ", ";
                }
                if (((String)description).length() > 0) {
                    description = ((String)description).substring(0, ((String)description).length() - 2);
                }
                shippingPackage.setDescription((String)description);
                packages.add(shippingPackage);
                packageItems.clear();
                TotalPackageWeight = BigDecimal.ZERO;
                TotalPackageWeight = TotalPackageWeight.add(itemWeight);
                BigDecimal packageQty = (BigDecimal)packageItems.get(product);
                if (packageQty == null) {
                    packageQty = BigDecimal.ZERO;
                }
                packageItems.put(product, packageQty.add(qty));
                continue;
            }
            TotalPackageWeight = TotalPackageWeight.add(itemWeight);
            BigDecimal packageQty = (BigDecimal)packageItems.get(product);
            if (packageQty == null) {
                packageQty = BigDecimal.ZERO;
            }
            packageItems.put(product, packageQty.add(qty));
        }
        if (TotalPackageWeight.compareTo(BigDecimal.ZERO) > 0) {
            ShippingPackage shippingPackage = new ShippingPackage();
            shippingPackage.setWeight(TotalPackageWeight);
            Object description = "";
            Enumeration en = packageItems.keys();
            while (en.hasMoreElements()) {
                MProduct packageProduct = (MProduct)en.nextElement();
                BigDecimal packageQty = (BigDecimal)packageItems.get(packageProduct);
                description = (String)description + df.format(packageQty) + " x " + packageProduct.getValue() + ", ";
            }
            if (((String)description).length() > 0) {
                description = ((String)description).substring(0, ((String)description).length() - 2);
            }
            shippingPackage.setDescription((String)description);
            packages.add(shippingPackage);
        }
        CustomsValue = CODAmount.subtract(FreightAmt);
        int BoxCount = packages.size();
        MShippingTransaction st = new MShippingTransaction(ctx, 0, trxName);
        st.setAction(action);
        st.setAD_Org_ID(m_order.getAD_Org_ID());
        st.setAD_User_ID(m_order.getAD_User_ID());
        st.setBill_Location_ID(m_order.getBill_Location_ID());
        st.setBoxCount(BoxCount);
        st.setC_BPartner_ID(m_order.getC_BPartner_ID());
        st.setC_BPartner_Location_ID(m_order.getC_BPartner_Location_ID());
        st.setC_Currency_ID(m_order.getC_Currency_ID());
        st.setC_Order_ID(m_order.getC_Order_ID());
        st.setC_UOM_Length_ID(ci.getC_UOM_Length_ID());
        st.setC_UOM_Weight_ID(ci.getC_UOM_Weight_ID());
        st.setCODAmount(CODAmount);
        st.setCustomsValue(CustomsValue);
        st.setDutiesShipperAccount(DutiesShipperAccount);
        st.setFreightAmt(FreightAmt);
        st.setFreightCharges("E_PPB");
        st.setIsActive(m_order.isActive());
        st.setIsPriviledgedRate(isPriviledgedRate);
        st.setIsResidential(shipper.isResidential());
        st.setIsSaturdayDelivery(shipper.isSaturdayDelivery());
        st.setM_Shipper_ID(m_order.getM_Shipper_ID());
        st.setM_ShipperLabels_ID(M_ShipperLabels_ID);
        st.setM_ShipperPackaging_ID(M_ShipperPackaging_ID);
        st.setM_ShipperPickupTypes_ID(M_ShipperPickupTypes_ID);
        st.setM_ShippingProcessor_ID(shipper.getM_ShippingProcessor_ID());
        st.setM_Warehouse_ID(m_order.getM_Warehouse_ID());
        st.setPaymentRule(m_order.getPaymentRule());
        st.setPOReference(m_order.getPOReference());
        st.setSalesRep_ID(m_order.getSalesRep_ID());
        st.setShipDate(m_order.getDatePromised());
        st.setShipperAccount(ShipperAccount);
        st.setTrackingInfo(shipper.getTrackingURL());
        st.setWeight(TotalWeight);
        st.saveEx();
        int i2 = 0;
        while (i2 < packages.size()) {
            ShippingPackage shippingPackage = (ShippingPackage)packages.get(i2);
            MShippingTransactionLine stl = new MShippingTransactionLine(st.getCtx(), 0, st.get_TrxName());
            stl.setAD_Org_ID(m_order.getAD_Org_ID());
            stl.setC_UOM_Length_ID(ci.getC_UOM_Length_ID());
            stl.setC_UOM_Weight_ID(ci.getC_UOM_Weight_ID());
            stl.setDescription(shippingPackage.getDescription());
            stl.setHeight(shippingPackage.getHeight());
            stl.setIsActive(m_order.isActive());
            stl.setLength(shippingPackage.getLength());
            stl.setM_ShippingTransaction_ID(st.getM_ShippingTransaction_ID());
            stl.setSeqNo((i2 + 1) * 10);
            stl.setWeight(shippingPackage.getWeight());
            stl.setWidth(shippingPackage.getWidth());
            stl.saveEx();
            ++i2;
        }
        return st;
    }
}

