/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.util.ArrayList;
import java.util.List;
import org.adempiere.base.ICalloutFactory;
import org.adempiere.base.IColumnCallout;
import org.adempiere.base.IColumnCalloutFactory;
import org.adempiere.base.IMappedColumnCalloutFactory;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.compiere.model.Callout;
import org.compiere.util.CCache;
import org.osgi.framework.ServiceReference;

public final class ColumnCalloutManager {
    public static final String ICALLOUT_FACTORY_CACHE_TABLE_NAME = "_ICalloutFactory_Cache";
    public static final String LIST_ICOLUMNCALLOUT_FACTORY_CACHE_TABLE_NAME = "_List_IColumnCalloutFactory_Cache";
    private static final CCache<String, IServiceReferenceHolder<ICalloutFactory>> s_calloutFactoryCache = new CCache("_ICalloutFactory_Cache", "ICalloutFactory", 100, false);
    private static final CCache<String, List<IServiceReferenceHolder<IColumnCalloutFactory>>> s_columnCalloutFactoryCache = new CCache("_List_IColumnCalloutFactory_Cache", "List<IColumnCalloutFactory>", 100, false);
    private static final CCache<String, List<ServiceReference<IColumnCalloutFactory>>> s_columnCalloutFactoryNegativeCache = new CCache("_List_IColumnCalloutFactory_Cache", "List<IColumnCalloutFactory> Negative", 100, false);
    private static IServiceReferenceHolder<IMappedColumnCalloutFactory> s_mappedColumnCalloutFactoryReference = null;

    private ColumnCalloutManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static List<IColumnCallout> findCallout(String tableName, String columnName) {
        block13: {
            block11: {
                list = new ArrayList<IColumnCallout>();
                cacheKey = tableName + "." + columnName;
                cache = ColumnCalloutManager.s_columnCalloutFactoryCache.get(cacheKey);
                negativeCache = ColumnCalloutManager.s_columnCalloutFactoryNegativeCache.get(cacheKey);
                negativeServiceReferences = new ArrayList<ServiceReference<IColumnCalloutFactory>>();
                if (negativeCache != null) {
                    negativeServiceReferences.addAll(negativeCache);
                }
                cacheReferences = new ArrayList<ServiceReference<IColumnCalloutFactory>>();
                positiveReferenceHolders = new ArrayList<IServiceReferenceHolder<IColumnCalloutFactory>>();
                if (cache == null) break block11;
                for (IServiceReferenceHolder<IColumnCalloutFactory> referenceHolder : cache) {
                    block12: {
                        cacheReferences.add(referenceHolder.getServiceReference());
                        service = referenceHolder.getService();
                        if (service == null) continue;
                        callouts = service.getColumnCallouts(tableName, columnName);
                        if (callouts == null || callouts.length <= 0) break block12;
                        var16_21 = callouts;
                        var15_19 = callouts.length;
                        var14_16 = 0;
                        if (true) ** GOTO lbl32
                    }
                    negativeServiceReferences.add(referenceHolder.getServiceReference());
                    continue;
                    do {
                        callout = var16_21[var14_16];
                        list.add(callout);
                        ++var14_16;
lbl32:
                        // 2 sources

                    } while (var14_16 < var15_19);
                    positiveReferenceHolders.add(referenceHolder);
                }
            }
            ColumnCalloutManager.getMappedColumnCalloutFactory();
            positiveAdded = 0;
            negativeAdded = 0;
            referenceHolders = Service.locator().list(IColumnCalloutFactory.class).getServiceReferences();
            if (referenceHolders == null) break block13;
            for (IServiceReferenceHolder<IColumnCalloutFactory> referenceHolder : referenceHolders) {
                block14: {
                    serviceReference = referenceHolder.getServiceReference();
                    if (cacheReferences.contains(serviceReference) || negativeServiceReferences.contains(serviceReference) || (service = referenceHolder.getService()) == null) continue;
                    callouts = service.getColumnCallouts(tableName, columnName);
                    if (callouts == null || callouts.length <= 0) break block14;
                    var20_25 = callouts;
                    var19_24 = callouts.length;
                    var18_23 = 0;
                    if (true) ** GOTO lbl73
                }
                var17_22 = ColumnCalloutManager.class;
                // MONITORENTER : org.adempiere.base.ColumnCalloutManager.class
                if (ColumnCalloutManager.s_mappedColumnCalloutFactoryReference != null && serviceReference.equals(ColumnCalloutManager.s_mappedColumnCalloutFactoryReference.getServiceReference())) {
                    // MONITOREXIT : var17_22
                    continue;
                }
                // MONITOREXIT : var17_22
                negativeServiceReferences.add(serviceReference);
                ++negativeAdded;
                continue;
                do {
                    callout = var20_25[var18_23];
                    list.add(callout);
                    ++var18_23;
lbl73:
                    // 2 sources

                } while (var18_23 < var19_24);
                positiveReferenceHolders.add(referenceHolder);
                ++positiveAdded;
            }
        }
        if (cache == null || cache.size() != positiveReferenceHolders.size() || positiveAdded > 0) {
            ColumnCalloutManager.s_columnCalloutFactoryCache.put(cacheKey, positiveReferenceHolders);
        }
        if (negativeCache != null && negativeCache.size() == negativeServiceReferences.size()) {
            if (negativeAdded <= 0) return list;
        }
        ColumnCalloutManager.s_columnCalloutFactoryNegativeCache.put(cacheKey, negativeServiceReferences);
        return list;
    }

    public static Callout getCallout(String className, String methodName) {
        List<IServiceReferenceHolder<ICalloutFactory>> factories;
        String cacheKey = className + "::" + methodName;
        IServiceReferenceHolder<ICalloutFactory> cache = s_calloutFactoryCache.get(cacheKey);
        if (cache != null) {
            Callout callout;
            ICalloutFactory service = cache.getService();
            if (service != null && (callout = service.getCallout(className, methodName)) != null) {
                return callout;
            }
            s_calloutFactoryCache.remove(cacheKey);
        }
        if ((factories = Service.locator().list(ICalloutFactory.class).getServiceReferences()) != null) {
            for (IServiceReferenceHolder<ICalloutFactory> factory : factories) {
                Callout callout;
                ICalloutFactory service = factory.getService();
                if (service == null || (callout = service.getCallout(className, methodName)) == null) continue;
                s_calloutFactoryCache.put(cacheKey, factory);
                return callout;
            }
        }
        return null;
    }

    public static synchronized IMappedColumnCalloutFactory getMappedColumnCalloutFactory() {
        IServiceReferenceHolder<IMappedColumnCalloutFactory> serviceReference;
        IMappedColumnCalloutFactory factoryService = null;
        if (s_mappedColumnCalloutFactoryReference != null) {
            factoryService = s_mappedColumnCalloutFactoryReference.getService();
            if (factoryService != null) {
                return factoryService;
            }
            s_mappedColumnCalloutFactoryReference = null;
        }
        if ((serviceReference = Service.locator().locate(IMappedColumnCalloutFactory.class).getServiceReference()) != null) {
            factoryService = serviceReference.getService();
            s_mappedColumnCalloutFactoryReference = serviceReference;
        }
        return factoryService;
    }
}

