/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAccount;
import org.compiere.model.MElement;
import org.compiere.model.MTree;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.model.X_C_ElementValue;
import org.compiere.model.X_I_ElementValue;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutablePOSupport;

public class MElementValue
extends X_C_ElementValue
implements ImmutablePOSupport {
    private static final long serialVersionUID = 6352667759697380460L;

    public MElementValue(Properties ctx, String C_ElementValue_UU, String trxName) {
        super(ctx, C_ElementValue_UU, trxName);
        if (Util.isEmpty(C_ElementValue_UU)) {
            this.setInitialDefaults();
        }
    }

    public MElementValue(Properties ctx, int C_ElementValue_ID, String trxName) {
        super(ctx, C_ElementValue_ID, trxName);
        if (C_ElementValue_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setIsSummary(false);
        this.setAccountSign("N");
        this.setAccountType("E");
        this.setIsDocControlled(false);
        this.setIsForeignCurrency(false);
        this.setIsBankAccount(false);
        this.setPostActual(true);
        this.setPostBudget(true);
        this.setPostEncumbrance(true);
        this.setPostStatistical(true);
    }

    public MElementValue(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MElementValue(Properties ctx, String Value, String Name, String Description, String AccountType, String AccountSign, boolean IsDocControlled, boolean IsSummary, String trxName) {
        this(ctx, 0, trxName);
        this.setValue(Value);
        this.setName(Name);
        this.setDescription(Description);
        this.setAccountType(AccountType);
        this.setAccountSign(AccountSign);
        this.setIsDocControlled(IsDocControlled);
        this.setIsSummary(IsSummary);
    }

    public MElementValue(X_I_ElementValue imp) {
        this(imp.getCtx(), 0, imp.get_TrxName());
        this.setClientOrg(imp);
        this.set(imp);
    }

    public MElementValue(MElementValue copy) {
        this(Env.getCtx(), copy);
    }

    public MElementValue(Properties ctx, MElementValue copy) {
        this(ctx, copy, null);
    }

    public MElementValue(Properties ctx, MElementValue copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public void set(X_I_ElementValue imp) {
        this.setValue(imp.getValue());
        this.setName(imp.getName());
        this.setDescription(imp.getDescription());
        this.setAccountType(imp.getAccountType());
        this.setAccountSign(imp.getAccountSign());
        this.setIsSummary(imp.isSummary());
        this.setIsDocControlled(imp.isDocControlled());
        this.setC_Element_ID(imp.getC_Element_ID());
        this.setPostActual(imp.isPostActual());
        this.setPostBudget(imp.isPostBudget());
        this.setPostEncumbrance(imp.isPostEncumbrance());
        this.setPostStatistical(imp.isPostStatistical());
    }

    public boolean isBalanceSheet() {
        String accountType = this.getAccountType();
        return "A".equals(accountType) || "L".equals(accountType) || "O".equals(accountType);
    }

    public boolean isActiva() {
        return "A".equals(this.getAccountType());
    }

    public boolean isPassiva() {
        String accountType = this.getAccountType();
        return "L".equals(accountType) || "O".equals(accountType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getValue()).append(" - ").append(this.getName());
        return sb.toString();
    }

    public String toStringX() {
        StringBuilder sb = new StringBuilder("MElementValue[");
        sb.append(this.get_ID()).append(",").append(this.getValue()).append(" - ").append(this.getName()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        if (!newRecord && this.isSummary() && this.is_ValueChanged("IsSummary")) {
            boolean match = new Query(this.getCtx(), "Fact_Acct", "Account_ID=?", this.get_TrxName()).setParameters(this.getC_ElementValue_ID()).match();
            if (match) {
                throw new AdempiereException("@AlreadyPostedTo@");
            }
            String whereClause = "Account_ID=?";
            POResultSet rs = null;
            try {
                rs = new Query(this.getCtx(), "C_ValidCombination", whereClause, this.get_TrxName()).setParameters(this.get_ID()).scroll();
                while (rs.hasNext()) {
                    ((MAccount)rs.next()).deleteEx(true);
                }
            }
            finally {
                DB.close(rs);
                rs = null;
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord || this.is_ValueChanged("Value")) {
            int ad_Tree_ID = new MElement(this.getCtx(), this.getC_Element_ID(), this.get_TrxName()).getAD_Tree_ID();
            String treeType = new MTree(this.getCtx(), ad_Tree_ID, this.get_TrxName()).getTreeType();
            if (newRecord) {
                this.insert_Tree(treeType, this.getC_Element_ID());
            }
            this.update_Tree(treeType);
        }
        if (!newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription(this.getCtx(), "Account_ID=" + this.getC_ElementValue_ID(), this.get_TrxName());
            if ("Y".equals(Env.getContext(this.getCtx(), "$Element_U1"))) {
                MAccount.updateValueDescription(this.getCtx(), "User1_ID=" + this.getC_ElementValue_ID(), this.get_TrxName());
            }
            if ("Y".equals(Env.getContext(this.getCtx(), "$Element_U2"))) {
                MAccount.updateValueDescription(this.getCtx(), "User2_ID=" + this.getC_ElementValue_ID(), this.get_TrxName());
            }
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.delete_Tree("EV");
        }
        return success;
    }

    @Override
    public MElementValue markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

