/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.PO;
import org.compiere.model.X_AD_BroadcastMessage;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MBroadcastMessage
extends X_AD_BroadcastMessage
implements ImmutablePOSupport {
    private static final long serialVersionUID = 3733943472482553977L;
    public static final String CLIENTINFO_BROADCAST_COMPONENT_ID = "#clientInfo_BroadcastComponentId";
    private static ImmutableIntPOCache<Integer, MBroadcastMessage> s_cache = new ImmutableIntPOCache("AD_BroadcastMessage", 30, 60);

    public MBroadcastMessage(Properties ctx, String AD_BroadcastMessage_UU, String trxName) {
        super(ctx, AD_BroadcastMessage_UU, trxName);
    }

    public MBroadcastMessage(Properties ctx, int AD_BroadcastMessage_ID, String trxName) {
        super(ctx, AD_BroadcastMessage_ID, trxName);
    }

    public MBroadcastMessage(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBroadcastMessage(MBroadcastMessage copy) {
        this(Env.getCtx(), copy);
    }

    public MBroadcastMessage(Properties ctx, MBroadcastMessage copy) {
        this(ctx, copy, null);
    }

    public MBroadcastMessage(Properties ctx, MBroadcastMessage copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public static MBroadcastMessage get(int AD_BroadcastMessage_ID) {
        return MBroadcastMessage.get(Env.getCtx(), AD_BroadcastMessage_ID);
    }

    public static MBroadcastMessage get(Properties ctx, int AD_BroadcastMessage_ID) {
        Integer key = AD_BroadcastMessage_ID;
        MBroadcastMessage retValue = s_cache.get(ctx, key, e -> new MBroadcastMessage(ctx, (MBroadcastMessage)e));
        if (retValue == null) {
            try {
                PO.setCrossTenantSafe();
                retValue = new MBroadcastMessage(ctx, AD_BroadcastMessage_ID, null);
            }
            finally {
                PO.clearCrossTenantSafe();
            }
            if (retValue.get_ID() != AD_BroadcastMessage_ID) {
                return null;
            }
            s_cache.put(key, retValue, e -> new MBroadcastMessage(Env.getCtx(), (MBroadcastMessage)e));
        }
        if (retValue != null && retValue.getAD_Client_ID() != 0 && retValue.getAD_Client_ID() != Env.getAD_Client_ID(ctx)) {
            return null;
        }
        return retValue;
    }

    public boolean isValidUserforMessage() {
        Properties ctx = Env.getCtx();
        if (this.getBroadcastType() != null && this.getBroadcastType().equals("I") && this.getTarget() != null) {
            if (this.getTarget().equals("R")) {
                String sql = "SELECT COUNT(*) FROM AD_User_Roles WHERE AD_Role_ID = ? AND AD_User_ID=? AND IsActive='Y'";
                int roleSubs = DB.getSQLValue(null, sql, this.getAD_Role_ID(), Env.getAD_User_ID(ctx));
                if (roleSubs > 0) {
                    return true;
                }
            } else {
                if (this.getTarget().equals("U") && this.getAD_User_ID() == Env.getAD_User_ID(ctx)) {
                    return true;
                }
                if (this.getTarget().equals("C") && this.getAD_Client_ID() == Env.getAD_Client_ID(ctx)) {
                    return true;
                }
                if (this.getTarget().equals("E")) {
                    return true;
                }
            }
        } else {
            int AD_User_ID = Env.getAD_User_ID(ctx);
            String sql = "SELECT AD_User_ID from AD_Note WHERE AD_BroadcastMessage_ID = ?  AND AD_User_ID = ? ";
            int result = DB.getSQLValue(null, sql, this.getAD_BroadcastMessage_ID(), AD_User_ID);
            return result > 0;
        }
        return false;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if ("I".equals(this.getBroadcastType())) {
            this.setBroadcastFrequency("J");
        }
        boolean logack = "A".equals(this.getBroadcastFrequency()) || "O".equals(this.getBroadcastFrequency());
        this.setLogAcknowledge(logack);
        return true;
    }

    @Override
    public MBroadcastMessage markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }

    @Override
    public String get_Translation(String columnName) {
        String translation = super.get_Translation(columnName);
        if (!Util.isEmpty(translation) && translation.indexOf(64) > 0) {
            return Env.parseContext(this.getCtx(), 0, translation, false, false);
        }
        return translation;
    }

    public String getUrlZoom(PO po, String windowUUID, String text) {
        StringBuilder url = new StringBuilder("");
        url.append("<a href=\"javascript:void(0)\" class=\"rp-href\" onclick=\"window.idempiere.zoomWindow(@#clientInfo_BroadcastComponentId@, '");
        url.append(po.get_KeyColumns()[0]);
        url.append("', '").append(po.get_ID()).append("','").append(windowUUID).append("')\">");
        url.append(text);
        url.append("</a>");
        return url.toString();
    }
}

