/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.exceptions;

import java.sql.SQLException;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MMessage;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class DBException
extends AdempiereException {
    private static final long serialVersionUID = -1961265420169932726L;
    public static final String DATABASE_OPERATION_TIMEOUT_MSG = "DatabaseOperationTimeout";
    public static final String DELETE_ERROR_DEPENDENT_MSG = "DeleteErrorDependent";
    public static final String DELETE_ERROR_DEPENDENT_MSG_WITH_INFO = "DeleteErrorDependentInfo";
    public static final String SAVE_ERROR_NOT_UNIQUE_MSG = "SaveErrorNotUnique";
    private String m_sql = null;

    public DBException(Exception e) {
        super(e);
        if (CLogMgt.isLevelFinest()) {
            e.printStackTrace();
        }
    }

    public DBException(SQLException e, String sql) {
        this(e);
        this.m_sql = sql;
    }

    public DBException(String msg) {
        super(msg);
    }

    public DBException(String msg, Exception e) {
        super(msg, e);
    }

    public String getSQL() {
        return this.m_sql;
    }

    public SQLException getSQLException() {
        Throwable cause = this.getCause();
        if (cause instanceof SQLException) {
            return (SQLException)cause;
        }
        return null;
    }

    public int getErrorCode() {
        SQLException e = this.getSQLException();
        return e != null ? e.getErrorCode() : -1;
    }

    public SQLException getNextException() {
        SQLException e = this.getSQLException();
        return e != null ? e.getNextException() : null;
    }

    public String getSQLState() {
        SQLException e = this.getSQLException();
        return e != null ? e.getSQLState() : null;
    }

    private static final boolean isErrorCode(Exception e, int errorCode) {
        if (e == null) {
            return false;
        }
        if (e instanceof SQLException) {
            return ((SQLException)e).getErrorCode() == errorCode || e.getMessage().contains("ORA-" + String.format("%05d", errorCode) + ":");
        }
        if (e instanceof DBException) {
            SQLException sqlEx = ((DBException)e).getSQLException();
            if (sqlEx != null) {
                return sqlEx.getErrorCode() == errorCode;
            }
            return false;
        }
        return false;
    }

    private static final boolean isSQLState(Exception e, String SQLState) {
        if (e == null) {
            return false;
        }
        if (e instanceof SQLException) {
            return ((SQLException)e).getSQLState().equals(SQLState);
        }
        if (e instanceof DBException) {
            SQLException sqlEx = ((DBException)e).getSQLException();
            if (sqlEx != null) {
                return sqlEx.getSQLState().equals(SQLState);
            }
            return false;
        }
        return false;
    }

    public static boolean isUniqueContraintError(Exception e) {
        if (DB.isPostgreSQL()) {
            return DBException.isSQLState(e, "23505");
        }
        return DBException.isErrorCode(e, 1);
    }

    public static boolean isChildRecordFoundError(Exception e) {
        if (DB.isPostgreSQL()) {
            return DBException.isSQLState(e, "23503");
        }
        return DBException.isErrorCode(e, 2292);
    }

    public static boolean isInvalidIdentifierError(Exception e) {
        if (DB.isPostgreSQL()) {
            return DBException.isSQLState(e, "42P01");
        }
        return DBException.isErrorCode(e, 904);
    }

    public static boolean isInvalidUserPassError(Exception e) {
        return DBException.isErrorCode(e, 1017);
    }

    public static boolean isTimeout(Exception e) {
        SQLException se = null;
        if (e instanceof SQLException) {
            se = (SQLException)e;
        } else if (e.getCause() != null && e.getCause() instanceof SQLException) {
            se = (SQLException)e.getCause();
        }
        if (se != null) {
            return DB.getDatabase().isQueryTimeout(se);
        }
        return false;
    }

    public static boolean isValueTooLarge(Exception e) {
        if (DB.isPostgreSQL()) {
            return DBException.isSQLState(e, "22001");
        }
        return DBException.isErrorCode(e, 12899);
    }

    public static String getDefaultDBExceptionMessage(Exception e) {
        if (DBException.isUniqueContraintError(e)) {
            return SAVE_ERROR_NOT_UNIQUE_MSG;
        }
        if (DBException.isChildRecordFoundError(e)) {
            MColumn fColumn;
            String constraint = DB.getDatabase().getForeignKeyConstraint(e);
            if (!Util.isEmpty(constraint) && (fColumn = (MColumn)new Query(Env.getCtx(), "AD_Column", " UPPER(FKConstraintName) = UPPER(?) ", null).setParameters(constraint).first()) != null) {
                int msgID = fColumn.getFKConstraintMsg_ID();
                if (msgID > 0) {
                    MMessage msgObj = MMessage.get(Env.getCtx(), msgID);
                    return msgObj.getValue();
                }
                MTable fTable = MTable.get(fColumn.getAD_Table_ID());
                String msg = Msg.getMsg(Env.getCtx(), DELETE_ERROR_DEPENDENT_MSG_WITH_INFO, new Object[]{fTable.get_Translation("Name"), fColumn.get_Translation("Name")});
                return msg;
            }
            return DELETE_ERROR_DEPENDENT_MSG;
        }
        if (DBException.isTimeout(e)) {
            return DATABASE_OPERATION_TIMEOUT_MSG;
        }
        return null;
    }
}

