/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.process.ImportProcess;
import org.adempiere.process.UUIDGenerator;
import org.compiere.model.MColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_I_Product;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

@Process
public class ImportProduct
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean m_deleteOldImported = false;
    private Timestamp m_DateValue = null;
    private int p_M_PriceList_Version_ID = 0;
    private String[] strFieldsToCopy = new String[]{"Value", "Name", "Description", "DocumentNote", "Help", "UPC", "SKU", "Classification", "ProductType", "Discontinued", "DiscontinuedBy", "DiscontinuedAt", "ImageURL", "DescriptionURL", "CustomsTariffNumber", "Group1", "Group2"};

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("M_PriceList_Version_ID")) {
                this.p_M_PriceList_Version_ID = para[i].getParameterAsInt();
            } else {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
            }
            ++i;
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String doIt() throws Exception {
        int noUpdatePO;
        int noInsertPO;
        int noUpdate;
        int noInsert;
        String clientCheck;
        int no;
        StringBuilder sql;
        block75: {
            sql = null;
            no = 0;
            clientCheck = this.getWhereClause();
            if (this.m_deleteOldImported) {
                sql = new StringBuilder("DELETE FROM I_Product ").append("WHERE I_IsImported='Y'").append(clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Delete Old Imported =" + no);
                }
            }
            sql = new StringBuilder("UPDATE I_Product ").append("SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("),").append(" AD_Org_ID = COALESCE (AD_Org_ID, 0),").append(" IsActive = COALESCE (IsActive, 'Y'),").append(" Created = COALESCE (Created, getDate()),").append(" CreatedBy = COALESCE (CreatedBy, 0),").append(" Updated = COALESCE (Updated, getDate()),").append(" UpdatedBy = COALESCE (UpdatedBy, 0),").append(" ProductType = COALESCE (ProductType, 'I'),").append(" I_ErrorMsg = ' ',").append(" I_IsImported = 'N' ").append("WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Reset=" + no);
            }
            ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
            sql = new StringBuilder("UPDATE I_Product i ").append("SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p").append(" WHERE i.BPartner_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_BPartner_ID IS NULL").append(" AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("BPartner=" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Product ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid BPartner,' ").append("WHERE C_BPartner_ID IS NULL AND BPartner_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Invalid BPartner=" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Product i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=more than one product with this UPC,' ").append("WHERE I_IsImported<>'Y'").append(" AND EXISTS (SELECT 1 FROM M_Product mp").append(" JOIN M_Product mp2 on mp.AD_Client_ID=mp2.AD_Client_ID AND mp.upc = mp2.upc AND mp.M_Product_ID <> mp2.M_Product_ID").append(" WHERE i.AD_Client_ID=mp.AD_Client_ID AND i.upc = mp.upc)").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Not Unique UPC=" + no);
            }
            sql = new StringBuilder("UPDATE I_Product i ").append("SET M_Product_ID=(SELECT M_Product_ID FROM M_Product p").append(" WHERE i.UPC=p.UPC AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL").append(" AND I_IsImported='N'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Product Existing UPC=" + no);
            }
            sql = new StringBuilder("UPDATE I_Product i ").append("SET M_Product_ID=(SELECT M_Product_ID FROM M_Product p").append(" WHERE i.Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL").append(" AND I_IsImported='N'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Product Existing Value=" + no);
            }
            sql = new StringBuilder("UPDATE I_Product i ").append("SET M_Product_ID=(SELECT M_Product_ID FROM M_Product_po p").append(" WHERE i.C_BPartner_ID=p.C_BPartner_ID").append(" AND i.VendorProductNo=p.VendorProductNo AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL").append(" AND I_IsImported='N'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Product Existing Vendor ProductNo=" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Product i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Product is not active,' ").append("WHERE I_IsImported<>'Y' AND M_Product_ID IS NOT NULL").append(" AND EXISTS (SELECT 1 FROM M_Product mp").append(" WHERE i.AD_Client_ID=mp.AD_Client_ID AND i.M_Product_ID= mp.M_Product_ID AND mp.IsActive='N')").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Product inactive");
            }
            sql = new StringBuilder("UPDATE I_Product ").append("SET ProductCategory_Value=(SELECT MAX(Value) FROM M_Product_Category").append(" WHERE IsDefault='Y' AND AD_Client_ID=").append(this.m_AD_Client_ID).append(") ").append("WHERE ProductCategory_Value IS NULL AND M_Product_Category_ID IS NULL").append(" AND M_Product_ID IS NULL").append(" AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set Category Default Value=" + no);
            }
            sql = new StringBuilder("UPDATE I_Product i ").append("SET M_Product_Category_ID=(SELECT M_Product_Category_ID FROM M_Product_Category c").append(" WHERE i.ProductCategory_Value=c.Value AND i.AD_Client_ID=c.AD_Client_ID) ").append("WHERE ProductCategory_Value IS NOT NULL AND M_Product_Category_ID IS NULL").append(" AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Set Category=" + no);
            }
            int i = 0;
            while (i < this.strFieldsToCopy.length) {
                sql = new StringBuilder("UPDATE I_Product i ").append("SET ").append(this.strFieldsToCopy[i]).append(" = (SELECT ").append(this.strFieldsToCopy[i]).append(" FROM M_Product p").append(" WHERE i.M_Product_ID=p.M_Product_ID AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NOT NULL").append(" AND ").append(this.strFieldsToCopy[i]).append(" IS NULL").append(" AND I_IsImported='N'").append(clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (no != 0 && this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.strFieldsToCopy[i] + " - default from existing Product=" + no);
                }
                ++i;
            }
            String[] numFields = new String[]{"C_UOM_ID", "M_Product_Category_ID", "Volume", "Weight", "ShelfWidth", "ShelfHeight", "ShelfDepth", "UnitsPerPallet"};
            int i2 = 0;
            while (i2 < numFields.length) {
                sql = new StringBuilder("UPDATE I_PRODUCT i ").append("SET ").append(numFields[i2]).append(" = (SELECT ").append(numFields[i2]).append(" FROM M_Product p").append(" WHERE i.M_Product_ID=p.M_Product_ID AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NOT NULL").append(" AND (").append(numFields[i2]).append(" IS NULL OR ").append(numFields[i2]).append("=0)").append(" AND I_IsImported='N'").append(clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (no != 0 && this.log.isLoggable(Level.FINE)) {
                    this.log.fine(numFields[i2] + " default from existing Product=" + no);
                }
                ++i2;
            }
            String[] strFieldsPO = new String[]{"UPC", "PriceEffective", "VendorProductNo", "VendorCategory", "Manufacturer", "Discontinued", "DiscontinuedBy", "DiscontinuedAt"};
            int i3 = 0;
            while (i3 < strFieldsPO.length) {
                sql = new StringBuilder("UPDATE I_PRODUCT i ").append("SET ").append(strFieldsPO[i3]).append(" = (SELECT ").append(strFieldsPO[i3]).append(" FROM M_Product_PO p").append(" WHERE i.M_Product_ID=p.M_Product_ID AND i.C_BPartner_ID=p.C_BPartner_ID AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NOT NULL AND C_BPartner_ID IS NOT NULL").append(" AND ").append(strFieldsPO[i3]).append(" IS NULL").append(" AND I_IsImported='N'").append(clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (no != 0 && this.log.isLoggable(Level.FINE)) {
                    this.log.fine(strFieldsPO[i3] + " default from existing Product PO=" + no);
                }
                ++i3;
            }
            String[] numFieldsPO = new String[]{"C_UOM_ID", "C_Currency_ID", "PriceList", "PricePO", "RoyaltyAmt", "Order_Min", "Order_Pack", "CostPerOrder", "DeliveryTime_Promised"};
            int i4 = 0;
            while (i4 < numFieldsPO.length) {
                sql = new StringBuilder("UPDATE I_PRODUCT i ").append("SET ").append(numFieldsPO[i4]).append(" = (SELECT ").append(numFieldsPO[i4]).append(" FROM M_Product_PO p").append(" WHERE i.M_Product_ID=p.M_Product_ID AND i.C_BPartner_ID=p.C_BPartner_ID AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NOT NULL AND C_BPartner_ID IS NOT NULL").append(" AND (").append(numFieldsPO[i4]).append(" IS NULL OR ").append(numFieldsPO[i4]).append("=0)").append(" AND I_IsImported='N'").append(clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (no != 0 && this.log.isLoggable(Level.FINE)) {
                    this.log.fine(numFieldsPO[i4] + " default from existing Product PO=" + no);
                }
                ++i4;
            }
            sql = new StringBuilder("UPDATE I_Product ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid ProdCategory,' ").append("WHERE M_Product_Category_ID IS NULL").append(" AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (no != 0) {
                this.log.warning("Invalid Category=" + no);
            }
            sql = new StringBuilder("UPDATE I_Product i ").append("SET X12DE355 = ").append("(SELECT MAX(X12DE355) FROM C_UOM u WHERE u.IsDefault='Y' AND u.AD_Client_ID IN (0,i.AD_Client_ID)) ").append("WHERE X12DE355 IS NULL AND C_UOM_ID IS NULL").append(" AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set UOM Default=" + no);
            }
            sql = new StringBuilder("UPDATE I_Product i ").append("SET C_UOM_ID = (SELECT C_UOM_ID FROM C_UOM u WHERE u.X12DE355=i.X12DE355 AND u.AD_Client_ID IN (0,i.AD_Client_ID)) ").append("WHERE C_UOM_ID IS NULL").append(" AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Set UOM=" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Product ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid UOM, ' ").append("WHERE C_UOM_ID IS NULL").append(" AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Invalid UOM=" + no);
            }
            sql = new StringBuilder("UPDATE I_Product i ").append("SET ISO_Code=(SELECT ISO_Code FROM C_Currency c").append(" INNER JOIN C_AcctSchema a ON (a.C_Currency_ID=c.C_Currency_ID)").append(" INNER JOIN AD_ClientInfo ci ON (a.C_AcctSchema_ID=ci.C_AcctSchema1_ID)").append(" WHERE ci.AD_Client_ID=i.AD_Client_ID) ").append("WHERE C_Currency_ID IS NULL AND ISO_Code IS NULL").append(" AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set Currency Default=" + no);
            }
            sql = new StringBuilder("UPDATE I_Product i ").append("SET C_Currency_ID=(SELECT C_Currency_ID FROM C_Currency c").append(" WHERE i.ISO_Code=c.ISO_Code AND c.AD_Client_ID IN (0,i.AD_Client_ID)) ").append("WHERE C_Currency_ID IS NULL").append(" AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("doIt- Set Currency=" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Product ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Currency,' ").append("WHERE C_Currency_ID IS NULL").append(" AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Invalid Currency=" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Product ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid ProductType,' ").append("WHERE ProductType NOT IN ('E','I','R','S','A')").append(" AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Invalid ProductType=" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Product i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Value not unique,' ").append("WHERE I_IsImported<>'Y'").append(" AND EXISTS (SELECT 1 FROM I_Product ii WHERE i.AD_Client_ID=ii.AD_Client_ID AND i.i_product_id <> ii.i_product_id AND i.value = ii.value)").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Not Unique Value=" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Product i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=UPC not unique,' ").append("WHERE I_IsImported<>'Y'").append(" AND EXISTS (SELECT 1 FROM I_Product ii WHERE i.AD_Client_ID=ii.AD_Client_ID AND i.i_product_id <> ii.i_product_id AND i.upc = ii.upc)").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Not Unique UPC=" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Product i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Mandatory Value,' ").append("WHERE Value IS NULL").append(" AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("No Mandatory Value=" + no);
            }
            sql = new StringBuilder("UPDATE I_Product ").append("SET VendorProductNo=Value ").append("WHERE C_BPartner_ID IS NOT NULL AND VendorProductNo IS NULL").append(" AND I_IsImported='N'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("VendorProductNo Set to Value=" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_Product i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=VendorProductNo not unique,' ").append("WHERE I_IsImported<>'Y'").append(" AND C_BPartner_ID IS NOT NULL").append(" AND EXISTS (SELECT 1 from I_Product ii WHERE i.AD_Client_ID = ii.AD_Client_ID AND i.c_bpartner_id = ii.c_bpartner_id AND i.vendorproductno = ii.vendorproductno AND i.i_product_id <> ii.i_product_id)").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                this.log.warning("Not Unique VendorProductNo=" + no);
            }
            int C_TaxCategory_ID = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    StringBuilder dbpst = new StringBuilder("SELECT C_TaxCategory_ID FROM C_TaxCategory WHERE IsDefault='Y'").append(clientCheck);
                    pstmt = DB.prepareStatement((String)dbpst.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        C_TaxCategory_ID = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    throw new Exception("TaxCategory", e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("C_TaxCategory_ID=" + C_TaxCategory_ID);
            }
            ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
            this.commitEx();
            noInsert = 0;
            noUpdate = 0;
            noInsertPO = 0;
            noUpdatePO = 0;
            this.log.fine("start inserting/updating ...");
            sql = new StringBuilder("SELECT * FROM I_Product WHERE I_IsImported='N'").append(clientCheck);
            CPreparedStatement pstmt_setImported = null;
            CPreparedStatement pstmt_insertProductPO = null;
            try {
                try {
                    pstmt_insertProductPO = DB.prepareStatement((String)"INSERT INTO M_Product_PO (M_Product_ID,C_BPartner_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsCurrentVendor,C_UOM_ID,C_Currency_ID,UPC,PriceList,PricePO,RoyaltyAmt,PriceEffective,VendorProductNo,VendorCategory,Manufacturer,Discontinued,DiscontinuedBy, DiscontinuedAt, Order_Min,Order_Pack,CostPerOrder,DeliveryTime_Promised) SELECT ?,?, AD_Client_ID,AD_Org_ID,'Y',getDate(),CreatedBy,getDate(),UpdatedBy,'Y',C_UOM_ID,C_Currency_ID,UPC,PriceList,PricePO,RoyaltyAmt,PriceEffective,VendorProductNo,VendorCategory,Manufacturer,Discontinued,DiscontinuedBy, DiscontinuedAt, Order_Min,Order_Pack,CostPerOrder,DeliveryTime_Promised FROM I_Product WHERE I_Product_ID=?", (String)this.get_TrxName());
                    pstmt_setImported = DB.prepareStatement((String)"UPDATE I_Product SET I_IsImported='Y', M_Product_ID=?, Updated=getDate(), Processed='Y' WHERE I_Product_ID=?", (String)this.get_TrxName());
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        StringBuilder sql0;
                        StringBuilder sqlt;
                        StringBuilder sql02;
                        boolean newProduct;
                        int C_BPartner_ID;
                        int M_Product_ID;
                        int I_Product_ID;
                        X_I_Product imp;
                        block70: {
                            imp = new X_I_Product(this.getCtx(), rs, this.get_TrxName());
                            I_Product_ID = imp.getI_Product_ID();
                            M_Product_ID = imp.getM_Product_ID();
                            C_BPartner_ID = imp.getC_BPartner_ID();
                            boolean bl = newProduct = M_Product_ID == 0;
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("I_Product_ID=" + I_Product_ID + ", M_Product_ID=" + M_Product_ID + ", C_BPartner_ID=" + C_BPartner_ID);
                            }
                            if (newProduct) {
                                MProduct product = new MProduct(imp);
                                product.setC_TaxCategory_ID(C_TaxCategory_ID);
                                ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)imp, (PO)product, 40);
                                if (product.save()) {
                                    M_Product_ID = product.getM_Product_ID();
                                    this.log.finer("Insert Product");
                                    ++noInsert;
                                    break block70;
                                } else {
                                    sql02 = new StringBuilder("UPDATE I_Product i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING((String)"Insert Product failed")).append("WHERE I_Product_ID=").append(I_Product_ID);
                                    DB.executeUpdate((String)sql02.toString(), (String)this.get_TrxName());
                                    continue;
                                }
                            }
                            sqlt = new StringBuilder("UPDATE M_PRODUCT ").append("SET (Value,Name,Description,DocumentNote,Help,").append("UPC,SKU,C_UOM_ID,M_Product_Category_ID,Classification,ProductType,").append("Volume,Weight,ShelfWidth,ShelfHeight,ShelfDepth,UnitsPerPallet,").append("CustomsTariffNumber,Group1,Group2,").append("Discontinued,DiscontinuedBy, DiscontinuedAt, Updated,UpdatedBy)= ").append("(SELECT Value,Name,Description,DocumentNote,Help,").append("UPC,SKU,C_UOM_ID,M_Product_Category_ID,Classification,ProductType,").append("Volume,Weight,ShelfWidth,ShelfHeight,ShelfDepth,UnitsPerPallet,").append("CustomsTariffNumber,Group1,Group2,").append("Discontinued,DiscontinuedBy, DiscontinuedAt, getDate(),UpdatedBy").append(" FROM I_Product WHERE I_Product_ID=").append(I_Product_ID).append(") ").append("WHERE M_Product_ID=").append(M_Product_ID);
                            CPreparedStatement pstmt_updateProduct = DB.prepareStatement((String)sqlt.toString(), (String)this.get_TrxName());
                            try {
                                try {
                                    no = pstmt_updateProduct.executeUpdate();
                                    if (this.log.isLoggable(Level.FINER)) {
                                        this.log.finer("Update Product = " + no);
                                    }
                                    ++noUpdate;
                                }
                                catch (SQLException ex) {
                                    this.rollback();
                                    this.log.warning("Update Product - " + ex.toString());
                                    sql0 = new StringBuilder("UPDATE I_Product i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING((String)("Update Product: " + ex.toString()))).append("WHERE I_Product_ID=").append(I_Product_ID);
                                    DB.executeUpdate((String)sql0.toString(), (String)this.get_TrxName());
                                    this.commitEx();
                                    DB.close((Statement)pstmt_updateProduct);
                                    pstmt_updateProduct = null;
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                DB.close((Statement)pstmt_updateProduct);
                                pstmt_updateProduct = null;
                                throw throwable;
                            }
                            DB.close((Statement)pstmt_updateProduct);
                            pstmt_updateProduct = null;
                        }
                        if (C_BPartner_ID != 0) {
                            no = 0;
                            if (!newProduct) {
                                sqlt = new StringBuilder("UPDATE M_Product_PO ").append("SET (IsCurrentVendor,C_UOM_ID,C_Currency_ID,UPC,").append("PriceList,PricePO,RoyaltyAmt,PriceEffective,").append("VendorProductNo,VendorCategory,Manufacturer,").append("Discontinued,DiscontinuedBy, DiscontinuedAt, Order_Min,Order_Pack,").append("CostPerOrder,DeliveryTime_Promised,Updated,UpdatedBy)= ").append("(SELECT CAST('Y' AS CHAR),C_UOM_ID,C_Currency_ID,UPC,").append("PriceList,PricePO,RoyaltyAmt,PriceEffective,").append("VendorProductNo,VendorCategory,Manufacturer,").append("Discontinued,DiscontinuedBy, DiscontinuedAt, Order_Min,Order_Pack,").append("CostPerOrder,DeliveryTime_Promised,getDate(),UpdatedBy").append(" FROM I_Product").append(" WHERE I_Product_ID=").append(I_Product_ID).append(") ").append("WHERE M_Product_ID=").append(M_Product_ID).append(" AND C_BPartner_ID=").append(C_BPartner_ID);
                                CPreparedStatement pstmt_updateProductPO = DB.prepareStatement((String)sqlt.toString(), (String)this.get_TrxName());
                                try {
                                    try {
                                        no = pstmt_updateProductPO.executeUpdate();
                                        if (this.log.isLoggable(Level.FINER)) {
                                            this.log.finer("Update Product_PO = " + no);
                                        }
                                        ++noUpdatePO;
                                    }
                                    catch (SQLException ex) {
                                        this.log.warning("Update Product_PO - " + ex.toString());
                                        --noUpdate;
                                        this.rollback();
                                        sql0 = new StringBuilder("UPDATE I_Product i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING((String)("Update Product_PO: " + ex.toString()))).append("WHERE I_Product_ID=").append(I_Product_ID);
                                        DB.executeUpdate((String)sql0.toString(), (String)this.get_TrxName());
                                        this.commitEx();
                                        DB.close((Statement)pstmt_updateProductPO);
                                        pstmt_updateProductPO = null;
                                        continue;
                                    }
                                }
                                catch (Throwable throwable) {
                                    DB.close((Statement)pstmt_updateProductPO);
                                    pstmt_updateProductPO = null;
                                    throw throwable;
                                }
                                DB.close((Statement)pstmt_updateProductPO);
                                pstmt_updateProductPO = null;
                            }
                            if (no == 0) {
                                pstmt_insertProductPO.setInt(1, M_Product_ID);
                                pstmt_insertProductPO.setInt(2, C_BPartner_ID);
                                pstmt_insertProductPO.setInt(3, I_Product_ID);
                                try {
                                    no = pstmt_insertProductPO.executeUpdate();
                                    if (this.log.isLoggable(Level.FINER)) {
                                        this.log.finer("Insert Product_PO = " + no);
                                    }
                                    ++noInsertPO;
                                    if (DB.isGenerateUUIDSupported()) {
                                        DB.executeUpdateEx((String)"UPDATE M_Product_PO SET M_Product_PO_UU=generate_uuid() WHERE M_Product_PO_UU IS NULL", (String)this.get_TrxName());
                                    } else {
                                        UUIDGenerator.updateUUID((MColumn)MColumn.get((Properties)this.getCtx(), (String)"M_Product_PO", (String)PO.getUUIDColumnName((String)"M_Product_PO")), (String)this.get_TrxName());
                                    }
                                }
                                catch (SQLException ex) {
                                    this.log.warning("Insert Product_PO - " + ex.toString());
                                    --noInsert;
                                    this.rollback();
                                    sql02 = new StringBuilder("UPDATE I_Product i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING((String)("Insert Product_PO: " + ex.toString()))).append("WHERE I_Product_ID=").append(I_Product_ID);
                                    DB.executeUpdate((String)sql02.toString(), (String)this.get_TrxName());
                                    this.commitEx();
                                    continue;
                                }
                            }
                        }
                        if (this.p_M_PriceList_Version_ID != 0) {
                            BigDecimal PriceList = imp.getPriceList();
                            BigDecimal PriceStd = imp.getPriceStd();
                            BigDecimal PriceLimit = imp.getPriceLimit();
                            if (PriceStd.signum() != 0 || PriceLimit.signum() != 0 || PriceList.signum() != 0) {
                                MProductPrice pp = MProductPrice.get((Properties)this.getCtx(), (int)this.p_M_PriceList_Version_ID, (int)M_Product_ID, (String)this.get_TrxName());
                                if (pp == null) {
                                    pp = new MProductPrice(this.getCtx(), this.p_M_PriceList_Version_ID, M_Product_ID, this.get_TrxName());
                                }
                                pp.setPrices(PriceList, PriceStd, PriceLimit);
                                ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)imp, (PO)pp, 40);
                                pp.saveEx();
                            }
                        }
                        pstmt_setImported.setInt(1, M_Product_ID);
                        pstmt_setImported.setInt(2, I_Product_ID);
                        no = pstmt_setImported.executeUpdate();
                        this.commitEx();
                    }
                }
                catch (SQLException sQLException) {
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    DB.close((Statement)pstmt_insertProductPO);
                    pstmt_insertProductPO = null;
                    DB.close((Statement)pstmt_setImported);
                    pstmt_setImported = null;
                    break block75;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                DB.close((Statement)pstmt_insertProductPO);
                pstmt_insertProductPO = null;
                DB.close((Statement)pstmt_setImported);
                pstmt_setImported = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            DB.close((Statement)pstmt_insertProductPO);
            pstmt_insertProductPO = null;
            DB.close((Statement)pstmt_setImported);
            pstmt_setImported = null;
        }
        sql = new StringBuilder("UPDATE I_Product ").append("SET I_IsImported='N', Updated=getDate() ").append("WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@M_Product_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdate), "@M_Product_ID@: @Updated@");
        this.addLog(0, null, new BigDecimal(noInsertPO), "@M_Product_ID@ @Purchase@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdatePO), "@M_Product_ID@ @Purchase@: @Updated@");
        return "";
    }

    public String getImportTableName() {
        return "I_Product";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
        return msgreturn.toString();
    }
}

