/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.callout;

import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.base.IColumnCallout;
import org.adempiere.base.annotation.Callout;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MInventory;
import org.compiere.model.MProduct;
import org.compiere.util.Env;
import org.compiere.util.Msg;

@Callout(tableName={"M_InventoryLine"}, columnName={"M_Product_ID"})
public class CostAdjustmentLineProduct
implements IColumnCallout {
    public String start(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        GridTable gt;
        String trxName = null;
        if (mTab != null && mTab.getTableModel() != null && (gt = mTab.getTableModel()).isImporting()) {
            trxName = gt.get_TrxName();
        }
        if (mTab.getValue("M_Inventory_ID") == null) {
            return null;
        }
        MInventory inventory = new MInventory(ctx, ((Integer)mTab.getValue("M_Inventory_ID")).intValue(), trxName);
        if ("CA".equals(inventory.getC_DocType().getDocSubTypeInv())) {
            String costingMethod = inventory.getCostingMethod();
            if (value == null) {
                mTab.setValue("CurrentCostPrice", (Object)BigDecimal.ZERO);
                mTab.setValue("NewCostPrice", (Object)BigDecimal.ZERO);
            } else {
                MClient client;
                MAcctSchema as;
                MProduct product = MProduct.get((Properties)ctx, (int)((Integer)value));
                String costingLevel = product.getCostingLevel(as = (client = MClient.get((Properties)ctx)).getAcctSchema());
                if ("B".equals(costingLevel)) {
                    mTab.setValue("CurrentCostPrice", (Object)BigDecimal.ZERO);
                    mTab.setValue("NewCostPrice", (Object)BigDecimal.ZERO);
                } else {
                    MCost cost;
                    Object asiValue = mTab.getValue("M_AttributeSetInstance_ID");
                    int M_ASI_ID = asiValue != null ? (Integer)asiValue : 0;
                    int AD_Org_ID = inventory.getAD_Org_ID();
                    int C_Currency_ID = inventory.getC_Currency_ID();
                    if (as.getC_Currency_ID() != C_Currency_ID) {
                        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)ctx, (int)client.get_ID());
                        int i = 0;
                        while (i < ass.length) {
                            MAcctSchema a = ass[i];
                            if (a.getC_Currency_ID() == C_Currency_ID) {
                                as = a;
                            }
                            ++i;
                        }
                    }
                    if ((cost = product.getCostingRecord(as, AD_Org_ID, M_ASI_ID, costingMethod)) == null && !"S".equals(costingMethod)) {
                        mTab.setValue(mField, null);
                        return Msg.getMsg((Properties)Env.getCtx(), (String)"NoCostingRecord");
                    }
                    mTab.setValue("CurrentCostPrice", (Object)cost.getCurrentCostPrice());
                    mTab.setValue("NewCostPrice", (Object)cost.getCurrentCostPrice());
                }
            }
        }
        return null;
    }
}

