/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.jasper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MInvoice;
import org.compiere.model.MProcess;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PrintWithinProcess
extends AbstractTestCase {
    private MProcess setupProcess(Properties ctx, String trxName, String jasperReport) {
        MProcess process = new MProcess(ctx, 0, trxName);
        process.set_ValueNoCheck("AD_Client_ID", (Object)0);
        process.setAD_Org_ID(0);
        process.setJasperReport(jasperReport);
        process.setName("Test Invoice Jasper");
        process.setValue("Test_Invoice_Jasper");
        process.saveCrossTenantSafeEx();
        this.commit();
        return process;
    }

    private ProcessInfo setupProcessInfo(MProcess process) {
        ProcessInfo pi = new ProcessInfo(process.getName(), process.getAD_Process_ID());
        pi.setClassName("org.adempiere.report.jasper.ReportStarter");
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setPrintPreview(false);
        pi.setIsBatch(true);
        return pi;
    }

    @Test
    public void testPrintWithLocalFile() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MProcess process = null;
        try {
            String fileName = this.putResourceInTempFolder("org/idempiere/test/jasper/AR_Invoice.jrxml");
            process = this.setupProcess(ctx, trxName, "file://" + fileName);
            List invoices = new Query(ctx, "C_Invoice", "C_Invoice_ID IN (?,?)", trxName).setClient_ID().setOnlyActiveRecords(true).setParameters(new Object[]{103, 109}).list();
            for (MInvoice invoice : invoices) {
                invoice.setDescription("Test Printing within a Process");
                invoice.saveEx();
            }
            ProcessInfo pi = this.setupProcessInfo(process);
            Trx trx = Trx.get((String)trxName, (boolean)false);
            ArrayList<File> pdfList = new ArrayList<File>();
            for (MInvoice invoice : invoices) {
                pi.setRecord_ID(invoice.getC_Invoice_ID());
                ProcessUtil.startJavaProcess((Properties)Env.getCtx(), (ProcessInfo)pi, (Trx)trx, (boolean)false);
                Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
                Assertions.assertFalse((pi.getPDFReport() == null ? 1 : 0) != 0);
                pdfList.add(pi.getPDFReport());
            }
            Assertions.assertFalse((boolean)pdfList.isEmpty());
        }
        finally {
            this.rollback();
            if (process != null) {
                int oldRole = Env.getAD_Role_ID((Properties)ctx);
                try {
                    PO.setCrossTenantSafe();
                    Env.setContext((Properties)ctx, (String)"#AD_Role_ID", (int)0);
                    process.deleteEx(true);
                }
                finally {
                    Env.setContext((Properties)ctx, (String)"#AD_Role_ID", (int)oldRole);
                    PO.clearCrossTenantSafe();
                }
            }
            this.commit();
        }
    }

    private String putResourceInTempFolder(String resource) {
        URL url = this.getClass().getClassLoader().getResource(resource);
        if (url != null) {
            File tmpOutputFile;
            block23: {
                String localFileName = url.toString().substring(url.toString().lastIndexOf(File.separator) + 1);
                String extension = localFileName.substring(localFileName.lastIndexOf("."));
                tmpOutputFile = null;
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (InputStream inputStream = url.openStream();){
                        if (inputStream == null) break block23;
                        File tmpdir = Files.createTempDirectory("test_jasper_" + Env.getContext((Properties)Env.getCtx(), (String)"#AD_Session_ID"), new FileAttribute[0]).toFile();
                        tmpOutputFile = File.createTempFile(localFileName.substring(0, localFileName.lastIndexOf(".")), extension, tmpdir);
                        Throwable throwable2 = null;
                        Object var11_15 = null;
                        try (FileOutputStream out = new FileOutputStream(tmpOutputFile);){
                            if (out != null) {
                                int len;
                                byte[] buf = new byte[1024];
                                while ((len = inputStream.read(buf)) > 0) {
                                    ((OutputStream)out).write(buf, 0, len);
                                }
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new AdempiereException((Throwable)e);
                }
            }
            return tmpOutputFile.getAbsolutePath();
        }
        throw new AdempiereException("Resource " + resource + " not found");
    }

    @Test
    public void testPrintWithBundleResource() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MProcess process = null;
        try {
            process = this.setupProcess(ctx, trxName, "bundle:org.idempiere.test:/AR_Invoice_Bundle.jrxml");
            List invoices = new Query(ctx, "C_Invoice", "C_Invoice_ID IN (?,?)", trxName).setClient_ID().setOnlyActiveRecords(true).setParameters(new Object[]{103, 109}).list();
            for (MInvoice invoice : invoices) {
                invoice.setDescription("Test Printing within a Process");
                invoice.saveEx();
            }
            ProcessInfo pi = this.setupProcessInfo(process);
            Trx trx = Trx.get((String)trxName, (boolean)false);
            ArrayList<File> pdfList = new ArrayList<File>();
            for (MInvoice invoice : invoices) {
                pi.setRecord_ID(invoice.getC_Invoice_ID());
                ProcessUtil.startJavaProcess((Properties)Env.getCtx(), (ProcessInfo)pi, (Trx)trx, (boolean)false);
                Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
                Assertions.assertFalse((pi.getPDFReport() == null ? 1 : 0) != 0);
                pdfList.add(pi.getPDFReport());
            }
            Assertions.assertFalse((boolean)pdfList.isEmpty());
        }
        finally {
            this.rollback();
            if (process != null) {
                int oldRole = Env.getAD_Role_ID((Properties)ctx);
                try {
                    PO.setCrossTenantSafe();
                    Env.setContext((Properties)ctx, (String)"#AD_Role_ID", (int)0);
                    process.deleteEx(true);
                }
                finally {
                    Env.setContext((Properties)ctx, (String)"#AD_Role_ID", (int)oldRole);
                    PO.clearCrossTenantSafe();
                }
            }
            this.commit();
        }
    }

    @Test
    public void testPrintWithClassPathResource() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MProcess process = null;
        try {
            process = this.setupProcess(ctx, trxName, "resource:org.idempiere.test:org/idempiere/test/jasper/AR_Invoice.jrxml");
            List invoices = new Query(ctx, "C_Invoice", "C_Invoice_ID IN (?,?)", trxName).setClient_ID().setOnlyActiveRecords(true).setParameters(new Object[]{103, 109}).list();
            for (MInvoice invoice : invoices) {
                invoice.setDescription("Test Printing within a Process");
                invoice.saveEx();
            }
            ProcessInfo pi = this.setupProcessInfo(process);
            Trx trx = Trx.get((String)trxName, (boolean)false);
            ArrayList<File> pdfList = new ArrayList<File>();
            for (MInvoice invoice : invoices) {
                pi.setRecord_ID(invoice.getC_Invoice_ID());
                ProcessUtil.startJavaProcess((Properties)Env.getCtx(), (ProcessInfo)pi, (Trx)trx, (boolean)false);
                Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
                Assertions.assertFalse((pi.getPDFReport() == null ? 1 : 0) != 0);
                pdfList.add(pi.getPDFReport());
            }
            Assertions.assertFalse((boolean)pdfList.isEmpty());
        }
        finally {
            this.rollback();
            if (process != null) {
                int oldRole = Env.getAD_Role_ID((Properties)ctx);
                try {
                    PO.setCrossTenantSafe();
                    Env.setContext((Properties)ctx, (String)"#AD_Role_ID", (int)0);
                    process.deleteEx(true);
                }
                finally {
                    Env.setContext((Properties)ctx, (String)"#AD_Role_ID", (int)oldRole);
                    PO.clearCrossTenantSafe();
                }
            }
            this.commit();
        }
    }

    @Test
    public void testEncryptReport() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MProcess process = null;
        try {
            process = this.setupProcess(ctx, trxName, "bundle:org.idempiere.test:/AR_Invoice_Bundle.jrxml");
            List invoices = new Query(ctx, "C_Invoice", "C_Invoice_ID IN (?,?)", trxName).setClient_ID().setOnlyActiveRecords(true).setParameters(new Object[]{103, 109}).list();
            for (MInvoice invoice : invoices) {
                invoice.setDescription("Test Printing within a Process");
                invoice.saveEx();
            }
            ProcessInfo pi = this.setupProcessInfo(process);
            pi.setExport(true);
            Trx trx = Trx.get((String)trxName, (boolean)false);
            ProcessInfoParameter[] parameter = new ProcessInfoParameter[]{new ProcessInfoParameter("isEncrypted", (Object)true, null, null, null), new ProcessInfoParameter("readPassword", (Object)"readPassword", null, null, null), new ProcessInfoParameter("createPassword", (Object)"createPassword", null, null, null)};
            pi.setParameter(parameter);
            ArrayList<File> pdfList = new ArrayList<File>();
            for (MInvoice invoice : invoices) {
                pi.setRecord_ID(invoice.getC_Invoice_ID());
                ProcessUtil.startJavaProcess((Properties)Env.getCtx(), (ProcessInfo)pi, (Trx)trx, (boolean)false);
                Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
                Assertions.assertFalse((pi.getExportFile() == null ? 1 : 0) != 0);
                pdfList.add(pi.getExportFile());
            }
            Assertions.assertFalse((boolean)pdfList.isEmpty());
        }
        finally {
            this.rollback();
            if (process != null) {
                int oldRole = Env.getAD_Role_ID((Properties)ctx);
                try {
                    PO.setCrossTenantSafe();
                    Env.setContext((Properties)ctx, (String)"#AD_Role_ID", (int)0);
                    process.deleteEx(true);
                }
                finally {
                    Env.setContext((Properties)ctx, (String)"#AD_Role_ID", (int)oldRole);
                    PO.clearCrossTenantSafe();
                }
            }
            this.commit();
        }
    }
}

