/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MatchingTest
extends AbstractTestCase {
    @Test
    public void testMatchReceiptToPO() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        BigDecimal orderQty = new BigDecimal("1");
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(orderQty);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        MInOut receipt = new MInOut(Env.getCtx(), 0, this.getTrxName());
        receipt.setBPartner(bpartner);
        receipt.setIsSOTrx(false);
        receipt.setC_DocType_ID(DictionaryIDs.C_DocType.MM_RECEIPT.id);
        receipt.setM_Warehouse_ID(this.getM_Warehouse_ID());
        receipt.saveEx();
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        BigDecimal receiptQty = new BigDecimal("1");
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setProduct(product);
        receiptLine.setM_Locator_ID(M_Locator_ID);
        receiptLine.setLine(10);
        receiptLine.setQty(receiptQty);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        List notMatchList = MInOut.getNotFullyMatchedToOrder((int)bpartner.get_ID(), (int)product.get_ID(), (int)0, null, null, (String)this.getTrxName());
        Assertions.assertTrue((notMatchList.size() > 0 ? 1 : 0) != 0, (String)"Fail to retrieve receipts not fully matched to order");
        Optional<MInOut.MatchingRecord> optionalReceipt = notMatchList.stream().filter(m -> receipt.getDocumentNo().equals(m.documentNo())).findFirst();
        Assertions.assertTrue((boolean)optionalReceipt.isPresent(), (String)"Can't find not matched Material Receipt line");
        List notMatchOrders = MOrder.getNotFullyMatchedToReceipt((int)bpartner.get_ID(), (int)product.get_ID(), (int)0, null, null, (String)this.getTrxName());
        Assertions.assertTrue((notMatchOrders.size() > 0 ? 1 : 0) != 0, (String)"Fail to retrieve orders not fully matched to material receipt");
        Optional<MOrder.MatchingRecord> optionalOrder = notMatchOrders.stream().filter(m -> order.getDocumentNo().equals(m.documentNo())).findFirst();
        Assertions.assertTrue((boolean)optionalOrder.isPresent(), (String)"Can't find not matched PO line");
        boolean ok = receiptLine.matchToOrderLine(orderLine.get_ID(), orderLine.getQtyOrdered());
        Assertions.assertTrue((boolean)ok, (String)"Failed to match receipt line to order line");
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)1, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        receiptLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)orderLine.getC_OrderLine_ID(), (int)receiptLine.getC_OrderLine_ID(), (String)"Unexpected order line ID value for receipt line");
        MMatchPO[] matchPOs = MMatchPO.getOrderLine((Properties)Env.getCtx(), (int)orderLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchPOs.length, (String)"Unexpected number of MatchPO for order line");
    }

    @Test
    public void testMatchInvoiceToReceipt() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        BigDecimal orderQty = new BigDecimal("1");
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(orderQty);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setC_OrderLine_ID(orderLine.get_ID());
        receiptLine.setLine(10);
        receiptLine.setProduct(product);
        receiptLine.setQty(BigDecimal.ONE);
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        receiptLine.setM_Locator_ID(M_Locator_ID);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        if (!receipt.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)receipt.isPosted());
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        invoice.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.AP_INVOICE.id);
        invoice.setBPartner(bpartner);
        invoice.setDateAcct(order.getDateAcct());
        invoice.setDateInvoiced(order.getDateOrdered());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        BigDecimal qtyInvoiced = new BigDecimal(1);
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setProduct(product);
        invoiceLine.setLine(10);
        invoiceLine.setQty(qtyInvoiced);
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        if (!invoice.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)invoice.isPosted());
        List notMatchInvoices = MInvoice.getNotFullyMatchedToReceipt((int)bpartner.get_ID(), (int)product.getM_Product_ID(), (int)0, null, null, (String)this.getTrxName());
        Assertions.assertTrue((notMatchInvoices.size() > 0 ? 1 : 0) != 0, (String)"Unexpected number of records for not matched vendor invoice");
        Optional<MInvoice.MatchingRecord> optionalInvoice = notMatchInvoices.stream().filter(nmi -> invoice.getDocumentNo().equals(nmi.documentNo())).findFirst();
        Assertions.assertTrue((boolean)optionalInvoice.isPresent(), (String)"Can't find not matched vendor invoice line");
        List notMatchReceipts = MInOut.getNotFullyMatchedToInvoice((int)bpartner.getC_BPartner_ID(), (int)product.getM_Product_ID(), (int)0, null, null, (String)this.getTrxName());
        Assertions.assertTrue((notMatchReceipts.size() > 0 ? 1 : 0) != 0, (String)"Unexpected number of records for not matched material receipt Line");
        Optional<MInOut.MatchingRecord> optionalReceipt = notMatchReceipts.stream().filter(nmr -> receipt.getDocumentNo().equals(nmr.documentNo())).findFirst();
        Assertions.assertTrue((boolean)optionalReceipt.isPresent(), (String)"Can't find not matched material receipt line");
        boolean ok = receiptLine.matchToInvoiceLine(invoiceLine.getC_InvoiceLine_ID(), qtyInvoiced);
        Assertions.assertTrue((boolean)ok, (String)"Failed to match receipt line to invoice line");
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyInvoiced().intValue(), (String)"Unexpected order line qty invoiced value");
        receiptLine.load(this.getTrxName(), new String[0]);
        MMatchInv[] matchInvs = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchInvs.length, (String)"Unexpected number of MatchInv for invoice line");
    }

    @Test
    public void testMatchReceiptToInvoice() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        BigDecimal orderQty = new BigDecimal("1");
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(orderQty);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setC_OrderLine_ID(orderLine.get_ID());
        receiptLine.setLine(10);
        receiptLine.setProduct(product);
        receiptLine.setQty(BigDecimal.ONE);
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        receiptLine.setM_Locator_ID(M_Locator_ID);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        if (!receipt.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)receipt.isPosted());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)1, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyInvoiced().intValue(), (String)"Unexpected order line qty invoiced value");
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        invoice.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.AP_INVOICE.id);
        invoice.setBPartner(bpartner);
        invoice.setDateAcct(order.getDateAcct());
        invoice.setDateInvoiced(order.getDateOrdered());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        BigDecimal qtyInvoiced = new BigDecimal(1);
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setProduct(product);
        invoiceLine.setLine(10);
        invoiceLine.setQty(qtyInvoiced);
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        if (!invoice.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)invoice.isPosted());
        List notMatchReceipts = MInOut.getNotFullyMatchedToInvoice((int)bpartner.getC_BPartner_ID(), (int)product.getM_Product_ID(), (int)0, null, null, (String)this.getTrxName());
        Assertions.assertTrue((notMatchReceipts.size() > 0 ? 1 : 0) != 0, (String)"Unexpected number of records for not matched material receipt");
        Optional<MInOut.MatchingRecord> optionalReceipt = notMatchReceipts.stream().filter(nmr -> receipt.getDocumentNo().equals(nmr.documentNo())).findFirst();
        Assertions.assertTrue((boolean)optionalReceipt.isPresent(), (String)"Can't find not matched material receipt line");
        List notMatchInvoices = MInvoice.getNotFullyMatchedToReceipt((int)bpartner.getC_BPartner_ID(), (int)product.getM_Product_ID(), (int)0, null, null, (String)this.getTrxName());
        Assertions.assertTrue((notMatchInvoices.size() > 0 ? 1 : 0) != 0, (String)"Unexpected number of records for not matched vendor invoice Line");
        Optional<MInvoice.MatchingRecord> optionalInvoice = notMatchInvoices.stream().filter(nmi -> invoice.getDocumentNo().equals(nmi.documentNo())).findFirst();
        Assertions.assertTrue((boolean)optionalInvoice.isPresent(), (String)"Can't find not matched vendor invoice line");
        boolean ok = receiptLine.matchToInvoiceLine(invoiceLine.getC_InvoiceLine_ID(), qtyInvoiced);
        Assertions.assertTrue((boolean)ok, (String)"Failed to match receipt line to invoice line");
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyInvoiced().intValue(), (String)"Unexpected order line qty invoiced value");
        receiptLine.load(this.getTrxName(), new String[0]);
        MMatchInv[] matchInvs = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchInvs.length, (String)"Unexpected number of MatchInv for invoice line");
    }
}

