/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.awt.Point;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MColumn;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.model.X_AD_WF_Node;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWFNodePara;
import org.compiere.wf.MWorkflow;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MWFNode
extends X_AD_WF_Node
implements ImmutablePOSupport {
    private static final long serialVersionUID = 3328770995394833132L;
    private static ImmutablePOCache<String, MWFNode> s_cache = new ImmutablePOCache("AD_WF_Node", 50);
    private List<MWFNodeNext> m_next = new ArrayList<MWFNodeNext>();
    private String m_name_trl = null;
    private String m_description_trl = null;
    private String m_help_trl = null;
    private boolean m_translated = false;
    private MColumn m_column = null;
    private MWFNodePara[] m_paras = null;
    private long m_durationBaseMS = -1L;

    public static MWFNode get(int AD_WF_Node_ID) {
        return MWFNode.get(Env.getCtx(), AD_WF_Node_ID);
    }

    public static MWFNode get(Properties ctx, int AD_WF_Node_ID) {
        String key = Env.getAD_Language(ctx) + "_" + AD_WF_Node_ID;
        MWFNode retValue = s_cache.get(ctx, key, e -> new MWFNode(ctx, (MWFNode)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MWFNode(ctx, AD_WF_Node_ID, null);
        if (retValue.get_ID() == AD_WF_Node_ID) {
            s_cache.put(key, retValue, e -> new MWFNode(Env.getCtx(), (MWFNode)e));
            return retValue;
        }
        return null;
    }

    public static MWFNode getCopy(Properties ctx, int AD_WF_Node_ID, String trxName) {
        MWFNode node = MWFNode.get(AD_WF_Node_ID);
        if (node != null) {
            node = new MWFNode(ctx, node, trxName);
        }
        return node;
    }

    public MWFNode(Properties ctx, String AD_WF_Node_UU, String trxName) {
        super(ctx, AD_WF_Node_UU, trxName);
        if (Util.isEmpty(AD_WF_Node_UU)) {
            this.setInitialDefaults();
        }
        if (this.getAD_WF_Node_ID() > 0) {
            this.loadNext();
            this.loadTrl();
        }
    }

    public MWFNode(Properties ctx, int AD_WF_Node_ID, String trxName) {
        super(ctx, AD_WF_Node_ID, trxName);
        if (AD_WF_Node_ID == 0) {
            this.setInitialDefaults();
        }
        if (this.getAD_WF_Node_ID() > 0) {
            this.loadNext();
            this.loadTrl();
        }
    }

    private void setInitialDefaults() {
        this.setAction("Z");
        this.setCost(Env.ZERO);
        this.setDuration(0);
        this.setEntityType("U");
        this.setIsCentrallyMaintained(true);
        this.setJoinElement("X");
        this.setLimit(0);
        this.setSplitElement("X");
        this.setWaitingTime(0);
        this.setXPosition(0);
        this.setYPosition(0);
    }

    public MWFNode(MWorkflow wf, String Value, String Name2) {
        this(wf.getCtx(), 0, wf.get_TrxName());
        this.setClientOrg(wf);
        this.setAD_Workflow_ID(wf.getAD_Workflow_ID());
        this.setValue(Value);
        this.setName(Name2);
        this.m_durationBaseMS = wf.getDurationBaseSec() * 1000L;
    }

    public MWFNode(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.loadNext();
        this.loadTrl();
    }

    public MWFNode(MWFNode copy) {
        this(Env.getCtx(), copy);
    }

    public MWFNode(Properties ctx, MWFNode copy) {
        this(ctx, copy, null);
    }

    public MWFNode(Properties ctx, MWFNode copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_next = copy.m_next != null ? (List)copy.m_next.stream().map(e -> new MWFNodeNext(ctx, (MWFNodeNext)e, trxName)).collect(Collectors.toCollection(ArrayList::new)) : null;
        this.m_name_trl = copy.m_name_trl;
        this.m_description_trl = copy.m_description_trl;
        this.m_help_trl = copy.m_help_trl;
        this.m_translated = copy.m_translated;
        this.m_column = copy.m_column != null ? new MColumn(ctx, copy.m_column, trxName) : null;
        this.m_paras = copy.m_paras != null ? (MWFNodePara[])Arrays.stream(copy.m_paras).map(e -> new MWFNodePara(ctx, (MWFNodePara)e, trxName)).toArray(MWFNodePara[]::new) : null;
        this.m_durationBaseMS = copy.m_durationBaseMS;
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    private void loadNext() {
        this.m_next = new Query(this.getCtx(), "AD_WF_NodeNext", "AD_WF_NodeNext.AD_WF_Node_ID=? AND AD_WF_NodeNext.AD_Client_ID IN (0, ?)", this.get_TrxName()).addJoinClause(" JOIN AD_WF_Node ON (AD_WF_Node.AD_WF_Node_ID=AD_WF_NodeNext.AD_WF_Next_ID AND AD_WF_Node.IsActive='Y')").setParameters(this.get_ID(), Env.getAD_Client_ID(Env.getCtx())).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        boolean splitAnd = "A".equals(this.getSplitElement());
        for (MWFNodeNext next : this.m_next) {
            next.setFromSplitAnd(splitAnd);
            if (!this.is_Immutable()) continue;
            next.markImmutable();
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_next.size());
        }
    }

    private void loadTrl() {
        if (Env.isBaseLanguage(this.getCtx(), "AD_Workflow") || this.get_ID() == 0) {
            return;
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement("SELECT Name, Description, Help FROM AD_WF_Node_Trl WHERE AD_WF_Node_ID=? AND AD_Language=?", this.get_TrxName());
                pstmt.setInt(1, this.get_ID());
                pstmt.setString(2, Env.getAD_Language(this.getCtx()));
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_name_trl = rs.getString(1);
                    this.m_description_trl = rs.getString(2);
                    this.m_help_trl = rs.getString(3);
                    this.m_translated = true;
                }
            }
            catch (SQLException e) {
                throw new DBException(e, "SELECT Name, Description, Help FROM AD_WF_Node_Trl WHERE AD_WF_Node_ID=? AND AD_Language=?");
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Trl=" + this.m_translated);
        }
    }

    public int getNextNodeCount() {
        return this.m_next.size();
    }

    public MWFNodeNext[] getTransitions(int AD_Client_ID) {
        this.loadNext();
        ArrayList<MWFNodeNext> list = new ArrayList<MWFNodeNext>();
        int i2 = 0;
        while (i2 < this.m_next.size()) {
            MWFNodeNext next = this.m_next.get(i2);
            if (next.getAD_Client_ID() == 0 || next.getAD_Client_ID() == AD_Client_ID) {
                list.add(next);
            }
            ++i2;
        }
        MWFNodeNext[] retValue = new MWFNodeNext[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String getName(boolean translated) {
        if (translated && this.m_translated) {
            return this.m_name_trl;
        }
        return this.getName();
    }

    public String getDescription(boolean translated) {
        if (translated && this.m_translated) {
            return this.m_description_trl;
        }
        return this.getDescription();
    }

    public String getHelp(boolean translated) {
        if (translated && this.m_translated) {
            return this.m_help_trl;
        }
        return this.getHelp();
    }

    public void setPosition(Point position) {
        this.setPosition(position.x, position.y);
    }

    public void setPosition(int x, int y) {
        this.setXPosition(x);
        this.setYPosition(y);
    }

    public Point getPosition() {
        return new Point(this.getXPosition(), this.getYPosition());
    }

    public String getActionInfo() {
        String action = this.getAction();
        if ("P".equals(action)) {
            return "Process:AD_Process_ID=" + this.getAD_Process_ID();
        }
        if ("D".equals(action)) {
            return "DocumentAction=" + this.getDocAction();
        }
        if ("R".equals(action)) {
            return "Report:AD_Process_ID=" + this.getAD_Process_ID();
        }
        if ("T".equals(action)) {
            return "Task:AD_Task_ID=" + this.getAD_Task_ID();
        }
        if ("V".equals(action)) {
            return "SetVariable:AD_Column_ID=" + this.getAD_Column_ID();
        }
        if ("F".equals(action)) {
            return "Workflow:AD_Workflow_ID=" + this.getAD_Workflow_ID();
        }
        if ("C".equals(action)) {
            return "UserChoice:AD_Column_ID=" + this.getAD_Column_ID();
        }
        if ("X".equals(action)) {
            return "Form:AD_Form_ID=" + this.getAD_Form_ID();
        }
        if ("W".equals(action)) {
            return "Window:AD_Window_ID=" + this.getAD_Window_ID();
        }
        if ("I".equals(action)) {
            return "Window:AD_InfoWindow_ID=" + this.getAD_InfoWindow_ID();
        }
        if ("Z".equals(action)) {
            return "Sleep:WaitTime=" + this.getWaitTime();
        }
        return "??";
    }

    @Override
    public String getAttributeName() {
        if (this.getAD_Column_ID() == 0) {
            return super.getAttributeName();
        }
        String attribute = super.getAttributeName();
        if (attribute != null && attribute.length() > 0) {
            return attribute;
        }
        this.setAttributeName(this.getColumn().getColumnName());
        return super.getAttributeName();
    }

    public MColumn getColumn() {
        if (this.getAD_Column_ID() == 0) {
            return null;
        }
        if (this.m_column == null) {
            this.m_column = this.is_Immutable() ? MColumn.get(this.getCtx(), this.getAD_Column_ID()) : MColumn.getCopy(this.getCtx(), this.getAD_Column_ID(), this.get_TrxName());
        }
        return this.m_column;
    }

    public boolean isUserApproval() {
        if (!"C".equals(this.getAction())) {
            return false;
        }
        return this.getColumn() != null && "IsApproved".equals(this.getColumn().getColumnName());
    }

    public boolean isUserChoice() {
        return "C".equals(this.getAction());
    }

    public boolean isUserManual() {
        return "X".equals(this.getAction()) || "W".equals(this.getAction()) || "I".equals(this.getAction());
    }

    public long getDurationMS() {
        long duration = super.getDuration();
        if (duration == 0L) {
            return 0L;
        }
        if (this.m_durationBaseMS == -1L) {
            this.m_durationBaseMS = this.getAD_Workflow().getDurationBaseSec() * 1000L;
        }
        return duration * this.m_durationBaseMS;
    }

    public long getLimitMS() {
        long limit = super.getLimit();
        if (limit == 0L) {
            return 0L;
        }
        if (this.m_durationBaseMS == -1L) {
            this.m_durationBaseMS = this.getAD_Workflow().getDurationBaseSec() * 1000L;
        }
        return limit * this.m_durationBaseMS;
    }

    public int getDurationCalendarField() {
        return this.getAD_Workflow().getDurationCalendarField();
    }

    public int calculateDynamicPriority(int seconds) {
        if (seconds == 0 || this.getDynPriorityUnit() == null || this.getDynPriorityChange() == null || Env.ZERO.compareTo(this.getDynPriorityChange()) == 0) {
            return 0;
        }
        BigDecimal divide = Env.ZERO;
        if ("M".equals(this.getDynPriorityUnit())) {
            divide = new BigDecimal(60);
        } else if ("H".equals(this.getDynPriorityUnit())) {
            divide = new BigDecimal(3600);
        } else if ("D".equals(this.getDynPriorityUnit())) {
            divide = new BigDecimal(86400);
        } else {
            return 0;
        }
        BigDecimal change = new BigDecimal(seconds).divide(divide, RoundingMode.DOWN).multiply(this.getDynPriorityChange());
        return change.intValue();
    }

    public MWFNodePara[] getParameters() {
        if (this.m_paras == null) {
            this.m_paras = MWFNodePara.getParameters(this.getCtx(), this.getAD_WF_Node_ID());
            if (this.m_paras != null && this.m_paras.length > 0 && this.is_Immutable()) {
                Arrays.stream(this.m_paras).forEach(e -> {
                    MWFNodePara mWFNodePara = e.markImmutable();
                });
            }
        }
        return this.m_paras;
    }

    @Override
    public MWorkflow getWorkflow() {
        return this.getAD_Workflow();
    }

    @Override
    public MWorkflow getAD_Workflow() {
        return MWorkflow.getCopy(this.getCtx(), this.getAD_Workflow_ID(), this.get_TrxName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MWFNode[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Action=").append(this.getActionInfo()).append("]");
        return sb.toString();
    }

    public String toStringX() {
        StringBuilder sb = new StringBuilder("MWFNode[");
        sb.append(this.getName()).append("-").append(this.getActionInfo()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String action = this.getAction();
        if (!action.equals("Z")) {
            if (action.equals("P") || action.equals("R")) {
                if (this.getAD_Process_ID() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "AD_Process_ID"));
                    return false;
                }
            } else if (action.equals("T")) {
                if (this.getAD_Task_ID() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "AD_Task_ID"));
                    return false;
                }
            } else if (action.equals("D")) {
                if (this.getDocAction() == null || this.getDocAction().length() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "DocAction"));
                    return false;
                }
            } else if (action.equals("M")) {
                if (this.getR_MailText_ID() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "R_MailText_ID"));
                    return false;
                }
            } else if (action.equals("V")) {
                MColumn column;
                if (this.getAttributeValue() == null) {
                    this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "AttributeValue"));
                    return false;
                }
                if (this.getAD_Column_ID() > 0 && ((column = MColumn.get(this.getCtx(), this.getAD_Column_ID(), this.get_TrxName())).isSecure() || column.isAdvanced()) && !MRole.getDefault().isAccessAdvanced()) {
                    this.log.saveError("AccessTableNoUpdate", Msg.getElement(this.getCtx(), column.getColumnName()));
                    return false;
                }
            } else if (action.equals("F")) {
                if (this.getAD_Workflow_ID() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "AD_Workflow_ID"));
                    return false;
                }
            } else if (action.equals("C")) {
                if (this.getAD_Column_ID() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "AD_Column_ID"));
                    return false;
                }
            } else if (action.equals("X")) {
                if (this.getAD_Form_ID() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "AD_Form_ID"));
                    return false;
                }
            } else if (action.equals("W")) {
                if (this.getAD_Window_ID() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "AD_Window_ID"));
                    return false;
                }
            } else if (action.equals("I") && this.getAD_InfoWindow_ID() == 0) {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "AD_InfoWindow_ID"));
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        return success;
    }

    public boolean isValidFromTo(Timestamp date) {
        Timestamp validFrom = this.getValidFrom();
        Timestamp validTo = this.getValidTo();
        if (validFrom != null && date.before(validFrom)) {
            return false;
        }
        return validTo == null || !date.after(validTo);
    }

    @Override
    public MWFNode markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_column != null) {
            this.m_column.markImmutable();
        }
        if (this.m_next != null && this.m_next.size() > 0) {
            this.m_next.stream().forEach(e -> {
                MWFNodeNext mWFNodeNext = e.markImmutable();
            });
        }
        if (this.m_paras != null && this.m_paras.length > 0) {
            Arrays.stream(this.m_paras).forEach(e -> {
                MWFNodePara mWFNodePara = e.markImmutable();
            });
        }
        return this;
    }
}

