/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.attribute.DocAttributeSet;
import org.adempiere.base.Core;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.ArchiveEngine;
import org.compiere.print.CPaper;
import org.compiere.print.DataEngine;
import org.compiere.print.MPrintColor;
import org.compiere.print.MPrintFont;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.MPrintPaper;
import org.compiere.print.MPrintTableFormat;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.layout.BarcodeElement;
import org.compiere.print.layout.BoxElement;
import org.compiere.print.layout.HTMLElement;
import org.compiere.print.layout.HeaderFooter;
import org.compiere.print.layout.ImageElement;
import org.compiere.print.layout.InstanceAttributeData;
import org.compiere.print.layout.LocationElement;
import org.compiere.print.layout.PInstanceLogElement;
import org.compiere.print.layout.Page;
import org.compiere.print.layout.ParameterElement;
import org.compiere.print.layout.PrintDataEvaluatee;
import org.compiere.print.layout.PrintElement;
import org.compiere.print.layout.StringElement;
import org.compiere.print.layout.TableElement;
import org.compiere.print.layout.TableProperties;
import org.compiere.print.util.SerializableMatrixImpl;
import org.compiere.report.MReportLine;
import org.compiere.util.CLogger;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluator;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.idempiere.print.IPrintHeaderFooter;
import org.idempiere.print.StandardHeaderFooter;

public class LayoutEngine
implements Pageable,
Printable,
Doc {
    private static CLogger log = CLogger.getCLogger(LayoutEngine.class);
    private boolean m_hasLayout = false;
    private MPrintFormat m_format;
    private Properties m_printCtx;
    private PrintData m_data;
    private MQuery m_query;
    private MPrintColor m_printColor;
    private MPrintFont m_printFont;
    private int m_columnCount = -1;
    private String m_TrxName = null;
    private PrintInfo m_PrintInfo = null;
    private int m_windowNo = 0;
    private CPaper m_paper;
    private int m_headerHeight = 18;
    private int m_footerHeight = 18;
    private int m_pageNo = 0;
    private Page m_currPage;
    private ArrayList<Page> m_pages = new ArrayList();
    private HeaderFooter m_headerFooter;
    private Rectangle m_header = new Rectangle();
    private Rectangle m_content = new Rectangle();
    private Rectangle m_footer = new Rectangle();
    private int m_tempNLPositon = 0;
    public static final int AREA_HEADER = 0;
    public static final int AREA_CONTENT = 1;
    public static final int AREA_FOOTER = 2;
    private int m_area = 1;
    private Point2D.Double[] m_position = new Point2D.Double[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0)};
    private float[] m_maxHeightSinceNewLine = new float[]{0.0f, 0.0f, 0.0f};
    private TableElement m_tableElement = null;
    private float[] m_lastHeight = new float[]{0.0f, 0.0f, 0.0f};
    private float[] m_lastWidth = new float[]{0.0f, 0.0f, 0.0f};
    public static boolean s_FASTDRAW = true;
    private boolean m_isCopy = false;
    public static Image IMAGE_TRUE = null;
    public static Image IMAGE_FALSE = null;
    public static Dimension IMAGE_SIZE = new Dimension(10, 10);
    private Map<MPrintFormatItem, PrintData> childPrintFormatDetails = new HashMap<MPrintFormatItem, PrintData>();
    public Boolean[] colSuppressRepeats;

    static {
        Toolkit tk = Toolkit.getDefaultToolkit();
        URL url = LayoutEngine.class.getResource("true10.gif");
        if (url != null) {
            IMAGE_TRUE = tk.getImage(url);
        }
        if ((url = LayoutEngine.class.getResource("false10.gif")) != null) {
            IMAGE_FALSE = tk.getImage(url);
        }
    }

    public LayoutEngine(MPrintFormat format, PrintData data, MQuery query, PrintInfo info) {
        this(format, data, query, info, 0);
    }

    public LayoutEngine(MPrintFormat format, PrintData data, MQuery query, PrintInfo info, int windowNo) {
        this(format, data, query, info, null, windowNo);
    }

    public LayoutEngine(MPrintFormat format, PrintData data, MQuery query, PrintInfo info, String trxName) {
        this(format, data, query, info, trxName, 0);
    }

    public LayoutEngine(MPrintFormat format, PrintData data, MQuery query, PrintInfo info, String trxName, int windowNo) {
        this.m_windowNo = windowNo;
        this.m_TrxName = trxName;
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(format) + " - " + String.valueOf(data) + " - " + String.valueOf(query));
        }
        this.setPrintFormat(format, false);
        this.setPrintData(data, query, false);
        this.setPrintInfo(info);
        this.layout();
    }

    public void setPrintFormat(MPrintFormat format, boolean doLayout) {
        this.m_format = format;
        this.colSuppressRepeats = null;
        this.m_printCtx = new Properties(format.getCtx());
        boolean tempHasLayout = this.m_hasLayout;
        this.m_hasLayout = false;
        MPrintPaper mPaper = MPrintPaper.get(format.getAD_PrintPaper_ID());
        if (this.m_format.isStandardHeaderFooter()) {
            StandardHeaderFooter headerFooter = new StandardHeaderFooter();
            this.setPaper(mPaper.getCPaper(), headerFooter.getHeaderHeight(), headerFooter.getFooterHeight());
        } else if (this.m_format.getAD_PrintHeaderFooter_ID() > 0) {
            IPrintHeaderFooter printHeaderFooter = Core.getPrintHeaderFooter(this.m_format.getAD_PrintHeaderFooter());
            if (printHeaderFooter != null) {
                this.setPaper(mPaper.getCPaper(), printHeaderFooter.getHeaderHeight(), printHeaderFooter.getFooterHeight());
            } else {
                this.setPaper(mPaper.getCPaper(), this.m_format.getHeaderMargin(), this.m_format.getFooterMargin());
            }
        } else {
            this.setPaper(mPaper.getCPaper(), this.m_format.getHeaderMargin(), this.m_format.getFooterMargin());
        }
        this.m_hasLayout = tempHasLayout;
        this.m_printColor = MPrintColor.get(this.getCtx(), format.getAD_PrintColor_ID());
        this.m_printFont = MPrintFont.get(format.getAD_PrintFont_ID());
        Env.setContext(this.m_printCtx, "*ReportName", this.m_format.get_Translation("Name"));
        Env.setContext(this.m_printCtx, "*Header", Env.getHeader(this.m_printCtx, this.m_windowNo));
        Env.setContext(this.m_printCtx, "#AD_Language", this.m_format.getLanguage().getAD_Language());
        if (this.m_hasLayout && doLayout) {
            this.layout();
        }
    }

    public void setPrintData(PrintData data, MQuery query, boolean doLayout) {
        this.m_data = data;
        this.m_query = query;
        if (this.m_hasLayout && doLayout) {
            this.layout();
        }
    }

    public void setPrintData(PrintData data, MQuery query, boolean doLayout, String trxName) {
        this.m_data = data;
        this.m_query = query;
        this.m_TrxName = trxName;
        if (this.m_hasLayout && doLayout) {
            this.layout();
        }
    }

    public void setPaper(CPaper paper) {
        this.setPaper(paper, this.m_headerHeight, this.m_footerHeight);
    }

    public void setPaper(CPaper paper, int headerHeight, int footerHeight) {
        boolean paperChange;
        if (paper == null) {
            return;
        }
        boolean bl = paperChange = headerHeight != this.m_headerHeight || footerHeight != this.m_footerHeight;
        if (!paperChange) {
            boolean bl2 = paperChange = !paper.equals(this.m_paper);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(paper) + " - Header=" + headerHeight + ", Footer=" + footerHeight);
        }
        this.m_paper = paper;
        this.m_headerHeight = headerHeight;
        this.m_footerHeight = footerHeight;
        this.calculatePageSize();
        if (this.m_hasLayout && paperChange) {
            this.layout();
        }
    }

    public void pageSetupDialog(PrinterJob job) {
        log.info("");
        if (this.m_paper.pageSetupDialog(job)) {
            this.setPaper(this.m_paper);
            this.layout();
        }
    }

    protected void setPageFormat(PageFormat pf) {
        if (pf != null) {
            this.setPaper(new CPaper(pf));
        } else {
            this.setPaper(null);
        }
    }

    public PageFormat getPageFormat() {
        return this.m_paper.getPageFormat();
    }

    private void calculatePageSize() {
        int x = (int)this.m_paper.getImageableX(true);
        int w = (int)this.m_paper.getImageableWidth(true);
        int y = (int)this.m_paper.getImageableY(true);
        int h = (int)this.m_paper.getImageableHeight(true);
        int height = this.m_headerHeight;
        this.m_header.setBounds(x, y, w, height);
        y += height;
        height = h - this.m_headerHeight - this.m_footerHeight;
        this.m_content.setBounds(x, y, w, height);
        y += height;
        height = this.m_footerHeight;
        this.m_footer.setBounds(x, y, w, height);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Paper=" + String.valueOf(this.m_paper) + ",HeaderHeight=" + this.m_headerHeight + ",FooterHeight=" + this.m_footerHeight + " => Header=" + String.valueOf(this.m_header) + ",Contents=" + String.valueOf(this.m_content) + ",Footer=" + String.valueOf(this.m_footer));
        }
    }

    public CPaper getPaper() {
        return this.m_paper;
    }

    private void layout() {
        this.m_headerFooter = new HeaderFooter(this.m_printCtx);
        if (!this.m_format.isForm()) {
            if (this.m_format.isStandardHeaderFooter()) {
                StandardHeaderFooter headerFooter = new StandardHeaderFooter();
                headerFooter.createHeaderFooter(this.m_format, this.m_headerFooter, this.m_header, this.m_footer, this.m_query);
            } else if (this.m_format.getAD_PrintHeaderFooter_ID() > 0) {
                IPrintHeaderFooter printHeaderFooter = Core.getPrintHeaderFooter(this.m_format.getAD_PrintHeaderFooter());
                if (printHeaderFooter != null) {
                    printHeaderFooter.createHeaderFooter(this.m_format, this.m_headerFooter, this.m_header, this.m_footer, this.m_query);
                } else if (log.isLoggable(Level.WARNING)) {
                    log.warning("Print Header/Footer not found, AD_PrintHeaderFooter_ID=" + this.m_format.getAD_PrintHeaderFooter_ID());
                }
            }
        }
        this.m_pageNo = 0;
        this.m_pages.clear();
        this.m_tableElement = null;
        this.newPage(true, false);
        if (this.m_format.isForm()) {
            this.layoutForm();
        } else {
            PrintElement element = this.layoutParameter();
            if (element != null) {
                this.m_currPage.addElement(element);
                element.setLocation(this.m_position[1]);
                this.m_position[1].y += (double)(element.getHeight() + 5.0f);
            }
            if ((element = this.layoutPInstanceLogs()) != null) {
                this.m_currPage.addElement(element);
                element.setLocation(this.m_position[1]);
                this.m_position[1].y += (double)(element.getHeight() + 5.0f);
            }
            if (this.m_data != null) {
                element = this.layoutTable(this.m_format, this.m_data, 0);
                element.setLocation(this.m_content.getLocation());
                int p2 = 1;
                while (p2 <= element.getPageCount()) {
                    if (p2 != 1) {
                        this.newPage(true, false);
                    }
                    this.m_currPage.addElement(element);
                    ++p2;
                }
            }
        }
        String pageInfo = String.valueOf(this.m_pages.size()) + this.getPageInfo(this.m_pages.size());
        Env.setContext(this.m_printCtx, "*PageCount", pageInfo);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Env.setContext(this.m_printCtx, "*CurrentDate", DisplayType.getDateFormat(15, this.m_format.getLanguage()).format(now));
        Env.setContext(this.m_printCtx, "*CurrentDateTime", DisplayType.getDateFormat(16, this.m_format.getLanguage()).format(now));
        Image image = null;
        MPrintTableFormat tf = this.m_format.getTableFormat();
        MTable table2 = MTable.get(this.getCtx(), this.getPrintInfo().getAD_Table_ID());
        if (table2.getColumn("IsPrinted") != null && !table2.isView()) {
            String tableName = table2.getTableName();
            String sql = "SELECT IsPrinted FROM " + tableName + " WHERE " + tableName + "_ID=?";
            boolean isPrinted = "Y".equals(DB.getSQLValueStringEx(this.m_TrxName, sql, this.getPrintInfo().getRecord_ID()));
            if (isPrinted) {
                image = tf.getImageWaterMark();
            }
        } else {
            image = tf.getImage();
        }
        int pages = this.m_pages.size();
        int i2 = 0;
        while (i2 < pages) {
            Page page = this.m_pages.get(i2);
            int pageNo = page.getPageNo();
            pageInfo = String.valueOf(pageNo) + this.getPageInfo(pageNo);
            page.setPageInfo(pageInfo);
            page.setPageCount(pages);
            page.setBackgroundImage(image);
            ++i2;
        }
        this.m_hasLayout = true;
    }

    public Properties getCtx() {
        return this.m_printCtx;
    }

    public int getColumnCount() {
        return this.m_columnCount;
    }

    protected void setArea(int area) {
        if (this.m_area == area) {
            return;
        }
        if (area < 0 || area > 2) {
            throw new ArrayIndexOutOfBoundsException(area);
        }
        this.m_area = area;
    }

    public int getArea() {
        return this.m_area;
    }

    public Rectangle getAreaBounds() {
        Rectangle part = this.m_content;
        if (this.m_area == 0) {
            part = this.m_header;
        } else if (this.m_area == 2) {
            part = this.m_footer;
        }
        return part;
    }

    protected int newPage(boolean force, boolean preserveXPos) {
        if (!force && this.m_position[1].getX() == (double)this.m_content.x && this.m_position[1].getY() == (double)this.m_content.y) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("skipped");
            }
            return this.m_pageNo;
        }
        ++this.m_pageNo;
        this.m_currPage = new Page(this.m_printCtx, this.m_pageNo);
        this.m_pages.add(this.m_currPage);
        this.m_position[0].setLocation(this.m_header.x, this.m_header.y);
        if (preserveXPos) {
            this.m_position[1].setLocation(this.m_position[1].x, this.m_content.y);
        } else {
            this.m_position[1].setLocation(this.m_content.x, this.m_content.y);
        }
        this.m_position[2].setLocation(this.m_footer.x, this.m_footer.y);
        this.m_maxHeightSinceNewLine = new float[]{0.0f, 0.0f, 0.0f};
        if (log.isLoggable(Level.FINER)) {
            log.finer("Page=" + this.m_pageNo);
        }
        return this.m_pageNo;
    }

    protected void newLine() {
        Rectangle part = this.m_content;
        if (this.m_area == 0) {
            part = this.m_header;
        } else if (this.m_area == 2) {
            part = this.m_footer;
        }
        int xPos = part.x;
        if (this.m_tempNLPositon != 0) {
            xPos = this.m_tempNLPositon;
        }
        if (this.isYspaceFor(this.m_maxHeightSinceNewLine[this.m_area])) {
            this.m_position[this.m_area].setLocation(xPos, this.m_position[this.m_area].y + (double)this.m_maxHeightSinceNewLine[this.m_area]);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
            }
        } else if (this.m_area == 1) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Not enough Y space " + this.m_lastHeight[this.m_area] + " - remaining " + this.getYspace() + " - Area=" + this.m_area);
            }
            this.newPage(true, false);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
            }
        } else {
            this.m_position[this.m_area].setLocation(part.x, this.m_position[this.m_area].y + (double)this.m_maxHeightSinceNewLine[this.m_area]);
            log.log(Level.SEVERE, "Outside of Area(" + this.m_area + "): " + String.valueOf(this.m_position[this.m_area]));
        }
        this.m_maxHeightSinceNewLine[this.m_area] = 0.0f;
    }

    public int getPageNo() {
        return this.m_pageNo;
    }

    public Page getPage(int pageNo) {
        if (pageNo <= 0 || pageNo > this.m_pages.size()) {
            log.log(Level.SEVERE, "No page #" + pageNo);
            return null;
        }
        Page retValue = this.m_pages.get(pageNo - 1);
        return retValue;
    }

    public ArrayList<Page> getPages() {
        return this.m_pages;
    }

    public HeaderFooter getHeaderFooter() {
        return this.m_headerFooter;
    }

    protected void setPage(int pageNo) {
        Page retValue;
        if (pageNo <= 0 || pageNo > this.m_pages.size()) {
            log.log(Level.SEVERE, "No page #" + pageNo);
            return;
        }
        this.m_currPage = retValue = this.m_pages.get(pageNo - 1);
    }

    public String getPageInfo(int pageNo) {
        if (this.m_tableElement == null || this.m_tableElement.getPageXCount() == 1) {
            return "";
        }
        int pi = this.m_tableElement.getPageIndex(pageNo);
        StringBuilder sb = new StringBuilder("(");
        sb.append(this.m_tableElement.getPageYIndex(pi) + 1).append(",").append(this.m_tableElement.getPageXIndex(pi) + 1).append(")");
        return sb.toString();
    }

    public String getPageInfoMax() {
        if (this.m_tableElement == null || this.m_tableElement.getPageXCount() == 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder("(");
        sb.append(this.m_tableElement.getPageYCount()).append(",").append(this.m_tableElement.getPageXCount()).append(")");
        return sb.toString();
    }

    public MPrintFormat getFormat() {
        return this.m_format;
    }

    public LayoutEngine getPageable(boolean isCopy) {
        this.setCopy(isCopy);
        if (this.getNumberOfPages() == 0 || !ArchiveEngine.isValid(this)) {
            log.warning("Nothing to print - " + this.toString());
            return null;
        }
        return this;
    }

    protected void setRelativePosition(Point2D p2) {
        if (p2 == null) {
            return;
        }
        Rectangle part = this.m_content;
        if (this.m_area == 0) {
            part = this.m_header;
        } else if (this.m_area == 2) {
            part = this.m_footer;
        }
        this.m_position[this.m_area].setLocation((double)part.x + p2.getX(), (double)part.y + p2.getY());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
        }
    }

    protected void setRelativePosition(float x, float y) {
        this.setRelativePosition(new Point2D.Float(x, y));
    }

    public Point2D getPosition() {
        return this.m_position[this.m_area];
    }

    protected void setX(float x) {
        this.m_position[this.m_area].x = x;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
        }
    }

    protected void addX(float xOffset) {
        if (xOffset == 0.0f) {
            return;
        }
        this.m_position[this.m_area].x += (double)xOffset;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
        }
    }

    public float getX() {
        return (float)this.m_position[this.m_area].x;
    }

    protected void setY(int y) {
        this.m_position[this.m_area].y = y;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
        }
    }

    protected void addY(int yOffset) {
        if ((float)yOffset == 0.0f) {
            return;
        }
        if (this.isYspaceFor(yOffset)) {
            this.m_position[this.m_area].y += (double)yOffset;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
            }
        } else if (this.m_area == 1) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Not enough Y space " + this.m_lastHeight[this.m_area] + " - remaining " + this.getYspace() + " - Area=" + this.m_area);
            }
            this.newPage(true, true);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Page=" + this.m_pageNo + " [" + this.m_area + "] " + this.m_position[this.m_area].x + "/" + this.m_position[this.m_area].y);
            }
        } else {
            this.m_position[this.m_area].y += (double)yOffset;
            log.log(Level.SEVERE, "Outside of Area: " + String.valueOf(this.m_position));
        }
    }

    public float getY() {
        return (float)this.m_position[this.m_area].y;
    }

    public float getXspace() {
        Rectangle part = this.m_content;
        if (this.m_area == 0) {
            part = this.m_header;
        } else if (this.m_area == 2) {
            part = this.m_footer;
        }
        return (float)((double)(part.x + part.width) - this.m_position[this.m_area].x);
    }

    public boolean isXspaceFor(float width) {
        return this.getXspace() - width >= 0.0f;
    }

    public float getYspace() {
        Rectangle part = this.m_content;
        if (this.m_area == 0) {
            part = this.m_header;
        } else if (this.m_area == 2) {
            part = this.m_footer;
        }
        return (float)((double)(part.y + part.height) - this.m_position[this.m_area].y);
    }

    public boolean isYspaceFor(float height) {
        return this.getYspace() - height >= 0.0f;
    }

    private void layoutForm() {
        this.m_columnCount = 0;
        if (this.m_data == null) {
            return;
        }
        int rowCount = this.m_data.getRowCount();
        int row = 0;
        while (row < rowCount) {
            if (log.isLoggable(Level.INFO)) {
                log.info("Row=" + row);
            }
            this.m_data.setRowIndex(row);
            if (row > 0 && this.m_format.isBreakPagePerRecord()) {
                this.newPage(true, false);
            }
            boolean somethingPrinted = true;
            int i2 = 0;
            while (i2 < this.m_format.getItemCount()) {
                MPrintFormatItem item = this.m_format.getItem(i2);
                if (item.isPrinted()) {
                    ++this.m_columnCount;
                    if (row <= 0 || !item.isHeader() && !item.isFooter()) {
                        if (item.isHeader()) {
                            this.setArea(0);
                        } else if (item.isFooter()) {
                            this.setArea(2);
                        } else {
                            this.setArea(1);
                        }
                        if (item.isSetNLPosition() && item.isRelativePosition()) {
                            this.m_tempNLPositon = 0;
                        }
                        if (item.isNextLine() && somethingPrinted) {
                            this.newLine();
                            somethingPrinted = false;
                        } else {
                            this.addX(this.m_lastWidth[this.m_area]);
                        }
                        if (item.isNextPage()) {
                            this.newPage(false, false);
                        }
                        if (item.isRelativePosition()) {
                            this.addX(item.getXSpace());
                            this.addY(item.getYSpace());
                        } else {
                            this.setRelativePosition(item.getXPosition(), item.getYPosition());
                        }
                        if (item.isSetNLPosition() && !item.isRelativePosition()) {
                            this.m_tempNLPositon = (int)this.getPosition().getX();
                        }
                        String alignment = item.getFieldAlignmentType();
                        int maxWidth = item.getMaxWidth();
                        boolean lineAligned = false;
                        if (item.isRelativePosition()) {
                            if (item.isLineAlignLeading()) {
                                alignment = "L";
                                maxWidth = this.getAreaBounds().width;
                                lineAligned = true;
                            } else if (item.isLineAlignCenter()) {
                                alignment = "C";
                                maxWidth = this.getAreaBounds().width;
                                lineAligned = true;
                            } else if (item.isLineAlignTrailing()) {
                                alignment = "T";
                                maxWidth = this.getAreaBounds().width;
                                lineAligned = true;
                            }
                        }
                        PrintElement element = null;
                        if (PrintDataEvaluatee.hasPageLogic(item.getDisplayLogic()) || this.isDisplayed(this.m_data, item)) {
                            if (item.isTypePrintFormat()) {
                                element = this.includeFormat(item, this.m_data);
                            } else if (item.isBarcode()) {
                                element = this.createBarcodeElement(item, this.m_data);
                                if (element != null) {
                                    element.layout(maxWidth, item.getMaxHeight(), false, alignment);
                                }
                            } else if (item.isTypeImage()) {
                                element = item.isImageField() ? this.createImageElement(item, this.m_data) : (item.isImageIsAttached() ? ImageElement.get(item.get_ID()) : ImageElement.get(item.getImageURL()));
                                if (element != null) {
                                    element.layout(maxWidth, item.getMaxHeight(), false, alignment);
                                }
                            } else if (item.isTypeField()) {
                                if (maxWidth == 0 && item.isFieldAlignBlock()) {
                                    maxWidth = this.getAreaBounds().width;
                                }
                                element = this.createFieldElement(item, maxWidth, alignment, this.m_format.isForm());
                            } else if (item.isTypeBox()) {
                                if (this.m_format.isForm()) {
                                    element = this.createBoxElement(item);
                                }
                                if (element != null && maxWidth == 0) {
                                    maxWidth = this.getAreaBounds().width;
                                    element.setMaxWidth(maxWidth);
                                }
                            } else if (item.getPrintFormatType().equals("S")) {
                                element = this.createFieldElement(item, maxWidth, alignment, this.m_format.isForm());
                            } else {
                                int summaryTagEnd;
                                String printName = item.getPrintName(this.m_format.getLanguage());
                                int summaryTagStart = printName == null ? -1 : printName.indexOf("<s>");
                                int n = summaryTagEnd = summaryTagStart >= 0 ? printName.indexOf("</s>", summaryTagStart) : -1;
                                if (summaryTagStart >= 0 && summaryTagEnd > summaryTagStart) {
                                    if (this.m_data.isFunctionRow(row) && row + 1 == rowCount) {
                                        printName = printName.substring(summaryTagStart + 3);
                                        printName = printName.substring(0, printName.length() - 4);
                                    } else {
                                        printName = printName.substring(0, summaryTagStart);
                                    }
                                }
                                if (maxWidth == 0 && item.isFieldAlignBlock()) {
                                    maxWidth = this.getAreaBounds().width;
                                }
                                element = this.createStringElement(printName, item.getAD_PrintColor_ID(), item.getAD_PrintFont_ID(), maxWidth, item.getMaxHeight(), item.isHeightOneLine(), alignment, true);
                            }
                        }
                        if (element != null) {
                            somethingPrinted = true;
                            if (!lineAligned) {
                                this.m_lastWidth[this.m_area] = element.getWidth();
                            }
                            this.m_lastHeight[this.m_area] = element.getHeight();
                        } else {
                            somethingPrinted = false;
                            this.m_lastWidth[this.m_area] = 0.0f;
                            this.m_lastHeight[this.m_area] = 0.0f;
                            if (item.isRelativePosition()) {
                                this.addX(-item.getXSpace());
                                this.addY(-item.getYSpace());
                            }
                        }
                        if (item.isRelativePosition() && !lineAligned) {
                            if (!this.isXspaceFor(this.m_lastWidth[this.m_area])) {
                                if (log.isLoggable(Level.FINEST)) {
                                    log.finest("Not enough X space for " + this.m_lastWidth[this.m_area] + " - remaining " + this.getXspace() + " - Area=" + this.m_area);
                                }
                                this.newLine();
                            }
                            if (this.m_area == 1 && !this.isYspaceFor(this.m_lastHeight[this.m_area])) {
                                if (log.isLoggable(Level.FINEST)) {
                                    log.finest("Not enough Y space " + this.m_lastHeight[this.m_area] + " - remaining " + this.getYspace() + " - Area=" + this.m_area);
                                }
                                this.newPage(true, true);
                            }
                        }
                        if (element != null) {
                            element.setLocation(this.m_position[this.m_area]);
                        }
                        if (this.m_area == 1) {
                            this.m_currPage.addElement(element);
                        } else {
                            this.m_headerFooter.addElement(element);
                        }
                        if (PrintDataEvaluatee.hasPageLogic(item.getDisplayLogic())) {
                            element.setPrintData(this.m_data);
                            element.setRowIndex(row);
                            element.setPageLogic(item.getDisplayLogic());
                        }
                        if (this.m_lastHeight[this.m_area] > this.m_maxHeightSinceNewLine[this.m_area]) {
                            this.m_maxHeightSinceNewLine[this.m_area] = this.m_lastHeight[this.m_area];
                        }
                        if (!item.isRelativePosition()) {
                            this.m_maxHeightSinceNewLine[this.m_area] = this.m_lastHeight[this.m_area];
                        }
                    }
                }
                ++i2;
            }
            ++row;
        }
    }

    private PrintElement includeFormat(MPrintFormatItem item, PrintData data) {
        DataEngine de;
        PrintData includedData;
        Object obj;
        this.newLine();
        PrintElement element = null;
        if (item.getAD_PrintFormatChild_ID() <= 0) {
            log.log(Level.SEVERE, "Included format not configured. AD_PrintFormat_ID = " + item.getAD_PrintFormat_ID() + ", AD_PrintFormatItem_ID=" + item.getAD_PrintFormatItem_ID());
            return element;
        }
        MPrintFormat format = MPrintFormat.get(this.getCtx(), item.getAD_PrintFormatChild_ID(), false);
        format.setLanguage(this.m_format.getLanguage());
        if (this.m_format.isTranslationView()) {
            format.setTranslationLanguage(this.m_format.getLanguage());
        }
        int AD_Column_ID = item.getAD_Column_ID();
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(format) + " - Item=" + item.getName() + " (" + AD_Column_ID + ")");
        }
        if ((obj = data.getNodeByPrintFormatItemId(item.getAD_PrintFormatItem_ID())) == null) {
            data.dumpHeader();
            data.dumpCurrentRow();
            log.log(Level.SEVERE, "No Node - AD_Column_ID=" + AD_Column_ID + " - " + String.valueOf(item) + " - " + String.valueOf(data));
            return null;
        }
        PrintDataElement dataElement = (PrintDataElement)obj;
        String recordString = dataElement.getValueKey();
        if (recordString == null || recordString.length() == 0) {
            data.dumpHeader();
            data.dumpCurrentRow();
            log.log(Level.SEVERE, "No Record Key - " + String.valueOf(dataElement) + " - AD_Column_ID=" + AD_Column_ID + " - " + String.valueOf(item));
            return null;
        }
        MQuery query = new MQuery(format.getAD_Table_ID());
        if (Util.isUUID(recordString)) {
            query.addRestriction(item.getColumnName(), "=", (Object)recordString);
        } else {
            int Record_ID = 0;
            try {
                Record_ID = Integer.parseInt(recordString);
            }
            catch (Exception e) {
                data.dumpCurrentRow();
                log.log(Level.SEVERE, "Invalid Record Key - " + recordString + " (" + e.getMessage() + ") - AD_Column_ID=" + AD_Column_ID + " - " + String.valueOf(item));
                return null;
            }
            query.addRestriction(item.getColumnName(), "=", (Object)Record_ID);
        }
        format.setTranslationViewQuery(query);
        if (log.isLoggable(Level.FINE)) {
            log.fine(query.toString());
        }
        if ((includedData = (de = new DataEngine(format.getLanguage(), this.m_TrxName, this.m_windowNo)).getPrintData(data.getCtx(), format, query)) == null) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(includedData.toString());
        }
        this.setChildPrintFormatDetails(item, includedData);
        element = this.layoutTable(format, includedData, item.getXSpace());
        if (element.getPageCount() > 1) {
            Point2D.Double loc = this.m_position[this.m_area];
            element.setLocation(loc);
            int p2 = 1;
            while (p2 < element.getPageCount()) {
                this.m_currPage.addElement(element);
                this.newPage(true, false);
                ++p2;
            }
            this.m_position[this.m_area] = loc;
            ((TableElement)element).setHeightToLastPage();
        }
        this.m_lastWidth[this.m_area] = element.getWidth();
        this.m_lastHeight[this.m_area] = element.getHeight();
        if (!this.isXspaceFor(this.m_lastWidth[this.m_area])) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Not enough X space for " + this.m_lastWidth[this.m_area] + " - remaining " + this.getXspace() + " - Area=" + this.m_area);
            }
            this.newLine();
        }
        if (this.m_area == 1 && !this.isYspaceFor(this.m_lastHeight[this.m_area])) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Not enough Y space " + this.m_lastHeight[this.m_area] + " - remaining " + this.getYspace() + " - Area=" + this.m_area);
            }
            this.newPage(true, false);
        }
        return element;
    }

    private PrintElement createStringElement(String content, int AD_PrintColor_ID, int AD_PrintFont_ID, int maxWidth, int maxHeight, boolean isHeightOneLine, String FieldAlignmentType, boolean isTranslated) {
        MPrintFont f;
        MPrintColor c;
        if (content == null || content.length() == 0) {
            return null;
        }
        Color color = this.getColor();
        if (AD_PrintColor_ID != 0 && this.m_printColor.get_ID() != AD_PrintColor_ID && (c = MPrintColor.get(this.getCtx(), AD_PrintColor_ID)).getColor() != null) {
            color = c.getColor();
        }
        Font font = this.m_printFont.getFont();
        if (AD_PrintFont_ID != 0 && this.m_printFont.get_ID() != AD_PrintFont_ID && (f = MPrintFont.get(AD_PrintFont_ID)).getFont() != null) {
            font = f.getFont();
        }
        StringElement e = new StringElement(content, font, color, null, isTranslated);
        e.layout(maxWidth, maxHeight, isHeightOneLine, FieldAlignmentType);
        return e;
    }

    private PrintElement createFieldElement(MPrintFormatItem item, int maxWidth, String FieldAlignmentType, boolean isForm) {
        MPrintFont f;
        MPrintColor c;
        Object obj = this.m_data.getNodeByPrintFormatItemId(item.getAD_PrintFormatItem_ID());
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof PrintDataElement)) {
            log.log(Level.SEVERE, "Element not PrintDataElement " + String.valueOf(obj.getClass()));
            return null;
        }
        PrintDataElement data = (PrintDataElement)obj;
        if (data.isNull() && item.isSuppressNull()) {
            return null;
        }
        String stringContent = data.getValueDisplay(this.m_format.getLanguage());
        if ((stringContent == null || stringContent.length() == 0) && item.isSuppressNull()) {
            return null;
        }
        Object content = stringContent;
        if (data.getValue() instanceof Boolean) {
            content = data.getValue();
        }
        if ("AmtInWords".equals(item.getColumnName())) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("AmtInWords: " + stringContent);
            }
            stringContent = Msg.getAmtInWords(this.m_format.getLanguage(), stringContent);
            content = stringContent;
        }
        String label = item.getPrintName(this.m_format.getLanguage());
        String labelSuffix = item.getPrintNameSuffix(this.m_format.getLanguage());
        NamePair ID = null;
        if (data.isID()) {
            Object value = data.getValue();
            if (value instanceof KeyNamePair) {
                ID = new KeyNamePair(((KeyNamePair)value).getKey(), item.getColumnName());
            } else if (value instanceof ValueNamePair) {
                ID = new ValueNamePair(((ValueNamePair)value).getValue(), item.getColumnName());
            }
        } else if ("D".equals(FieldAlignmentType)) {
            FieldAlignmentType = data.isNumeric() ? "T" : "L";
        }
        Color color = this.getColor();
        if ((ID == null || isForm) && item.getAD_PrintColor_ID() != 0 && this.m_printColor.get_ID() != item.getAD_PrintColor_ID() && (c = MPrintColor.get(this.getCtx(), item.getAD_PrintColor_ID())).getColor() != null) {
            color = c.getColor();
        }
        Font font = this.m_printFont.getFont();
        if (item.getAD_PrintFont_ID() != 0 && this.m_printFont.get_ID() != item.getAD_PrintFont_ID() && (f = MPrintFont.get(item.getAD_PrintFont_ID())).getFont() != null) {
            font = f.getFont();
        }
        PrintElement e = null;
        if (data.getDisplayType() == 21) {
            e = new LocationElement(this.m_printCtx, ((KeyNamePair)ID).getKey(), font, color, item.isHeightOneLine(), label, labelSuffix, this.m_format.getLanguage().getAD_Language());
            e.layout(maxWidth, item.getMaxHeight(), item.isHeightOneLine(), FieldAlignmentType);
        } else {
            e = HTMLElement.isHTML(stringContent) ? new HTMLElement(stringContent) : new StringElement(content, font, color, isForm ? null : ID, label, labelSuffix);
            e.layout(maxWidth, item.getMaxHeight(), item.isHeightOneLine(), FieldAlignmentType);
        }
        return e;
    }

    private PrintElement createBoxElement(MPrintFormatItem item) {
        MPrintColor c;
        Color color = this.getColor();
        if (item.getAD_PrintColor_ID() != 0 && this.m_printColor.get_ID() != item.getAD_PrintColor_ID() && (c = MPrintColor.get(this.getCtx(), item.getAD_PrintColor_ID())).getColor() != null) {
            color = c.getColor();
        }
        return new BoxElement(item, color);
    }

    private PrintElement createImageElement(MPrintFormatItem item, PrintData printData) {
        Object obj = printData.getNodeByPrintFormatItem(item);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof PrintDataElement)) {
            log.log(Level.SEVERE, "Element not PrintDataElement " + String.valueOf(obj.getClass()));
            return null;
        }
        PrintDataElement data = (PrintDataElement)obj;
        if (data.isNull() && item.isSuppressNull()) {
            return null;
        }
        String url = data.getValueDisplay(this.m_format.getLanguage());
        if (url == null || url.length() == 0) {
            if (item.isSuppressNull()) {
                return null;
            }
            return null;
        }
        ImageElement element = null;
        element = data.getDisplayType() == 32 ? ImageElement.get(data, url) : ImageElement.get(url);
        return element;
    }

    private PrintElement createBarcodeElement(MPrintFormatItem item, PrintData printData) {
        Object obj = printData.getNodeByPrintFormatItem(item);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof PrintDataElement)) {
            log.log(Level.SEVERE, "Element not PrintDataElement " + String.valueOf(obj.getClass()));
            return null;
        }
        PrintDataElement data = (PrintDataElement)obj;
        if (data.isNull() && item.isSuppressNull()) {
            return null;
        }
        String stringContent = data.getValueDisplay(this.m_format.getLanguage());
        if ((stringContent == null || stringContent.length() == 0) && item.isSuppressNull()) {
            return null;
        }
        BarcodeElement element = new BarcodeElement(stringContent, item);
        if (element.isValid()) {
            return element;
        }
        return null;
    }

    public Color getColor() {
        if (this.m_printColor == null) {
            return Color.BLACK;
        }
        return this.m_printColor.getColor();
    }

    private PrintElement layoutTable(MPrintFormat format, PrintData printData, int xOffset) {
        if (log.isLoggable(Level.INFO)) {
            log.info(format.getName() + " - " + printData.getName());
        }
        MPrintTableFormat tf = format.getTableFormat();
        HashMap<Point, Font> rowColFont = new HashMap<Point, Font>();
        MPrintFont printFont = MPrintFont.get(format.getAD_PrintFont_ID());
        rowColFont.put(new Point(-1, -1), printFont.getFont());
        tf.setStandard_Font(printFont.getFont());
        rowColFont.put(new Point(-2, -1), tf.getHeader_Font());
        HashMap<Point, Color> rowColColor = new HashMap<Point, Color>();
        MPrintColor printColor = MPrintColor.get(this.getCtx(), format.getAD_PrintColor_ID());
        rowColColor.put(new Point(-1, -1), printColor.getColor());
        rowColColor.put(new Point(-2, -1), tf.getHeaderFG_Color());
        HashMap<Point, Color> rowColBackground = new HashMap<Point, Color>();
        rowColBackground.put(new Point(-2, -1), tf.getHeaderBG_Color());
        HashMap<Point, MReportLine> rowColReportLine = new HashMap<Point, MReportLine>();
        HashMap<String, Integer> colPositions = new HashMap<String, Integer>();
        boolean multiLineHeader = tf.isMultiLineHeader();
        int pageNoStart = this.m_pageNo;
        int repeatedColumns = 1;
        Rectangle firstPage = new Rectangle(this.m_content);
        firstPage.x += xOffset;
        firstPage.width -= xOffset;
        int yOffset = (int)this.m_position[1].y - this.m_content.y;
        firstPage.y += yOffset;
        firstPage.height -= yOffset;
        Rectangle nextPages = new Rectangle(this.m_content);
        nextPages.x += xOffset;
        nextPages.width -= xOffset;
        ArrayList<Integer> instanceAttributeList = new ArrayList<Integer>();
        ArrayList<MPrintFormatItem> instanceAttributeItems = new ArrayList<MPrintFormatItem>();
        int columnCount = 0;
        int c = 0;
        while (c < format.getItemCount()) {
            if (format.getItem(c).isPrinted()) {
                if (format.getItem(c).isTypeField() && format.getItem(c).isPrintInstanceAttributes()) {
                    instanceAttributeList.add(columnCount);
                    instanceAttributeItems.add(format.getItem(c));
                } else {
                    ++columnCount;
                }
            }
            ++c;
        }
        ValueNamePair[] columnHeader = new ValueNamePair[columnCount];
        int[] columnMaxWidth = new int[columnCount];
        int[] columnMaxHeight = new int[columnCount];
        boolean[] fixedWidth = new boolean[columnCount];
        Boolean[] colSuppressRepeats = new Boolean[columnCount];
        String[] columnJustification = new String[columnCount];
        HashMap<Integer, Integer> additionalLines = new HashMap<Integer, Integer>();
        ArrayList<String> pageLogics = new ArrayList<String>();
        boolean hasPageLogic = false;
        int col = 0;
        int c2 = 0;
        while (c2 < format.getItemCount()) {
            MPrintFormatItem item = format.getItem(c2);
            if (!instanceAttributeItems.contains(item) && item.isPrinted()) {
                if (item.isNextLine() && item.getBelowColumn() != 0) {
                    additionalLines.put(col, item.getBelowColumn() - 1);
                    if (!item.isSuppressNull()) {
                        if (item.is_Immutable()) {
                            item = new MPrintFormatItem(item);
                        }
                        item.setIsSuppressNull(true);
                        item.saveCrossTenantSafeEx();
                        CacheMgt.get().reset("AD_PrintFormat", format.get_ID());
                    }
                }
                columnHeader[col] = new ValueNamePair(item.getColumnName(), item.getPrintName(format.getLanguage()));
                colPositions.put(item.getPrintName(), col);
                columnMaxWidth[col] = item.getMaxWidth();
                fixedWidth[col] = columnMaxWidth[col] != 0 && item.isFixedWidth();
                colSuppressRepeats[col] = item.isSuppressRepeats();
                if (item.isSuppressNull()) {
                    if (columnMaxWidth[col] == 0) {
                        columnMaxWidth[col] = -1;
                    } else {
                        int n = col;
                        columnMaxWidth[n] = columnMaxWidth[n] * -1;
                    }
                }
                columnMaxHeight[col] = item.getMaxHeight();
                if (item.isHeightOneLine()) {
                    columnMaxHeight[col] = -1;
                }
                columnJustification[col] = item.getFieldAlignmentType();
                if (columnJustification[col] == null || columnJustification[col].equals("D")) {
                    columnJustification[col] = "L";
                }
                if (item.getAD_PrintFont_ID() != 0 && item.getAD_PrintFont_ID() != format.getAD_PrintFont_ID()) {
                    MPrintFont font = MPrintFont.get(item.getAD_PrintFont_ID());
                    rowColFont.put(new Point(-1, col), font.getFont());
                }
                if (item.getAD_PrintColor_ID() != 0 && item.getAD_PrintColor_ID() != format.getAD_PrintColor_ID()) {
                    MPrintColor color = MPrintColor.get(this.getCtx(), item.getAD_PrintColor_ID());
                    rowColColor.put(new Point(-1, col), color.getColor());
                }
                if (PrintDataEvaluatee.hasPageLogic(item.getDisplayLogic())) {
                    pageLogics.add(item.getDisplayLogic());
                    hasPageLogic = true;
                } else {
                    pageLogics.add(null);
                }
                ++col;
            }
            ++c2;
        }
        int rows = printData.getRowCount();
        SerializableMatrixImpl<Serializable> elements = new SerializableMatrixImpl<Serializable>(this.m_PrintInfo.getName());
        KeyNamePair[] pk = new KeyNamePair[rows];
        String pkColumnName = null;
        ArrayList<Integer> functionRows = new ArrayList<Integer>();
        ArrayList<Integer> pageBreak = new ArrayList<Integer>();
        ArrayList<Integer> finReportSumRows = new ArrayList<Integer>();
        int lastLevelNo = 0;
        int row = 0;
        while (row < rows) {
            int levelNo = 0;
            ArrayList<PrintElement> columns = new ArrayList<PrintElement>();
            printData.setRowIndex(row);
            if (printData.isFunctionRow()) {
                functionRows.add(row);
                rowColFont.put(new Point(row, -1), tf.getFunct_Font());
                rowColColor.put(new Point(row, -1), tf.getFunctFG_Color());
                rowColBackground.put(new Point(row, -1), tf.getFunctBG_Color());
                if (printData.isPageBreak()) {
                    pageBreak.add(row);
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("PageBreak row=" + row);
                    }
                }
            } else {
                levelNo = printData.getLineLevelNo();
                if (levelNo < 0) {
                    levelNo = -levelNo;
                }
                if (levelNo < lastLevelNo) {
                    finReportSumRows.add(row);
                }
                if (levelNo != 0) {
                    Font base = printFont.getFont();
                    if (levelNo == 1) {
                        rowColFont.put(new Point(row, -1), new Font(base.getName(), 2, base.getSize() - levelNo));
                    } else if (levelNo == 2) {
                        rowColFont.put(new Point(row, -1), new Font(base.getName(), 0, base.getSize() - levelNo));
                    }
                }
                lastLevelNo = levelNo;
            }
            MReportLine rLine = printData.getMReportLine();
            int c3 = 0;
            while (c3 < format.getItemCount()) {
                Object columnElement = null;
                MPrintFormatItem item = format.getItem(c3);
                if (!instanceAttributeItems.contains(item)) {
                    Object dataElement = null;
                    if (item.isPrinted()) {
                        if (rLine != null && levelNo == 0 && item.getColumnName().startsWith("Col_")) {
                            rowColReportLine.put(new Point(row, (Integer)colPositions.get(item.getPrintName())), rLine);
                        }
                        if (PrintDataEvaluatee.hasPageLogic(item.getDisplayLogic()) || this.isDisplayed(printData, item)) {
                            if (item.isTypeImage()) {
                                columnElement = item.isImageField() ? this.createImageElement(item, printData) : (item.isImageIsAttached() ? ImageElement.get(item.get_ID()) : ImageElement.get(item.getImageURL()));
                                if (columnElement != null) {
                                    ((PrintElement)columnElement).layout(item.getMaxWidth(), item.getMaxHeight(), false, item.getFieldAlignmentType());
                                }
                            } else if (item.isBarcode()) {
                                columnElement = this.createBarcodeElement(item, printData);
                                if (columnElement != null) {
                                    ((PrintElement)columnElement).layout(item.getMaxWidth(), item.getMaxHeight(), false, item.getFieldAlignmentType());
                                }
                            } else if (item.isTypeText()) {
                                columnElement = item.getPrintName(format.getLanguage());
                            } else if (item.isTypeField() || item.getPrintFormatType().equals("S")) {
                                Object obj = printData.getNodeByPrintFormatItem(item);
                                if (obj != null) {
                                    if (obj instanceof PrintDataElement) {
                                        PrintDataElement pde = (PrintDataElement)obj;
                                        dataElement = pde.isID() || pde.isYesNo() ? (Serializable)pde.getValue() : pde.getValueDisplay(format.getLanguage());
                                    } else {
                                        log.log(Level.SEVERE, "Element not PrintDataElement " + String.valueOf(obj.getClass()));
                                    }
                                }
                                columnElement = dataElement;
                            } else {
                                log.warning("Unsupported: " + (item.isTypeBox() ? "Box" : "PrintFormat") + " in Table: " + String.valueOf(item));
                            }
                        }
                        columns.add((PrintElement)columnElement);
                    }
                }
                ++c3;
            }
            elements.addRow(columns);
            PrintDataElement pde = printData.getPKey();
            if (pde != null) {
                pk[row] = (KeyNamePair)pde.getValue();
                if (pkColumnName == null) {
                    pkColumnName = pde.getColumnName();
                }
            }
            ++row;
        }
        ArrayList<InstanceAttributeData> asiElements = new ArrayList<InstanceAttributeData>();
        if (instanceAttributeList.size() > 0) {
            int i2 = 0;
            while (i2 < instanceAttributeItems.size()) {
                MPrintFormatItem item = (MPrintFormatItem)instanceAttributeItems.get(i2);
                int columnIndex = (Integer)instanceAttributeList.get(i2);
                InstanceAttributeData asiElement = new InstanceAttributeData(item, columnIndex);
                asiElement.readAttributesData(printData);
                asiElements.add(asiElement);
                ++i2;
            }
            int columnOffset = 0;
            for (InstanceAttributeData element : asiElements) {
                TableProperties tableProperties = new TableProperties(columnHeader, columnMaxWidth, columnMaxHeight, fixedWidth, colSuppressRepeats, columnJustification);
                int currentCount = columnHeader.length;
                element.updateTable(elements, tableProperties, columnOffset);
                columnHeader = tableProperties.getColumnHeader();
                columnMaxWidth = tableProperties.getColumnMaxWidth();
                columnMaxHeight = tableProperties.getColumnMaxHeight();
                fixedWidth = tableProperties.getFixedWidth();
                colSuppressRepeats = tableProperties.getColSuppressRepeats();
                columnJustification = tableProperties.getColumnJustification();
                columnOffset += columnHeader.length - currentCount;
            }
        }
        TableElement table2 = new TableElement(columnHeader, columnMaxWidth, columnMaxHeight, columnJustification, fixedWidth, functionRows, multiLineHeader, elements, pk, pkColumnName, pageNoStart, firstPage, nextPages, repeatedColumns, additionalLines, rowColFont, rowColColor, rowColBackground, tf, pageBreak, colSuppressRepeats, rowColReportLine, finReportSumRows);
        table2.layout(0.0f, 0.0f, false, "L");
        if (this.m_tableElement == null) {
            this.m_tableElement = table2;
        }
        if (format == this.m_format) {
            this.colSuppressRepeats = colSuppressRepeats;
        }
        if (hasPageLogic) {
            table2.setPageLogics(pageLogics);
            table2.setTablePrintData(printData);
        }
        return table2;
    }

    private PrintElement layoutParameter() {
        if (this.m_query == null || !this.m_query.isActive() || this.m_query.getReportProcessQuery() != null && !this.m_query.getReportProcessQuery().isActive()) {
            return null;
        }
        ParameterElement pe = new ParameterElement(this.m_query, this.m_printCtx, this.m_format.getTableFormat());
        pe.layout(0.0f, 0.0f, false, null);
        pe.fitToPage((int)this.getPaper().getImageableWidth(true));
        return pe;
    }

    private PrintElement layoutPInstanceLogs() {
        if (this.m_query == null || !this.m_query.isActive() || this.m_query.getAD_PInstance_ID() <= 0) {
            return null;
        }
        PInstanceLogElement e = new PInstanceLogElement(this.m_printCtx, this.m_query, this.m_format.getTableFormat());
        if (e.getEffectiveRowCount() <= 0) {
            return null;
        }
        e.layout(0.0f, 0.0f, false, null);
        return e;
    }

    @Override
    public int getNumberOfPages() {
        return this.m_pages.size();
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (!this.havePage(pageIndex)) {
            throw new IndexOutOfBoundsException("No page index=" + pageIndex);
        }
        return this.getPageFormat();
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (!this.havePage(pageIndex)) {
            throw new IndexOutOfBoundsException("No page index=" + pageIndex);
        }
        return this;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (!this.havePage(pageIndex)) {
            return 1;
        }
        Rectangle r = new Rectangle(0, 0, (int)this.getPaper().getWidth(true), (int)this.getPaper().getHeight(true));
        Page page = this.getPage(pageIndex + 1);
        page.paint((Graphics2D)graphics, r, false, this.m_isCopy);
        this.getHeaderFooter().setCurrentPage(page);
        this.getHeaderFooter().paint((Graphics2D)graphics, r, false);
        this.getHeaderFooter().setCurrentPage(null);
        return 0;
    }

    private boolean havePage(int pageIndex) {
        return pageIndex >= 0 && pageIndex < this.getNumberOfPages();
    }

    public boolean isCopy() {
        return this.m_isCopy;
    }

    public void setCopy(boolean isCopy) {
        this.m_isCopy = isCopy;
    }

    @Override
    public DocFlavor getDocFlavor() {
        return DocFlavor.SERVICE_FORMATTED.PAGEABLE;
    }

    @Override
    public Object getPrintData() throws IOException {
        return this;
    }

    @Override
    public DocAttributeSet getAttributes() {
        return null;
    }

    @Override
    public Reader getReaderForText() throws IOException {
        return null;
    }

    @Override
    public InputStream getStreamForBytes() throws IOException {
        return null;
    }

    public void setPrintInfo(PrintInfo info) {
        this.m_PrintInfo = info;
    }

    public PrintInfo getPrintInfo() {
        return this.m_PrintInfo;
    }

    public void setChildPrintFormatDetails(MPrintFormatItem printFormatItem, PrintData printData) {
        this.childPrintFormatDetails.put(printFormatItem, printData);
    }

    public Map<MPrintFormatItem, PrintData> getChildPrintFormatDetails() {
        return this.childPrintFormatDetails;
    }

    private boolean isDisplayed(PrintData data, MPrintFormatItem item) {
        if (Util.isEmpty(item.getDisplayLogic())) {
            return true;
        }
        boolean display = Evaluator.evaluateLogic(new PrintDataEvaluatee(this.getPage(this.getPageNo()), data), item.getDisplayLogic());
        return display;
    }

    public static Boolean[] getColSuppressRepeats(MPrintFormat format) {
        if (format.isForm()) {
            return null;
        }
        ArrayList<Boolean> colSuppressRepeats = new ArrayList<Boolean>();
        int c = 0;
        while (c < format.getItemCount()) {
            MPrintFormatItem item = format.getItem(c);
            if (item.isPrinted()) {
                colSuppressRepeats.add(item.isSuppressRepeats());
            }
            ++c;
        }
        return colSuppressRepeats.toArray(new Boolean[0]);
    }
}

