import errorHandlingHelper from "../../../utils/errorHandlingHelper"

const handleFunc = async (event: any) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const serviceToken = config.api.idempieretoken
  const body = await readBody(event)

  if (!serviceToken) {
    return { status: 500, message: 'Service token not configured' }
  }

  if (!body.id) {
    return { status: 400, message: 'Missing user id' }
  }

  const res: any = await $fetch(`${config.api.url}/models/ad_user/${body.id}`, {
    method: 'PUT',
    headers: {
      'Content-Type': 'application/json',
      Accept: 'application/json',
      Authorization: 'Bearer ' + serviceToken
    },
    body: {
      eMail: body.email,
      tableName: 'AD_User'
    }
  })

  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    data = errorHandlingHelper(err?.data ?? err, err)
  }

  return data
})
