import { string } from 'alga-js'
import postgrestHelper from "../../utils/postgrestHelper"

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    //@ts-ignore
    const res: any[] = await postgrestHelper(event, `xy_mat_ad_preference`, 'GET', null)
    if(res) {
      for(let record of Array.from(res)) {
        data[record.attribute] = {
          id: record.value,
          identifier: record.identifier,
          attribute: record.attribute
        }
      }
    }
  } catch(error: any) {
    data = { 
      status: error.status || error.statusCode || 500,
      message: error.detail || error.message || error.statusMessage
    }
  }

  return data
})