import { string } from 'alga-js'
import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import getTokenHelper from "../../../utils/getTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const query = getQuery(event)

  const newFilter = query?.product_id ? string.urlEncode(`m_product_id eq ${query.product_id}`) : ''
  const res: any = await fetchHelper(event, `models/m_storage?$filter=${newFilter}&$expand=m_locator_id&$orderby=${string.urlEncode('QtyOnHand desc')}`, 'GET', token, null)
  if(res) {
    //data = res
    const newWarehouseId = query?.warehouse_id ?? null
    if(newWarehouseId) {
      data['record'] = res.records.filter((item: any) => {
        return Number(item.M_Locator_ID.M_Warehouse_ID.id) === Number(newWarehouseId)
      })?.[0] ?? {}
    } else {
      data['record'] = res.records?.[0] ?? {}
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})