import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.shippingProcessorId) {
    newObjValue = {...newObjValue, M_ShippingProcessor_ID: {
      id: body.shippingProcessorId,
      tableName: 'M_ShippingProcessor'
    }}
  }
  if(body.shipperCfgId) {
    newObjValue = {...newObjValue, M_ShipperCfg_ID: {
      id: body.shipperCfgId,
      tableName: 'M_ShipperCfg'
    }}
  }
  if(body.partnerId) {
    newObjValue = {...newObjValue, C_BPartner_ID: {
      id: body.partnerId,
      tableName: 'C_BPartner'
    }}
  }

  const res: any = await event.context.fetch('models/m_shippingprocessor', 'POST', token, {
    AD_Org_ID: {
      id: body.organizationId,
      tableName: 'AD_Org'
    },
    isActive: body.isActive,
    name: body.name,
    ...newObjValue,
    tableName: 'M_Shippingprocessor'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})