'use strict';

const rekaUi = require('reka-ui');

const Accordion = {
  Content: rekaUi.AccordionContent,
  Header: rekaUi.AccordionHeader,
  Item: rekaUi.AccordionItem,
  Root: rekaUi.AccordionRoot,
  Trigger: rekaUi.AccordionTrigger
};
const AlertDialog = {
  Root: rekaUi.AlertDialogRoot,
  Trigger: rekaUi.AlertDialogTrigger,
  Portal: rekaUi.AlertDialogPortal,
  Content: rekaUi.AlertDialogContent,
  Overlay: rekaUi.AlertDialogOverlay,
  Cancel: rekaUi.AlertDialogCancel,
  Title: rekaUi.AlertDialogTitle,
  Description: rekaUi.AlertDialogDescription,
  Action: rekaUi.AlertDialogAction
};
const Avatar = {
  Root: rekaUi.AvatarRoot,
  Fallback: rekaUi.AvatarFallback,
  Image: rekaUi.AvatarImage
};
const Calendar = {
  Root: rekaUi.CalendarRoot,
  Header: rekaUi.CalendarHeader,
  Heading: rekaUi.CalendarHeading,
  Grid: rekaUi.CalendarGrid,
  Cell: rekaUi.CalendarCell,
  HeadCell: rekaUi.CalendarHeadCell,
  Next: rekaUi.CalendarNext,
  Prev: rekaUi.CalendarPrev,
  GridHead: rekaUi.CalendarGridHead,
  GridBody: rekaUi.CalendarGridBody,
  GridRow: rekaUi.CalendarGridRow,
  CellTrigger: rekaUi.CalendarCellTrigger
};
const Checkbox = {
  GroupRoot: rekaUi.CheckboxGroupRoot,
  Root: rekaUi.CheckboxRoot,
  Indicator: rekaUi.CheckboxIndicator
};
const Collapsible = {
  Root: rekaUi.CollapsibleRoot,
  Trigger: rekaUi.CollapsibleTrigger,
  Content: rekaUi.CollapsibleContent
};
const Combobox = {
  Root: rekaUi.ComboboxRoot,
  Input: rekaUi.ComboboxInput,
  Anchor: rekaUi.ComboboxAnchor,
  Empty: rekaUi.ComboboxEmpty,
  Trigger: rekaUi.ComboboxTrigger,
  Cancel: rekaUi.ComboboxCancel,
  Group: rekaUi.ComboboxGroup,
  Label: rekaUi.ComboboxLabel,
  Content: rekaUi.ComboboxContent,
  Viewport: rekaUi.ComboboxViewport,
  Virtualizer: rekaUi.ComboboxVirtualizer,
  Item: rekaUi.ComboboxItem,
  ItemIndicator: rekaUi.ComboboxItemIndicator,
  Separator: rekaUi.ComboboxSeparator,
  Arrow: rekaUi.ComboboxArrow,
  Portal: rekaUi.ComboboxPortal
};
const ContextMenu = {
  Root: rekaUi.ContextMenuRoot,
  Trigger: rekaUi.ContextMenuTrigger,
  Portal: rekaUi.ContextMenuPortal,
  Content: rekaUi.ContextMenuContent,
  Arrow: rekaUi.ContextMenuArrow,
  Item: rekaUi.ContextMenuItem,
  Group: rekaUi.ContextMenuGroup,
  Separator: rekaUi.ContextMenuSeparator,
  CheckboxItem: rekaUi.ContextMenuCheckboxItem,
  ItemIndicator: rekaUi.ContextMenuItemIndicator,
  Label: rekaUi.ContextMenuLabel,
  RadioGroup: rekaUi.ContextMenuRadioGroup,
  RadioItem: rekaUi.ContextMenuRadioItem,
  Sub: rekaUi.ContextMenuSub,
  SubContent: rekaUi.ContextMenuSubContent,
  SubTrigger: rekaUi.ContextMenuSubTrigger
};
const DateField = {
  Root: rekaUi.DateFieldRoot,
  Input: rekaUi.DateFieldInput
};
const DatePicker = {
  Root: rekaUi.DatePickerRoot,
  Header: rekaUi.DatePickerHeader,
  Heading: rekaUi.DatePickerHeading,
  Grid: rekaUi.DatePickerGrid,
  Cell: rekaUi.DatePickerCell,
  HeadCell: rekaUi.DatePickerHeadCell,
  Next: rekaUi.DatePickerNext,
  Prev: rekaUi.DatePickerPrev,
  GridHead: rekaUi.DatePickerGridHead,
  GridBody: rekaUi.DatePickerGridBody,
  GridRow: rekaUi.DatePickerGridRow,
  CellTrigger: rekaUi.DatePickerCellTrigger,
  Input: rekaUi.DatePickerInput,
  Calendar: rekaUi.DatePickerCalendar,
  Field: rekaUi.DatePickerField,
  Anchor: rekaUi.DatePickerAnchor,
  Arrow: rekaUi.DatePickerArrow,
  Close: rekaUi.DatePickerClose,
  Trigger: rekaUi.DatePickerTrigger,
  Content: rekaUi.DatePickerContent
};
const DateRangePicker = {
  Root: rekaUi.DateRangePickerRoot,
  Header: rekaUi.DateRangePickerHeader,
  Heading: rekaUi.DateRangePickerHeading,
  Grid: rekaUi.DateRangePickerGrid,
  Cell: rekaUi.DateRangePickerCell,
  HeadCell: rekaUi.DateRangePickerHeadCell,
  Next: rekaUi.DateRangePickerNext,
  Prev: rekaUi.DateRangePickerPrev,
  GridHead: rekaUi.DateRangePickerGridHead,
  GridBody: rekaUi.DateRangePickerGridBody,
  GridRow: rekaUi.DateRangePickerGridRow,
  CellTrigger: rekaUi.DateRangePickerCellTrigger,
  Input: rekaUi.DateRangePickerInput,
  Calendar: rekaUi.DateRangePickerCalendar,
  Field: rekaUi.DateRangePickerField,
  Anchor: rekaUi.DateRangePickerAnchor,
  Arrow: rekaUi.DateRangePickerArrow,
  Close: rekaUi.DateRangePickerClose,
  Trigger: rekaUi.DateRangePickerTrigger,
  Content: rekaUi.DateRangePickerContent
};
const DateRangeField = {
  Root: rekaUi.DateRangeFieldRoot,
  Input: rekaUi.DateRangeFieldInput
};
const Dialog = {
  Root: rekaUi.DialogRoot,
  Trigger: rekaUi.DialogTrigger,
  Portal: rekaUi.DialogPortal,
  Content: rekaUi.DialogContent,
  Overlay: rekaUi.DialogOverlay,
  Close: rekaUi.DialogClose,
  Title: rekaUi.DialogTitle,
  Description: rekaUi.DialogDescription
};
const DropdownMenu = {
  Root: rekaUi.DropdownMenuRoot,
  Trigger: rekaUi.DropdownMenuTrigger,
  Portal: rekaUi.DropdownMenuPortal,
  Content: rekaUi.DropdownMenuContent,
  Arrow: rekaUi.DropdownMenuArrow,
  Item: rekaUi.DropdownMenuItem,
  Group: rekaUi.DropdownMenuGroup,
  Separator: rekaUi.DropdownMenuSeparator,
  CheckboxItem: rekaUi.DropdownMenuCheckboxItem,
  ItemIndicator: rekaUi.DropdownMenuItemIndicator,
  Label: rekaUi.DropdownMenuLabel,
  RadioGroup: rekaUi.DropdownMenuRadioGroup,
  RadioItem: rekaUi.DropdownMenuRadioItem,
  Sub: rekaUi.DropdownMenuSub,
  SubContent: rekaUi.DropdownMenuSubContent,
  SubTrigger: rekaUi.DropdownMenuSubTrigger
};
const Editable = {
  Root: rekaUi.EditableRoot,
  Area: rekaUi.EditableArea,
  Input: rekaUi.EditableInput,
  Preview: rekaUi.EditablePreview,
  SubmitTrigger: rekaUi.EditableSubmitTrigger,
  CancelTrigger: rekaUi.EditableCancelTrigger,
  EditTrigger: rekaUi.EditableEditTrigger
};
const HoverCard = {
  Root: rekaUi.HoverCardRoot,
  Trigger: rekaUi.HoverCardTrigger,
  Portal: rekaUi.HoverCardPortal,
  Content: rekaUi.HoverCardContent,
  Arrow: rekaUi.HoverCardArrow
};
const Listbox = {
  Root: rekaUi.ListboxRoot,
  Content: rekaUi.ListboxContent,
  Filter: rekaUi.ListboxFilter,
  Item: rekaUi.ListboxItem,
  ItemIndicator: rekaUi.ListboxItemIndicator,
  Virtualizer: rekaUi.ListboxVirtualizer,
  Group: rekaUi.ListboxGroup,
  GroupLabel: rekaUi.ListboxGroupLabel
};
const Menubar = {
  Root: rekaUi.MenubarRoot,
  Trigger: rekaUi.MenubarTrigger,
  Portal: rekaUi.MenubarPortal,
  Content: rekaUi.MenubarContent,
  Arrow: rekaUi.MenubarArrow,
  Item: rekaUi.MenubarItem,
  Group: rekaUi.MenubarGroup,
  Separator: rekaUi.MenubarSeparator,
  CheckboxItem: rekaUi.MenubarCheckboxItem,
  ItemIndicator: rekaUi.MenubarItemIndicator,
  Label: rekaUi.MenubarLabel,
  RadioGroup: rekaUi.MenubarRadioGroup,
  RadioItem: rekaUi.MenubarRadioItem,
  Sub: rekaUi.MenubarSub,
  SubContent: rekaUi.MenubarSubContent,
  SubTrigger: rekaUi.MenubarSubTrigger,
  Menu: rekaUi.MenubarMenu
};
const NavigationMenu = {
  Root: rekaUi.NavigationMenuRoot,
  Content: rekaUi.NavigationMenuContent,
  Indicator: rekaUi.NavigationMenuIndicator,
  Item: rekaUi.NavigationMenuItem,
  Link: rekaUi.NavigationMenuLink,
  List: rekaUi.NavigationMenuList,
  Sub: rekaUi.NavigationMenuSub,
  Trigger: rekaUi.NavigationMenuTrigger,
  Viewport: rekaUi.NavigationMenuViewport
};
const NumberField = {
  Root: rekaUi.NumberFieldRoot,
  Input: rekaUi.NumberFieldInput,
  Increment: rekaUi.NumberFieldIncrement,
  Decrement: rekaUi.NumberFieldDecrement
};
const Pagination = {
  Root: rekaUi.PaginationRoot,
  Ellipsis: rekaUi.PaginationEllipsis,
  First: rekaUi.PaginationFirst,
  Last: rekaUi.PaginationLast,
  List: rekaUi.PaginationList,
  ListItem: rekaUi.PaginationListItem,
  Next: rekaUi.PaginationNext,
  Prev: rekaUi.PaginationPrev
};
const PinInput = {
  Root: rekaUi.PinInputRoot,
  Input: rekaUi.PinInputInput
};
const Popover = {
  Root: rekaUi.PopoverRoot,
  Trigger: rekaUi.PopoverTrigger,
  Portal: rekaUi.PopoverPortal,
  Content: rekaUi.PopoverContent,
  Arrow: rekaUi.PopoverArrow,
  Close: rekaUi.PopoverClose,
  Anchor: rekaUi.PopoverAnchor
};
const Progress = {
  Root: rekaUi.ProgressRoot,
  Indicator: rekaUi.ProgressIndicator
};
const RadioGroup = {
  Root: rekaUi.RadioGroupRoot,
  Item: rekaUi.RadioGroupItem,
  Indicator: rekaUi.RadioGroupIndicator
};
const RangeCalendar = {
  Root: rekaUi.RangeCalendarRoot,
  Header: rekaUi.RangeCalendarHeader,
  Heading: rekaUi.RangeCalendarHeading,
  Grid: rekaUi.RangeCalendarGrid,
  Cell: rekaUi.RangeCalendarCell,
  HeadCell: rekaUi.RangeCalendarHeadCell,
  Next: rekaUi.RangeCalendarNext,
  Prev: rekaUi.RangeCalendarPrev,
  GridHead: rekaUi.RangeCalendarGridHead,
  GridBody: rekaUi.RangeCalendarGridBody,
  GridRow: rekaUi.RangeCalendarGridRow,
  CellTrigger: rekaUi.RangeCalendarCellTrigger
};
const ScrollArea = {
  Root: rekaUi.ScrollAreaRoot,
  Viewport: rekaUi.ScrollAreaViewport,
  Scrollbar: rekaUi.ScrollAreaScrollbar,
  Thumb: rekaUi.ScrollAreaThumb,
  Corner: rekaUi.ScrollAreaCorner
};
const Select = {
  Root: rekaUi.SelectRoot,
  Trigger: rekaUi.SelectTrigger,
  Portal: rekaUi.SelectPortal,
  Content: rekaUi.SelectContent,
  Arrow: rekaUi.SelectArrow,
  Separator: rekaUi.SelectSeparator,
  ItemIndicator: rekaUi.SelectItemIndicator,
  Label: rekaUi.SelectLabel,
  Group: rekaUi.SelectGroup,
  Item: rekaUi.SelectItem,
  ItemText: rekaUi.SelectItemText,
  Viewport: rekaUi.SelectViewport,
  ScrollUpButton: rekaUi.SelectScrollUpButton,
  ScrollDownButton: rekaUi.SelectScrollDownButton,
  Value: rekaUi.SelectValue,
  Icon: rekaUi.SelectIcon
};
const Slider = {
  Root: rekaUi.SliderRoot,
  Thumb: rekaUi.SliderThumb,
  Track: rekaUi.SliderTrack,
  Range: rekaUi.SliderRange
};
const Splitter = {
  Group: rekaUi.SplitterGroup,
  Panel: rekaUi.SplitterPanel,
  ResizeHandle: rekaUi.SplitterResizeHandle
};
const Stepper = {
  Root: rekaUi.StepperRoot,
  Item: rekaUi.StepperItem,
  Trigger: rekaUi.StepperTrigger,
  Description: rekaUi.StepperDescription,
  Title: rekaUi.StepperTitle,
  Indicator: rekaUi.StepperIndicator,
  Separator: rekaUi.StepperSeparator
};
const Switch = {
  Root: rekaUi.SwitchRoot,
  Thumb: rekaUi.SwitchThumb
};
const Tabs = {
  Root: rekaUi.TabsRoot,
  List: rekaUi.TabsList,
  Content: rekaUi.TabsContent,
  Trigger: rekaUi.TabsTrigger,
  Indicator: rekaUi.TabsIndicator
};
const TagsInput = {
  Root: rekaUi.TagsInputRoot,
  Input: rekaUi.TagsInputInput,
  Item: rekaUi.TagsInputItem,
  ItemText: rekaUi.TagsInputItemText,
  ItemDelete: rekaUi.TagsInputItemDelete,
  Clear: rekaUi.TagsInputClear
};
const Toast = {
  Provider: rekaUi.ToastProvider,
  Root: rekaUi.ToastRoot,
  Action: rekaUi.ToastAction,
  Close: rekaUi.ToastClose,
  Viewport: rekaUi.ToastViewport,
  Title: rekaUi.ToastTitle,
  Description: rekaUi.ToastDescription
};
const ToggleGroup = {
  Root: rekaUi.ToggleGroupRoot,
  Item: rekaUi.ToggleGroupItem
};
const Toolbar = {
  Root: rekaUi.ToolbarRoot,
  Button: rekaUi.ToolbarButton,
  Link: rekaUi.ToolbarLink,
  ToggleGroup: rekaUi.ToolbarToggleGroup,
  ToggleItem: rekaUi.ToolbarToggleItem,
  Separator: rekaUi.ToolbarSeparator
};
const Tooltip = {
  Root: rekaUi.TooltipRoot,
  Trigger: rekaUi.TooltipTrigger,
  Content: rekaUi.TooltipContent,
  Arrow: rekaUi.TooltipArrow,
  Portal: rekaUi.TooltipPortal,
  Provider: rekaUi.TooltipProvider
};
const Tree = {
  Root: rekaUi.TreeRoot,
  Item: rekaUi.TreeItem,
  Virtualizer: rekaUi.TreeVirtualizer
};

exports.AspectRatio = rekaUi.AspectRatio;
exports.Label = rekaUi.Label;
exports.Presence = rekaUi.Presence;
exports.Separator = rekaUi.Separator;
exports.Toggle = rekaUi.Toggle;
exports.Viewport = rekaUi.Viewport;
exports.Accordion = Accordion;
exports.AlertDialog = AlertDialog;
exports.Avatar = Avatar;
exports.Calendar = Calendar;
exports.Checkbox = Checkbox;
exports.Collapsible = Collapsible;
exports.Combobox = Combobox;
exports.ContextMenu = ContextMenu;
exports.DateField = DateField;
exports.DatePicker = DatePicker;
exports.DateRangeField = DateRangeField;
exports.DateRangePicker = DateRangePicker;
exports.Dialog = Dialog;
exports.DropdownMenu = DropdownMenu;
exports.Editable = Editable;
exports.HoverCard = HoverCard;
exports.Listbox = Listbox;
exports.Menubar = Menubar;
exports.NavigationMenu = NavigationMenu;
exports.NumberField = NumberField;
exports.Pagination = Pagination;
exports.PinInput = PinInput;
exports.Popover = Popover;
exports.Progress = Progress;
exports.RadioGroup = RadioGroup;
exports.RangeCalendar = RangeCalendar;
exports.ScrollArea = ScrollArea;
exports.Select = Select;
exports.Slider = Slider;
exports.Splitter = Splitter;
exports.Stepper = Stepper;
exports.Switch = Switch;
exports.Tabs = Tabs;
exports.TagsInput = TagsInput;
exports.Toast = Toast;
exports.ToggleGroup = ToggleGroup;
exports.Toolbar = Toolbar;
exports.Tooltip = Tooltip;
exports.Tree = Tree;
