<!-- Please do not edit this file. Edit the `blah` field in the `package.json` instead. If in doubt, open an issue. -->


















# parse-url

 [![Support me on Patreon][badge_patreon]][patreon] [![Buy me a book][badge_amazon]][amazon] [![PayPal][badge_paypal_donate]][paypal-donations] [![Ask me anything](https://img.shields.io/badge/ask%20me-anything-1abc9c.svg)](https://github.com/IonicaBizau/ama) [![Version](https://img.shields.io/npm/v/parse-url.svg)](https://www.npmjs.com/package/parse-url) [![Downloads](https://img.shields.io/npm/dt/parse-url.svg)](https://www.npmjs.com/package/parse-url) [![Get help on Codementor](https://cdn.codementor.io/badges/get_help_github.svg)](https://www.codementor.io/johnnyb?utm_source=github&utm_medium=button&utm_term=johnnyb&utm_campaign=github)

<a href="https://www.buymeacoffee.com/H96WwChMy" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/yellow_img.png" alt="Buy Me A Coffee"></a>







> An advanced url parser supporting git urls too.






For low-level path parsing, check out [`parse-path`](https://github.com/IonicaBizau/parse-path). This very module is designed to parse urls. By default the urls are normalized.












## :cloud: Installation

```sh
# Using npm
npm install --save parse-url

# Using yarn
yarn add parse-url
```













## :clipboard: Example



```js
// Dependencies
import parseUrl from "parse-url";

console.log(parseUrl("http://ionicabizau.net/blog"))
// {
//   protocols: [ 'http' ],
//   protocol: 'http',
//   port: '',
//   resource: 'ionicabizau.net',
//   user: '',
//   password: '',
//   pathname: '/blog',
//   hash: '',
//   search: '',
//   href: 'http://ionicabizau.net/blog',
//   query: {}
// }

console.log(parseUrl("http://domain.com/path/name?foo=bar&bar=42#some-hash"))
// {
//   protocols: [ 'http' ],
//   protocol: 'http',
//   port: '',
//   resource: 'domain.com',
//   user: '',
//   password: '',
//   pathname: '/path/name',
//   hash: 'some-hash',
//   search: 'foo=bar&bar=42',
//   href: 'http://domain.com/path/name?foo=bar&bar=42#some-hash',
//   query: { foo: 'bar', bar: '42' }
// }

// If you want to parse fancy Git urls, turn off the automatic url normalization
console.log(parseUrl("git+ssh://git@host.xz/path/name.git", false))
// {
//   protocols: [ 'git', 'ssh' ],
//   protocol: 'git',
//   port: '',
//   resource: 'host.xz',
//   user: 'git',
//   password: '',
//   pathname: '/path/name.git',
//   hash: '',
//   search: '',
//   href: 'git+ssh://git@host.xz/path/name.git',
//   query: {}
// }

console.log(parseUrl("git@github.com:IonicaBizau/git-stats.git", false))
// {
//   protocols: [ 'ssh' ],
//   protocol: 'ssh',
//   port: '',
//   resource: 'github.com',
//   user: 'git',
//   password: '',
//   pathname: '/IonicaBizau/git-stats.git',
//   hash: '',
//   search: '',
//   href: 'git@github.com:IonicaBizau/git-stats.git',
//   query: {}
// }
```












## :question: Get Help

There are few ways to get help:



 1. Please [post questions on Stack Overflow](https://stackoverflow.com/questions/ask). You can open issues with questions, as long you add a link to your Stack Overflow question.
 2. For bug reports and feature requests, open issues. :bug:
 3. For direct and quick help, you can [use Codementor](https://www.codementor.io/johnnyb). :rocket:







## :memo: Documentation


### `interopDefaultLegacy()`
#__PURE__

### `parseUrl(url, normalize)`
Parses the input url.

**Note**: This *throws* if invalid urls are provided.

#### Params

- **String** `url`: The input url.
- **Boolean|Object** `normalize`: Whether to normalize the url or not.                         Default is `false`. If `true`, the url will
                        be normalized. If an object, it will be the
                        options object sent to [`normalize-url`](https://github.com/sindresorhus/normalize-url).

                        For SSH urls, normalize won't work.

#### Return
- **Object** An object containing the following fields:
   - `protocols` (Array): An array with the url protocols (usually it has one element).
   - `protocol` (String): The first protocol, `"ssh"` (if the url is a ssh url) or `"file"`.
   - `port` (null|Number): The domain port.
   - `resource` (String): The url domain (including subdomains).
   - `host` (String):  The fully qualified domain name of a network host, or its IP address.
   - `user` (String): The authentication user (usually for ssh urls).
   - `pathname` (String): The url pathname.
   - `hash` (String): The url hash.
   - `search` (String): The url querystring value.
   - `href` (String): The input url.
   - `query` (Object): The url querystring, parsed as object.
   - `parse_failed` (Boolean): Whether the parsing failed or not.

### GIT_RE

([a-zA-Z_][a-zA-Z0-9_-]{0,31}) Try to match the user
([\w\.\-@]+) Match the host/resource
(([\~,\.\w,\-,\_,\/,\s]|%[0-9A-Fa-f]{2})+?(?:\.git|\/)?) Match the path, allowing spaces/white














## :yum: How to contribute
Have an idea? Found a bug? See [how to contribute][contributing].


## :sparkling_heart: Support my projects
I open-source almost everything I can, and I try to reply to everyone needing help using these projects. Obviously,
this takes time. You can integrate and use these projects in your applications *for free*! You can even change the source code and redistribute (even resell it).

However, if you get some profit from this or just want to encourage me to continue creating stuff, there are few ways you can do it:


 - Starring and sharing the projects you like :rocket:
 - [![Buy me a book][badge_amazon]][amazon]—I love books! I will remember you after years if you buy me one. :grin: :book:
 - [![PayPal][badge_paypal]][paypal-donations]—You can make one-time donations via PayPal. I'll probably buy a ~~coffee~~ tea. :tea:
 - [![Support me on Patreon][badge_patreon]][patreon]—Set up a recurring monthly donation and you will get interesting news about what I'm doing (things that I don't share with everyone).
 - **Bitcoin**—You can send me bitcoins at this address (or scanning the code below): `1P9BRsmazNQcuyTxEqveUsnf5CERdq35V6`

    ![](https://i.imgur.com/z6OQI95.png)


Thanks! :heart:
















## :dizzy: Where is this library used?
If you are using this library in one of your projects, add it in this list. :sparkles:

 - `@_nomtek/react-native-shimmer-animation`
 - `@aabelmann/ui-layer`
 - `@ali5049/react-native-buttons`
 - `@amirdiafi/react-native-ios-haptics`
 - `@angga30prabu/wa-modified`
 - `@apardellass/react-native-audio-stream`
 - `@aysea/react-native-ui-library`
 - `@azalpacir/react-native-dhp-printer`
 - `@brantalikp/rn-resize`
 - `@buganto/client`
 - `@con-test/react-native-concent-common`
 - `@cs6/react-native-test-native-view-library`
 - `@damruravihara/react-native-testing-package`
 - `@dataparty/api`
 - `@enkeledi/react-native-week-month-date-picker`
 - `@extrieve_technologies/quickcapture_react_native`
 - `@foundernetes/machines`
 - `@foundernetes/metal-debian`
 - `@geeky-apo/react-native-advanced-clipboard`
 - `@hbglobal/react-native-actions-shortcuts`
 - `@heycharge/heycharge-react-native-sdk`
 - `@hieuquang2212/form`
 - `@hstech/utils`
 - `@idas1/ui-component-lib`
 - `@jfilipe-sparta/react-native-module_2`
 - `@jimengio/mocked-proxy`
 - `@klevn/solid-router`
 - `@lakutata-module/service`
 - `@mockswitch/cli`
 - `@ndla/source-map-resolver`
 - `@npm_fluentco/adflow-react-native-sdk`
 - `@oiti/rn-liveness2d`
 - `@open-wa/wa-automate`
 - `@phpboyscout/semantic-release-gitlab`
 - `@phuocnb/semrelease-gitlab`
 - `@positionex/position-sdk`
 - `@praella/localisationist`
 - `@qiwi/sourcecrumbs`
 - `@react-native-ui-design/button`
 - `@roq/ui-react`
 - `@roshub/api`
 - `@saad27/react-native-bottom-tab-tour`
 - `@semantic-release/gitlab`
 - `@sephriot/react-native-persistable-uri`
 - `@sidghimire/react-native-mapbox-navigation`
 - `@taingo97/react-native-awesome-module`
 - `@taingo97/react-native-bluetooth-xprinter`
 - `@taingo97/react-native-expo-key-rsa-kt`
 - `@taingo97/react-native-generate-key-rsa`
 - `@taingo97/react-native-key-rsa`
 - `@taingo97/react-native-print-xprinter`
 - `@taingo97/react-native-rsa-expo`
 - `@taingo97/react-native-sunmi-printer`
 - `@taingo97/react-native-telpo-printer`
 - `@teles1-semantic-release/gitlab`
 - `@thinxviewx/core-rn`
 - `@tomw2w/my-nuxt-layer`
 - `@valifysolutions/react-native-vidvliveness`
 - `@wecraftapps/react-native-use-keyboard`
 - `agent-get-agent`
 - `angularvezba`
 - `apaas-track`
 - `api-reach-react-native-fix`
 - `archlibrary`
 - `arifbudixz`
 - `astra-ufo-sdk`
 - `awesome-module-kd`
 - `ba-js-cookie-banner`
 - `begg`
 - `bilibili2local`
 - `biometric-st`
 - `birken-react-native-community-image-editor`
 - `blitzzz`
 - `build-plugin-ssr`
 - `candlelabssdk`
 - `checkbox-component`
 - `cli-live-tutorial`
 - `delta-screen`
 - `demo-test-scrn`
 - `deploy-versioning`
 - `design-system-trial-milyasbpa`
 - `dogandev-simple-toast`
 - `egg-muc-custom-loader`
 - `electron-info`
 - `eval-spider`
 - `expo-renavigate`
 - `fawaterak-online-payment`
 - `fawatrak-online-payment`
 - `fixed_form_builder`
 - `fluent.adflow.reactnativesdk`
 - `fluent.adflow.reactnativesdk-alpha`
 - `fmsl`
 - `framework_test_library_sixdee`
 - `framework_test_library_sixdee_new`
 - `framework_test_library_sixdee_new_new`
 - `fuge-runner`
 - `gamification-integration-new`
 - `gaurav-react-native-loop`
 - `generator-bootstrap-boilerplate-template`
 - `genz-native-elements`
 - `gh-monoproject-cli`
 - `git-up`
 - `gitlab-backup-util-harduino`
 - `griffin-ui-library`
 - `heroku-wp-environment-sync`
 - `hologit`
 - `hong1-utils`
 - `hubot-will-it-connect`
 - `hui-plugin-wss`
 - `ipsamvel`
 - `jamuskalim`
 - `jordy-frijters-test-lib`
 - `kakapo`
 - `khaled-salem-custom-components`
 - `luojia-cli-dev`
 - `markdownalint-cli2`
 - `michael-stun`
 - `microbe.js`
 - `miguelcostero-ng2-toasty`
 - `native-apple-login`
 - `native-date-picker-module`
 - `native-google-login`
 - `native-kakao-login`
 - `native-modal-damage-vehicle`
 - `native-zip`
 - `ndla-source-map-resolver`
 - `new-awesome-4321`
 - `njs-wa-auto`
 - `normalize-id`
 - `normalize-ssh`
 - `npm_one_12_34_1_`
 - `npm_one_1_2_3`
 - `npm_one_2_2`
 - `npm_qwerty`
 - `parse-db-uri`
 - `pasbeaucoupmoinsrave`
 - `payutesting`
 - `pnm-yph-react-native-custom-components`
 - `project-wajs-dv`
 - `pyreswap-sdk`
 - `quickcapture_react_native`
 - `raact-native-arunramya151`
 - `reac-native-arun-ramya-test`
 - `react-native-addition`
 - `react-native-android-video-player-view`
 - `react-native-animate-text`
 - `react-native-app-bubble`
 - `react-native-app-integrity-checksum`
 - `react-native-arps-authorize-net`
 - `react-native-arun-ramya-test`
 - `react-native-arunjeyam1987`
 - `react-native-arunmeena1987`
 - `react-native-arunramya151`
 - `react-native-auth-service-client`
 - `react-native-aventonfacetec-aventon`
 - `react-native-awesome-android-123`
 - `react-native-awesome-android-123-zeotap`
 - `react-native-awesome-module-latest`
 - `react-native-awesome-module-two`
 - `react-native-azure-communication-services`
 - `react-native-badge-control`
 - `react-native-basic-app`
 - `react-native-basic-screen`
 - `react-native-biometric-authenticate`
 - `react-native-bleccs-components`
 - `react-native-bluetooth-device-detect`
 - `react-native-bridge-package`
 - `react-native-bubble-chart`
 - `react-native-build-vesion-getter`
 - `react-native-check-component`
 - `react-native-chenaar`
 - `react-native-components-design`
 - `react-native-conekta-card-tokenizer`
 - `react-native-contact-list`
 - `react-native-cplus`
 - `react-native-create-video-thumbnail`
 - `react-native-ctp-odp`
 - `react-native-dhp-printer`
 - `react-native-dimensions-layout`
 - `react-native-dsphoto-module`
 - `react-native-fedlight-dsm`
 - `react-native-flyy`
 - `react-native-get-countries`
 - `react-native-ghn-ekyc`
 - `react-native-innity-2`
 - `react-native-innity-remaster`
 - `react-native-input-library`
 - `react-native-is7`
 - `react-native-jsi-device-info`
 - `react-native-kakao-maps`
 - `react-native-klarify-ios`
 - `react-native-klarify-ui`
 - `react-native-klc`
 - `react-native-lib-test-rn-1`
 - `react-native-library-testing-422522`
 - `react-native-line-login-android`
 - `react-native-login-demo-test`
 - `react-native-lowlatency`
 - `react-native-loyalty-platforms`
 - `react-native-manh-test`
 - `react-native-manual-ios-sdk`
 - `react-native-modal-progress-bar`
 - `react-native-module-arge`
 - `react-native-module-for-testing`
 - `react-native-multiplier-altroncoso`
 - `react-native-multiplier-component`
 - `react-native-multiplier-demo`
 - `react-native-multiplier2`
 - `react-native-multiply`
 - `react-native-multiply-component`
 - `react-native-multiselector`
 - `react-native-mun-kit`
 - `react-native-my-first-try-arun-ramya`
 - `react-native-native-audio-engine`
 - `react-native-native-ios-test1`
 - `react-native-nativewind`
 - `react-native-nghia-sharering`
 - `react-native-nice-learning`
 - `react-native-omental-framework`
 - `react-native-onramp`
 - `react-native-payu-payment-testing`
 - `react-native-plugpag-wrapper`
 - `react-native-progress-arrow`
 - `react-native-pulsator-native`
 - `react-native-rabbitmq-all`
 - `react-native-radio-bic-group-lib`
 - `react-native-reanimated-sortable-list`
 - `react-native-recent-framework-update`
 - `react-native-responsive-helper`
 - `react-native-responsive-size`
 - `react-native-return-usb-data`
 - `react-native-rn-app`
 - `react-native-rn-icons-library`
 - `react-native-rom-components`
 - `react-native-rtn-ips-poslin-test`
 - `react-native-sandycomponent`
 - `react-native-savczuk-feature-library`
 - `react-native-sayhello-module`
 - `react-native-screen-idle-timer`
 - `react-native-scroll-tab-to-index`
 - `react-native-shared-gesture`
 - `react-native-simple-timeline`
 - `react-native-sixdee_test_lib`
 - `react-native-sp-test-common`
 - `react-native-teknoctrl-components`
 - `react-native-test-comlibrary`
 - `react-native-test-module-hhh`
 - `react-native-test-view`
 - `react-native-ticker-tape`
 - `react-native-tone-framework`
 - `react-native-transtracker-library`
 - `react-native-ui-components-library`
 - `react-native-uvc-camera-android`
 - `react-native-version-app`
 - `react-native-volume-phisical`
 - `react-native-withframework-check`
 - `react-native-wtf`
 - `react-native-xiaomi-permissions`
 - `react-native-xprinter-thermal-ble`
 - `react-native-ytximkit`
 - `reactnatively`
 - `reat-native-multiplierkpr`
 - `refinejs-repo`
 - `rn-adyen-dropin`
 - `rn-agora-ios-m`
 - `rn-circular-chart`
 - `rn-counter-demo`
 - `rn-session-multiplier-demo`
 - `rn-tm-notify`
 - `rn_unique_device_id`
 - `robots-agent`
 - `rocomp`
 - `smart_one_connect`
 - `soajs.repositories`
 - `sourcecrumbs`
 - `stun`
 - `sushi-sdk-ftm`
 - `test-haptik-lib`
 - `test-zeo-collect`
 - `ts-scraper`
 - `tumblr-text`
 - `url-local`
 - `vision-camera-base64-resized`
 - `vision-camera-plugin-face-detector`
 - `vision-camera-plugin-scan-faces`
 - `vrt-cli`
 - `vue-cli-plugin-ice-builder`
 - `vue-cli-plugin-ut-builder`
 - `wa-frikz`
 - `wander-cli`
 - `warp-api`
 - `warp-server`
 - `web-yii2`
 - `wifi_configuration_package`
 - `workpad`
 - `xbuilder-forms`
 - `xl-git-up`
 - `yangtao-js`
 - `zeo-collect`
 - `zzzxxxyyy321123`











## :scroll: License

[MIT][license] © [Ionică Bizău][website]






[license]: /LICENSE
[website]: https://ionicabizau.net
[contributing]: /CONTRIBUTING.md
[docs]: /DOCUMENTATION.md
[badge_patreon]: https://ionicabizau.github.io/badges/patreon.svg
[badge_amazon]: https://ionicabizau.github.io/badges/amazon.svg
[badge_paypal]: https://ionicabizau.github.io/badges/paypal.svg
[badge_paypal_donate]: https://ionicabizau.github.io/badges/paypal_donate.svg
[patreon]: https://www.patreon.com/ionicabizau
[amazon]: http://amzn.eu/hRo9sIZ
[paypal-donations]: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RVXDDLKKLQRJW
