// https://github.com/cloudflare/workerd/blob/main/src/node/crypto.ts

import workerdCrypto from "#workerd/node:crypto";

import {
  Cipher,
  Decipher,
  rng,
  prng,
  pseudoRandomBytes,
} from "unenv/node/crypto";

export {
  Cipher,
  Decipher,
  rng,
  prng,
  pseudoRandomBytes,
} from "unenv/node/crypto";

export const {
  webcrypto,
  Certificate,
  Cipheriv,
  Decipheriv,
  DiffieHellman,
  DiffieHellmanGroup,
  ECDH,
  Hash,
  Hmac,
  KeyObject,
  PrivateKeyObject,
  PublicKeyObject,
  SecretKeyObject,
  Sign,
  Verify,
  X509Certificate,
  checkPrime,
  checkPrimeSync,
  constants,
  createCipheriv,
  createDecipheriv,
  createDiffieHellman,
  createDiffieHellmanGroup,
  createECDH,
  createHash,
  createHmac,
  createPrivateKey,
  createPublicKey,
  createSecretKey,
  createSign,
  createVerify,
  diffieHellman,
  fips,
  generateKey,
  generateKeyPair,
  generateKeyPairSync,
  generateKeySync,
  generatePrime,
  generatePrimeSync,
  getCipherInfo,
  getCiphers,
  getCurves,
  getDiffieHellman,
  getFips,
  getHashes,
  hash,
  hkdf,
  hkdfSync,
  pbkdf2,
  pbkdf2Sync,
  privateDecrypt,
  privateEncrypt,
  publicDecrypt,
  publicEncrypt,
  randomBytes,
  randomFill,
  randomFillSync,
  randomInt,
  randomUUID,
  scrypt,
  scryptSync,
  secureHeapUsed,
  setEngine,
  setFips,
  sign,
  subtle,
  timingSafeEqual,
  verify,
} = workerdCrypto;

export const getRandomValues = workerdCrypto.getRandomValues.bind(
  workerdCrypto.webcrypto
);

export default {
  // Polyfill
  Cipher,
  Decipher,
  rng,
  prng,
  pseudoRandomBytes,
  // Native
  webcrypto,
  getRandomValues,
  Certificate,
  Cipheriv,
  Decipheriv,
  DiffieHellman,
  DiffieHellmanGroup,
  ECDH,
  Hash,
  Hmac,
  KeyObject,
  PrivateKeyObject,
  PublicKeyObject,
  SecretKeyObject,
  Sign,
  Verify,
  X509Certificate,
  checkPrime,
  checkPrimeSync,
  constants,
  createCipheriv,
  createDecipheriv,
  createDiffieHellman,
  createDiffieHellmanGroup,
  createECDH,
  createHash,
  createHmac,
  createPrivateKey,
  createPublicKey,
  createSecretKey,
  createSign,
  createVerify,
  diffieHellman,
  fips,
  generateKey,
  generateKeyPair,
  generateKeyPairSync,
  generateKeySync,
  generatePrime,
  generatePrimeSync,
  getCipherInfo,
  getCiphers,
  getCurves,
  getDiffieHellman,
  getFips,
  getHashes,
  hash,
  hkdf,
  hkdfSync,
  pbkdf2,
  pbkdf2Sync,
  privateDecrypt,
  privateEncrypt,
  publicDecrypt,
  publicEncrypt,
  randomBytes,
  randomFill,
  randomFillSync,
  randomInt,
  randomUUID,
  scrypt,
  scryptSync,
  secureHeapUsed,
  setEngine,
  setFips,
  sign,
  subtle,
  timingSafeEqual,
  verify,
};
